/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.hh.pdgm.grouper;

import com.mmm.cms.hh.pdgm.data.files.TableNames_EN;
import com.mmm.cms.hh.pdgm.data.interf.DataLoaderIF;
import com.mmm.cms.hh.pdgm.data.loader.DataLoader;
import com.mmm.cms.hh.pdgm.grouper.ClaimManagerIF;
import com.mmm.cms.hh.pdgm.reference.objects.ClaimFieldObject;
import com.mmm.cms.hh.pdgm.reference.objects.ClaimLayoutObject;
import com.mmm.cms.hh.pdgm.reference.objects.ClaimObject;
import com.mmm.cms.hh2.xml.layout.claim.ClaimField;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClaimManager
implements ClaimManagerIF {
    DataLoaderIF<ClaimObject> claimLoaderFull;
    DataLoaderIF<ClaimObject> claimLoaderShort;
    ClaimLayoutObject claimLayoutObject;
    ClaimLayoutObject claimLayoutInputObject;
    private static final Logger LOG = Logger.getLogger(ClaimManager.class.getName());

    public ClaimManager(String basePath) {
        this.loadClaimLayout(basePath);
    }

    private void loadClaimLayout(String basePath) {
        this.claimLayoutObject = this.buildClaimLayout(basePath + "/" + TableNames_EN.Claim_Layout.getFileName());
        this.claimLoaderFull = new DataLoader<ClaimObject>(ClaimObject.class, this.claimLayoutObject);
        this.claimLayoutInputObject = this.buildInputOnlyLayout(this.claimLayoutObject, "input");
        this.claimLoaderShort = new DataLoader<ClaimObject>(ClaimObject.class, this.claimLayoutInputObject);
        LOG.log(Level.INFO, "Grouper Claim Manager instantiated: RT path: {0}", new Object[]{basePath});
    }

    private ClaimLayoutObject buildClaimLayout(String claimLayoutFile) {
        InputStream inputFile = this.getClass().getClassLoader().getResourceAsStream(claimLayoutFile);
        DataLoader<ClaimFieldObject> dl = new DataLoader<ClaimFieldObject>(ClaimFieldObject.class);
        List<ClaimFieldObject> claimFieldList = dl.loadFile(inputFile, false);
        ClaimLayoutObject clo = new ClaimLayoutObject();
        claimFieldList.forEach(claimFieldObject -> clo.getClaimField().add((ClaimField)claimFieldObject));
        return clo;
    }

    private ClaimLayoutObject buildInputOnlyLayout(ClaimLayoutObject clo, String inputField) {
        ClaimLayoutObject retClo = new ClaimLayoutObject();
        for (ClaimField claimField : clo.getClaimField()) {
            if (!claimField.getType().trim().equalsIgnoreCase(inputField)) continue;
            retClo.getClaimField().add(claimField);
        }
        return retClo;
    }

    @Override
    public List<Integer> getClaimLayout() {
        return this.claimLayoutObject.getLayout();
    }

    @Override
    public List<Integer> getClaimLayoutInputOnly() {
        return this.claimLayoutInputObject.getLayout();
    }

    @Override
    public ClaimObject loadClaim(String claimInput) {
        return this.claimLoaderShort.load(claimInput);
    }
}

