/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.hh.pdgm.grouper;

import com.mmm.cms.hh.pdgm.data.exchange.ClaimContainerIF;
import com.mmm.cms.hh.pdgm.data.exchange.ReturnCodeContainer;
import com.mmm.cms.hh.pdgm.data.exchange.ValidityFlagContainer;
import com.mmm.cms.hh.pdgm.data.files.TableNames_EN;
import com.mmm.cms.hh.pdgm.data.loader.DataLoader;
import com.mmm.cms.hh.pdgm.grouper.GrouperFactoryIF;
import com.mmm.cms.hh.pdgm.grouper.GrouperIF;
import com.mmm.cms.hh.pdgm.grouper.utility.Utility;
import com.mmm.cms.hh.pdgm.logic.specification.IsValidFromDate;
import com.mmm.cms.hh.pdgm.reference.objects.ClaimObject;
import com.mmm.cms.hh.pdgm.reference.objects.DiagnosisObject;
import com.mmm.cms.hh.pdgm.reference.objects.GrouperVersionObject;
import com.mmm.cms.hh.pdgm.reference.objects.ReturnCodeObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class GrouperFactory
implements GrouperFactoryIF {
    private static final Logger LOG = Logger.getLogger(GrouperFactory.class.getName());
    private static final String GROUP_VER_FILE = "Versions/" + TableNames_EN.Grouper_Versions.getFileName();
    Map<String, GrouperIF> grouperList = this.buildGrouperPool(GROUP_VER_FILE);
    protected static final GrouperFactory HHPDGM_GF = new GrouperFactory();

    public static GrouperFactory getInstance() {
        return HHPDGM_GF;
    }

    private GrouperFactory() {
        if (this.grouperList == null) {
            LOG.log(Level.SEVERE, "Grouper factory instanting error");
        } else {
            LOG.log(Level.INFO, "Grouper factory instantiated with {0} version(s)", this.grouperList.size());
        }
    }

    @Override
    public ClaimContainerIF getEmptyClaim(String claimDate) {
        GrouperIF grouper = this.getGrouper(claimDate);
        if (grouper != null) {
            return grouper.getEmptyClaim();
        }
        return null;
    }

    @Override
    public String getDiagnosisDescription(String claimDate, String diagValue) {
        GrouperIF grouper = this.getGrouper(claimDate);
        if (grouper != null) {
            DiagnosisObject dxObj = (DiagnosisObject)grouper.getAvailableTableContent(TableNames_EN.Diagnoses).getDataMap().get(diagValue);
            if (dxObj != null) {
                String desc = dxObj.getDescription();
                if (desc != null) {
                    return desc;
                }
                return "Diagnosis description not found. Check grouper setup";
            }
            return "Diagnosis not found";
        }
        return "Grouper not found";
    }

    @Override
    public void group(ClaimContainerIF claimIn) {
        if (claimIn == null) {
            return;
        }
        if (claimIn.getFromDate() != null && this.isClaimDateValid(claimIn.getFromDate())) {
            GrouperIF grouper = this.getGrouper(claimIn.getFromDate());
            if (grouper != null) {
                grouper.group(claimIn);
            }
        } else {
            this.setResultForIncorrectDate(claimIn);
        }
    }

    @Override
    public void group(File input, File output) {
        this.group(input, output, false);
    }

    @Override
    public void group(File input, File output, boolean fullRecord) {
        try {
            Scanner sc = new Scanner(input, "UTF8");
            FileWriter fileWriter = new FileWriter(output);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            while (sc.hasNextLine()) {
                printWriter.println(this.group(sc.nextLine(), fullRecord));
            }
            sc.close();
            printWriter.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(GrouperFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(GrouperFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public String group(String claimInput) {
        return this.group(claimInput, false);
    }

    @Override
    public String group(String claimInput, boolean fullRecord) {
        String retRes;
        if (claimInput == null || claimInput.isEmpty()) {
            return this.getResultForIncorrectDate();
        }
        boolean INDEX_CLAIM_ID = false;
        boolean INDEX_CLAIM_FROM_DATE = true;
        List<Integer> claimLayout = this.getDefaultGrouper().getClaimLayout();
        int claimDatePosition = claimLayout.get(0);
        int claimDateLength = claimLayout.get(1);
        if (claimInput.length() < claimDatePosition + claimDateLength) {
            return this.getResultForIncorrectDate();
        }
        String fromDate = claimInput.substring(claimDatePosition, claimDatePosition + claimDateLength);
        GrouperIF grouper = this.getGrouper(fromDate);
        int inputLength = -1;
        int outputLength = -1;
        if (grouper == null) {
            retRes = this.getResultForIncorrectDate();
            grouper = this.getDefaultGrouper();
            inputLength = Utility.sum(grouper.getClaimLayoutInputOnly());
            outputLength = Utility.sum(grouper.getClaimLayout()) - inputLength;
        } else {
            inputLength = Utility.sum(grouper.getClaimLayoutInputOnly());
            outputLength = Utility.sum(grouper.getClaimLayout()) - inputLength;
            retRes = grouper.group(Utility.adjustLine(claimInput, inputLength));
        }
        if (fullRecord) {
            return Utility.adjustLine(claimInput, inputLength) + Utility.adjustLine(retRes, outputLength - 1) + "%";
        }
        return retRes;
    }

    protected void setResultForIncorrectDate(ClaimContainerIF claim) {
        claim.setVersionUsed(this.getDefaultGrouper().getVersion());
        claim.setHippsCode("00000");
        claim.setValidityFlag(new ValidityFlagContainer("00", "Not used"));
        ReturnCodeObject rco = (ReturnCodeObject)this.getDefaultGrouper().getAvailableTableContent(TableNames_EN.Return_Codes).getDataMap().get("01");
        claim.setReturnCode(new ReturnCodeContainer(rco.getCode(), rco.getDescription()));
    }

    protected String getEmptyResult() {
        return "AA.A.AABBBBBCCDD";
    }

    protected String getResultForIncorrectDate() {
        ClaimObject claim = new ClaimObject();
        claim.setByPosition(53, this.getDefaultGrouper().getVersion());
        claim.setByPosition(54, "00000");
        claim.setByPosition(55, "00");
        claim.setByPosition(56, "01");
        return claim.tempGetOutput();
    }

    @Override
    public GrouperIF getDefaultGrouper() {
        for (GrouperIF grouper : this.grouperList.values()) {
            if (!grouper.isDefault()) continue;
            return grouper;
        }
        return null;
    }

    private GrouperIF getGrouper(String claimDate) {
        IsValidFromDate claimDateSpecs = new IsValidFromDate(claimDate);
        if (claimDateSpecs == null) {
            return null;
        }
        for (GrouperIF grouper : this.grouperList.values()) {
            if (!claimDateSpecs.isSatisfiedBy(grouper)) continue;
            return grouper;
        }
        return null;
    }

    @Override
    public boolean isClaimDateValid(String claimDate) {
        boolean ret = false;
        if (this.getGrouper(claimDate) != null) {
            ret = true;
        }
        return ret;
    }

    private Map<String, GrouperIF> buildGrouperPool(String grouperVerFile) {
        TreeMap<String, GrouperIF> retGrouperList = null;
        InputStream inputFile = this.getClass().getClassLoader().getResourceAsStream(grouperVerFile);
        DataLoader<GrouperVersionObject> dl = new DataLoader<GrouperVersionObject>(GrouperVersionObject.class, true);
        List<GrouperVersionObject> grouperRtList = dl.loadFile(inputFile);
        try {
            for (int i = 0; i < grouperRtList.size(); ++i) {
                if (Integer.parseInt(grouperRtList.get(i).getActiveFlag()) <= 0) continue;
                Class<?> clazz = Class.forName(grouperRtList.get(i).getJavaClass());
                Constructor<?> constructor = clazz.getConstructor(Integer.class, GrouperVersionObject.class);
                Object instance = constructor.newInstance(i, grouperRtList.get(i));
                GrouperIF grouper = (GrouperIF)instance;
                if (retGrouperList == null) {
                    retGrouperList = new TreeMap<String, GrouperIF>();
                }
                retGrouperList.put(grouper.getName(), grouper);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Logger.getLogger(GrouperFactory.class.getName()).log(Level.SEVERE, null, e);
        }
        return retGrouperList;
    }

    @Override
    public List<GrouperIF> getAvailableVersions() {
        return this.grouperList.values().stream().collect(Collectors.toList());
    }

    @Override
    public synchronized String getBuildInfo() {
        Package pack;
        String title = null;
        String version = null;
        Properties p = new Properties();
        InputStream res = null;
        try {
            res = this.getClass().getResourceAsStream("/META-INF/maven/com.mmm.his.cer.component/HomeHealthPDGM/pom.properties");
            if (res != null) {
                p.load(res);
                version = p.getProperty("version");
                title = p.getProperty("artifactId");
                res.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (version == null && (pack = this.getClass().getPackage()) != null) {
            version = pack.getImplementationVersion();
            if (version == null) {
                version = pack.getSpecificationVersion();
            }
            if ((title = pack.getImplementationTitle()) == null) {
                title = pack.getSpecificationTitle();
            }
        }
        if (version == null) {
            version = "(unknown)";
        }
        if (title == null) {
            title = "HH PDGM";
        }
        return "Software: " + title + ", Version: " + version;
    }
}

