/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.claim;

import com.mmm.cms.hh.pdgm.common.abstr.VerifiableIF;
import com.mmm.cms.hh.pdgm.diagnosis.DiagnosisIF;
import com.mmm.cms.hh.pdgm.logic.validation.EditCollectionIF;

/**
 *
 * @author US340646
 */
public interface ClaimIF extends VerifiableIF {
    
    /**
     *
     * @param returnCode
     * @return
     */
    boolean hasReturnCode(int returnCode);
    
    /**
     *
     * @param validityFlag
     * @return
     */
    boolean hasValidityFlag(String validityFlag);
    
    /**
     * @return the grouperVersion
     */
    String getGrouperVersion();
    
    /**
     * @param grouperVersion the grouperVersion to set
     */
    void setGrouperVersion(String grouperVersion);
    
    /**
     *
     * @return
     */
    ReturnCode getSingleReturnCode();
    
    /**
     *
     * @return
     */
    ValidityFlag getSingleValidityFlag();
    
    /**
     * @return the ClaimId
     */
    String getClaimId();

    /**
     * @param ClaimId the ClaimId to set
     */
    void setClaimId(String ClaimId);
    
    /**
     * @return the dateFrom
     */
    DateFromIF getDateFrom();

    /**
     * @return the hippsCode
     */
    HippsCodeIF getHippsCode();

    /**
     * @return the oasisFields
     */
    ClaimElementCollectionIF<OasisResponseIF> getOasisFields();

    /**
     * @return the periodTiming
     */
    PeriodTimingIF getPeriodTiming();

    /**
     * @return the primaryDiagnosis
     */
    DiagnosisIF getPrimaryDiagnosis();

    /**
     * @return the referralSource
     */
    ReferralSourceIF getReferralSource();

    /**
     * @return the returnCodes
     */
    ClaimElementCollectionIF<ReturnCode> getReturnCodes();

    /**
     * @return the secondaryDiagnoses
     */
    ClaimElementCollectionIF<DiagnosisIF> getSecondaryDiagnoses();

    /**
     * @return the validityFlags
     */
    ClaimElementCollectionIF<ValidityFlag> getValidityFlags();

    /**
     * @param dateFrom the dateFrom to set
     */
    void setDateFrom(DateFromIF dateFrom);

    /**
     * @param hippsCode the hippsCode to set
     */
    void setHippsCode(HippsCodeIF hippsCode);

    /**
     * @param oasisFields the oasisFields to set
     */
    void setOasisFields(ClaimElementCollectionIF<OasisResponseIF> oasisFields);

    /**
     * @param periodTiming the periodTiming to set
     */
    void setPeriodTiming(PeriodTimingIF periodTiming);

    /**
     * @param primaryDiagnosis the primaryDiagnosis to set
     */
    void setPrimaryDiagnosis(DiagnosisIF primaryDiagnosis);

    /**
     * @param referralSource the referralSource to set
     */
    void setReferralSource(ReferralSourceIF referralSource);

    /**
     * @param returnCodes the returnCodes to set
     */
    void setReturnCodes(ClaimElementCollectionIF<ReturnCode> returnCodes);

    /**
     * @param secondaryDiagnoses the secondaryDiagnoses to set
     */
    void setSecondaryDiagnoses(ClaimElementCollectionIF<DiagnosisIF> secondaryDiagnoses);

    /**
     * @param validityFlags the validityFlags to set
     */
    void setValidityFlags(ClaimElementCollectionIF<ValidityFlag> validityFlags);
    
    /**
     *
     * @return
     */
    EditCollectionIF getClaimEdits();
}
