/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.diagnosis;

import com.mmm.cms.hh.pdgm.common.abstr.DescribableIF;
import com.mmm.cms.hh.pdgm.common.abstr.IdentifiableIF;
import com.mmm.cms.hh.pdgm.common.abstr.NameableIF;

/**
 *
 * @author US340646
 */
public interface ComorbidityGroupIF extends DescribableIF, IdentifiableIF, NameableIF {

    /**
     * @return the description
     */
    @Override
    String getDescription();

    /**
     * @return the id
     */
    @Override
    int getId();

    /**
     * @return the name
     */
    @Override
    String getName();

    /**
     *
     * @return
     */
    boolean isComorbidityPresent();

    /**
     * @return the lowComorbidity
     */
    boolean isLowComorbidity();

    /**
     * @param description the description to set
     */
    @Override
    void setDescription(String description);

    /**
     * @param id the id to set
     */
    @Override
    void setId(int id);

    /**
     * @param lowComorbidity the lowComorbidity to set
     */
    void setLowComorbidity(boolean lowComorbidity);

    /**
     * @param name the name to set
     */
    @Override
    void setName(String name);
    
}
