/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.diagnosis;

/**
 *
 * @author US340646
 */
public class ComorbidityInteraction implements ComorbidityInteractionIF {

    @Override
    public String toString() {
        return "ComorbidityInteraction{" + "id=" + id + ", comorbidityGroup1=" + comorbidityGroup1 + ", comorbidityGroup2=" + comorbidityGroup2 + '}';
    }

    /**
     *
     * @param id
     * @param comorbidityGroup1
     * @param comorbidityGroup2
     */
    public ComorbidityInteraction(int id, ComorbidityGroup comorbidityGroup1, ComorbidityGroup comorbidityGroup2) {
        this.id = id;
        this.comorbidityGroup1 = comorbidityGroup1;
        this.comorbidityGroup2 = comorbidityGroup2;
    }

    /**
     * Constructor
     */
    public ComorbidityInteraction() {
    }

    /**
     * @return the id
     */
    @Override
    public int getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    @Override
    public void setId(int id) {
        this.id = id;
    }

    /**
     * @return the comorbidityGroup1
     */
    @Override
    public ComorbidityGroup getComorbidityGroup1() {
        return comorbidityGroup1;
    }

    /**
     * @param comorbidityGroup1 the comorbidityGroup1 to set
     */
    @Override
    public void setComorbidityGroup1(ComorbidityGroup comorbidityGroup1) {
        this.comorbidityGroup1 = comorbidityGroup1;
    }

    /**
     * @return the comorbidityGroup2
     */
    @Override
    public ComorbidityGroup getComorbidityGroup2() {
        return comorbidityGroup2;
    }

    /**
     * @param comorbidityGroup2 the comorbidityGroup2 to set
     */
    @Override
    public void setComorbidityGroup2(ComorbidityGroup comorbidityGroup2) {
        this.comorbidityGroup2 = comorbidityGroup2;
    }
    private int id;
    private ComorbidityGroup comorbidityGroup1;
    private ComorbidityGroup comorbidityGroup2;
}
