/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.logic.processor;

import com.mmm.cms.hh.pdgm.claim.ClaimIF;
import com.mmm.cms.hh.pdgm.grouper.DataManagerIF;
import java.util.Arrays;
import java.util.List;

/**
 *
 * @author us340646
 */
public class HippsProcessor implements HippsPositionIF {

    private List<HippsPositionIF> positions;

    /**
     *
     * @param positions
     */
    public HippsProcessor(List<HippsPositionIF> positions) {
        this.positions = positions;
    }

    /**
     *
     * @param claim
     * @param dataManager
     */
    public HippsProcessor(ClaimIF claim, DataManagerIF dataManager) {
        this.positions = Arrays.asList(
                new HippsPosition1(claim, dataManager),
                new HippsPosition2(claim, dataManager),
                new HippsPosition3(claim, dataManager),
                new HippsPosition4(claim, dataManager),
                new HippsPosition5(claim, dataManager)
        );
    }

    /**
     *
     * @param visitor
     */
    @Override
    public void process(HippsPositionSelectorIF visitor) {
        getPositions().forEach((element) -> {
            element.process(visitor);
        });
        visitor.select(this);
    }

    /**
     *
     * @return
     */
    @Override
    public boolean validate() {
        return false;
    }

    /**
     *
     * @return
     */
    @Override
    public boolean calculate() {
        return false;
    }

    /**
     * @return the positions
     */
    public List<HippsPositionIF> getPositions() {
        return positions;
    }

    /**
     * @param positions the positions to set
     */
    public void setPositions(List<HippsPositionIF> positions) {
        this.positions = positions;
    }
    
}
