/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.logic.specification.abstr;

import java.util.HashSet;
import java.util.Set;

/**
 *
 * @author US340646
 * @param <T>
 */
public class OrSpecification<T> extends AbstractSpecification<T> {

    private final Set<Specification<T>> set;

    /**
     *
     * @param a
     * @param b
     */
    public OrSpecification(Specification<T> a, Specification<T> b) {
        this.set = new HashSet<>();
        set.add(a);
        set.add(b);
    }

    /**
     *
     * @param t
     * @return
     */
    @Override
    public boolean isSatisfiedBy(T t) {
        for (Specification<T> s : set) {
            if (s.isSatisfiedBy(t)) {
                return true;
            }
        }
        return false;
    }

    /**
     *
     * @param s
     * @return
     */
    @Override
    public AbstractSpecification<T> or(Specification<T> s) {
        set.add(s);
        return this;
    }

}
