/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.logic.validation;

import com.mmm.cms.hh.pdgm.data.meta.enumer.EditId_EN;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;

/**
 *
 * @author US340646
 */
public class EditCollection extends ArrayList<EditIF> implements EditCollectionIF {

    private static final long serialVersionUID = 1L;
    
    /**
     *
     * @return
     */
    @Override
    public List<EditIF> getCriticalEdits() {
        return this.stream().filter((edit) -> (edit.getServerityLevel() == Level.SEVERE)).collect(Collectors.toList());
    }

    /**
     *
     * @return
     */
    @Override
    public boolean hasCriticalEdits() {
        return this.stream().anyMatch((edit) -> (edit.getServerityLevel() == Level.SEVERE));
    }

    /**
     *
     * @param editId
     * @return
     */
    @Override
    public List<EditIF> getEditId(EditId_EN editId) {
        return this.stream().filter((edit) -> (edit.getId() == editId)).collect(Collectors.toList());
    }
    
    /**
     *
     * @param editId
     * @return
     */
    @Override
    public boolean hasEditId(EditId_EN editId) {
        return this.stream().anyMatch((edit) -> (edit.getId() == editId));
    }
    
    /**
     *
     * @param edit
     */
    @Override
    public void addEdit(EditIF edit) {
        add(edit);
    }

    /**
     *
     * @return
     */
    @Override
    public List<EditIF> getEdits() {
        return this;
    }

    /**
     *
     * @param editList
     */
    @Override
    public void addEdits(List<EditIF> editList) {
        addAll(editList);
    }
    
    
}
