/* 
 * 
 * Home Health Grouper PDGM (Patient-Driven Grouping Model)
 * 
 * Developed for the Center for Medicare and Medicaid Services (CMS)
 * by 3M Health Information Systems.
 * 
 * All code is provided as is.
 * 
 */
package com.mmm.cms.hh.pdgm.reference.objects;

import com.mmm.cms.hh.pdgm.data.interf.PositionAccessorIF;
import com.mmm.cms.hh2.xml.layout.rot.HippsValue;

/**
 *
 * @author US340646
 */
public class HippsValueObject extends HippsValue implements PositionAccessorIF {

    @Override
    public String toString() {
        return "Position:'" + getPosition() +
                "', Position Description:'" + getPositionDescription() +
                "', Value:'" + getValue() +
                "', Value Description:'" + getValueDescription() +
                "'";
    }
    
    /**
     *
     * @param position
     * @return
     */
    @Override
    public String getByPosition(int position) {
        switch(position) {
            case 0:
                return getPosition();
            case 1:
                return getPositionDescription();
            case 2:
                return getValue();
            case 3:
                return getValueDescription();
            default:
                return null; // Exception???
        }
    }

    @Override
    public boolean setByPosition(int position, String value) {
        switch(position) {
            case 0:
                setPosition(value);
                return true;
            case 1:
                setPositionDescription(value);
                return true;
            case 2:
                setValue(value);
                return true;
            case 3:
                setValueDescription(value);
                return true;
            default:
                return false; // Exception???
        }
    }

    /**
     *
     * @return
     */
    @Override
    public int getNumberOfFields() {
        return 4;
    }


    private boolean loadDescription;
    
    /**
     * @return the loadDescription
     */
    @Override
    public boolean isLoadDescription() {
        return loadDescription;
    }

    /**
     * @param loadDescription the loadDescription to set
     */
    @Override
    public void setLoadDescription(boolean loadDescription) {
        this.loadDescription = loadDescription;
    }
    
}
