/*
 * Decompiled with CFR 0.152.
 */
package com.utilities.component;

import gov.cms.hh.application.HHGrouper;
import gov.cms.hh.data.files.TableNames_EN;
import gov.cms.hh.data.interf.PositionAccessorIF;
import gov.cms.hh.grouper.DataContainerIF;
import gov.cms.hh.grouper.GrouperIF;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class ComponentManager {
    private boolean isComponentValid;
    private String componentStartDate;
    private String description;
    private String table;
    private static ObservableList filteredRT;
    private GrouperIF grouper;

    public static String getDxDescription(String code, String date) {
        if (date == null || date.length() < 8) {
            return "From date required.";
        }
        return HHGrouper.getDiagnosisDescription(date, code);
    }

    public static boolean isDateValid(String date) {
        if (date == null || date.length() < 8) {
            return false;
        }
        return HHGrouper.isClaimDateValid(date);
    }

    public static ObservableList<String> getGrouperVersions() {
        ObservableList versions = FXCollections.observableArrayList((Object[])new String[]{"None"});
        for (GrouperIF f : HHGrouper.getAvailableVersions()) {
            versions.add((Object)f.getVersion());
        }
        return versions;
    }

    public ObservableList<String> getTablesForVersion() {
        ObservableList tables = FXCollections.observableArrayList((Object[])new String[]{"None"});
        for (TableNames_EN x : TableNames_EN.values()) {
            if (!x.isViewable()) continue;
            tables.add((Object)x.getDescription());
        }
        return tables;
    }

    public ComponentManager(String version) {
        for (GrouperIF grouperIF : HHGrouper.getAvailableVersions()) {
            if (!grouperIF.getVersion().equalsIgnoreCase(version)) continue;
            this.grouper = grouperIF;
            this.componentStartDate = new SimpleDateFormat("MM/dd/yyyy").format(this.grouper.getStartDate()) + " - " + new SimpleDateFormat("MM/dd/yyyy").format(this.grouper.getEndDate());
            this.description = this.grouper.getDescription();
            this.isComponentValid = true;
            break;
        }
    }

    public ComponentManager(String version, String table, String[] filter) {
        this(version);
        this.table = table;
        this.setRtData(filter);
    }

    public ObservableList<List<String>> getUnfilteredTableData() {
        ObservableList tableData = FXCollections.observableArrayList();
        DataContainerIF<PositionAccessorIF> rt = this.grouper.getAvailableTableContent(TableNames_EN.valueOf(this.table.replace(" ", "_")));
        PositionAccessorIF headers = rt.getColumnNames();
        ArrayList<String> headerList = new ArrayList<String>();
        for (int i = 0; i < headers.getNumberOfFields(); ++i) {
            headerList.add(headers.getByPosition(i));
        }
        tableData.add(headerList);
        for (PositionAccessorIF row : rt.getData()) {
            ArrayList<String> s = new ArrayList<String>();
            PositionAccessorIF row1 = row;
            for (int i = 0; i < row1.getNumberOfFields(); ++i) {
                s.add(row1.getByPosition(i));
            }
            tableData.add(s);
        }
        return tableData;
    }

    private void setRtData(String[] filter) {
        ObservableList<List<String>> tableData = this.getUnfilteredTableData();
        filteredRT = FXCollections.observableArrayList(tableData);
        if (filter != null) {
            filteredRT = FXCollections.observableArrayList();
            boolean isHeader = true;
            for (List columnData : tableData) {
                boolean isMatch = true;
                if (isHeader) {
                    filteredRT.add((Object)columnData);
                    isHeader = false;
                    continue;
                }
                for (int i = 0; i < filter.length; ++i) {
                    if (filter[i].equalsIgnoreCase("")) continue;
                    isMatch = isMatch && ((String)columnData.get(i)).toLowerCase().startsWith(filter[i].toLowerCase());
                }
                if (!isMatch) continue;
                filteredRT.add((Object)columnData);
            }
        }
    }

    public ObservableList getRotForPage(int currentPage, int maxPage, int maxPerPage) {
        if (!filteredRT.isEmpty()) {
            ObservableList tmp = FXCollections.observableArrayList((Object[])new Object[]{filteredRT.get(0)});
            int start = currentPage * maxPerPage;
            int end = filteredRT.size() % maxPerPage != 0 && currentPage + 1 == maxPage ? currentPage * maxPerPage + filteredRT.size() % maxPerPage - 1 : currentPage * maxPerPage + maxPerPage;
            tmp.addAll((Collection)filteredRT.subList(start, end + 1));
            return tmp;
        }
        return FXCollections.observableArrayList();
    }

    public <T> ObservableList<T> getFilteredRT() {
        return filteredRT;
    }

    public String getComponentStartDate() {
        return this.componentStartDate;
    }

    public boolean isComponentValid() {
        return this.isComponentValid;
    }

    public String getDescription() {
        return this.description;
    }
}

