/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.claim;

import gov.cms.hh.data.meta.enumer.Oasis_EN;

/**
 *
 * @author CMS
 */
public class OasisResponse extends ClaimElementBase implements OasisResponseIF {

    private static final long serialVersionUID = 1L;

    @Override
    public String toString() {
        return "OasisResponse{" + "type="
                + (type != null ? type.name() : "Unknown") + ", value="
                + value + ", score="
                + score + '}';
    }

    /**
     * @return the type
     */
    @Override
    public Oasis_EN getType() {
        return type;
    }

    /**
     * @param type the type to set
     */
    @Override
    public void setType(Oasis_EN type) {
        this.type = type;
    }

    /**
     * @return the value
     */
    @Override
    public String getValue() {
        return value;
    }

    /**
     * @param value the value to set
     */
    @Override
    public void setValue(String value) {
        this.value = value;
    }
    private Oasis_EN type;
    private String value;
    private int score;

    /**
     * @return the score
     */
    @Override
    public int getScore() {
        return score;
    }

    /**
     * @param score the score to set
     */
    @Override
    public void setScore(int score) {
        this.score = score;
    }

}
