/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.logic.specification;

import gov.cms.hh.grouper.GrouperIF;
import gov.cms.hh.logic.specification.abstr.AbstractSpecification;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public class IsSpanClaim
extends AbstractSpecification<GrouperIF> {
    private Date date = null;

    public IsSpanClaim(String date) {
        this.date = this.processDate(date);
    }

    private Date processDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        sdf.setLenient(false);
        Date ret = null;
        try {
            ret = sdf.parse(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public boolean isSatisfiedBy(GrouperIF gv) {
        return this.isDaysInRange(gv.getEndDate(), 29);
    }

    private boolean isDaysInRange(Date end, int range) {
        LocalDate endDate;
        if (this.date == null) {
            return false;
        }
        LocalDate startDate = this.date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        long days = ChronoUnit.DAYS.between(startDate, endDate = end.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        return days < (long)range;
    }
}

