/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.logic.specification;

import gov.cms.hh.grouper.GrouperIF;
import gov.cms.hh.logic.specification.abstr.AbstractSpecification;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class IsValidFromDate
extends AbstractSpecification<GrouperIF> {
    private Date date = null;

    public IsValidFromDate(String date) {
        this.date = this.processDate(date);
    }

    private Date processDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        sdf.setLenient(false);
        Date ret = null;
        try {
            ret = sdf.parse(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public boolean isSatisfiedBy(GrouperIF gv) {
        return this.isDateInBetweenIncludingEndPoints(gv.getStartDate(), gv.getEndDate());
    }

    private boolean isDateInBetweenIncludingEndPoints(Date min, Date max) {
        if (this.date == null) {
            return false;
        }
        return !this.date.before(min) && !this.date.after(max);
    }
}

