/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.v04023;

import gov.cms.hh.claim.ClaimIF;
import gov.cms.hh.data.exchange.ClaimContainerIF;
import gov.cms.hh.data.files.TableNames_EN;
import gov.cms.hh.data.meta.enumer.EditId_EN;
import gov.cms.hh.data.meta.enumer.EditType_EN;
import gov.cms.hh.diagnosis.DiagnosisIF;
import gov.cms.hh.grouper.DataManagerIF;
import gov.cms.hh.grouper.GrouperIF;
import gov.cms.hh.logic.specification.IsCodeValid;
import gov.cms.hh.logic.specification.IsSpanClaim;
import gov.cms.hh.logic.validation.Edit;
import gov.cms.hh.reference.objects.DiagnosisObject;
import gov.cms.hh.reference.objects.GrouperVersionObject;
import gov.cms.hh.v03322.Grouper_v03322;
import gov.cms.hh.v04023.HippsProcessor_v04023;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Grouper_v04023
extends Grouper_v03322 {
    private static final Logger LOG = Logger.getLogger(Grouper_v04023.class.getName());

    public Grouper_v04023(Integer id, GrouperVersionObject grouperVersionObject, Boolean loadDescription) throws ParseException {
        super(id, grouperVersionObject, loadDescription);
        this.setLinked();
    }

    @Override
    protected void processClaim(ClaimIF claim, DataManagerIF dataManager) {
        HippsProcessor_v04023 hp = new HippsProcessor_v04023();
        hp.process(claim, dataManager);
    }

    @Override
    protected ClaimIF castClaim(ClaimContainerIF claimInput) {
        ClaimIF claim = super.castClaim(claimInput);
        DiagnosisIF pdx = claim.getPrimaryDiagnosis();
        boolean isPdxValid = new IsCodeValid(pdx.getValue(), TableNames_EN.Diagnoses).isSatisfiedBy(this);
        if (isPdxValid) {
            return claim;
        }
        if (!this.isLinked()) {
            return claim;
        }
        boolean isSpanClaim = new IsSpanClaim(claim.getDateFrom().getValue()).isSatisfiedBy(this);
        if (!isSpanClaim) {
            return claim;
        }
        boolean isPdxNextValid = new IsCodeValid(pdx.getValue(), TableNames_EN.Diagnoses).isSatisfiedBy(this.getNextVersion());
        if (isPdxNextValid) {
            String predecessorDx = this.getPredecessorDx(pdx.getValue());
            pdx.setValue(predecessorDx);
            pdx.addEdit(new Edit(EditId_EN.VALUE_SUBSTITUTED_FOR_SPAN, pdx + ", " + EditId_EN.VALUE_SUBSTITUTED_FOR_SPAN.getDescription(), EditType_EN.SPECIFICATION, Level.INFO));
        }
        return claim;
    }

    protected String getPredecessorDx(String dx) {
        GrouperIF nextGrouper = this.getNextVersion();
        DiagnosisObject dxObj = (DiagnosisObject)nextGrouper.getAvailableTableContent(TableNames_EN.Diagnoses).getDataMap().get(dx);
        String predecessor = null;
        try {
            predecessor = dxObj.getPredecessorDx();
        }
        catch (Exception e) {
            LOG.info("*** SEVERE: Grouper Internal Error: Predecessor DX not found ***");
        }
        return predecessor;
    }
}

