/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.grouper;

import gov.cms.hh.data.loader.DataLoader;
import gov.cms.hh.data.loader.PositionAccessorIF;
import gov.cms.hh.grouper.DataContainerIF;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public final class DataContainer<T>
implements DataContainerIF<T> {
    private Map<String, T> dataMap;
    private T columnNames;

    public DataContainer(String inpFile, Class clazz) {
        this(inpFile, clazz, false);
    }

    public DataContainer(String inpFile, Class clazz, boolean loadDescriptions) {
        this.addAllWithId(this.readData(inpFile, clazz, loadDescriptions));
    }

    public DataContainer(String inpFile, int colNum, Class clazz) {
        this(inpFile, colNum, clazz, false);
    }

    public DataContainer(String inpFile, int colNum, Class clazz, boolean loadDescriptions) {
        this.addAll(colNum, this.readData(inpFile, clazz, loadDescriptions));
    }

    private List<T> readData(String inpFile, Class clazz, boolean loadDescriptions) {
        InputStream inStr = this.getClass().getClassLoader().getResourceAsStream(inpFile);
        DataLoader loader = new DataLoader(clazz, loadDescriptions);
        return loader.loadFile(inStr, true);
    }

    @Override
    public Map<String, T> getDataMap() {
        return this.dataMap;
    }

    @Override
    public void setDataMap(Map<String, T> dataMap) {
        this.dataMap = dataMap;
    }

    @Override
    public T getColumnNames() {
        return this.columnNames;
    }

    @Override
    public void setColumnNames(T columnNames) {
        this.columnNames = columnNames;
    }

    @Override
    public void add(String key, T data) {
        if (this.dataMap == null) {
            this.dataMap = new TreeMap<String, T>();
        }
        this.dataMap.put(key, data);
    }

    @Override
    public void addAll(int keyPosition, List<T> data) {
        if (data == null) {
            return;
        }
        if (this.dataMap == null) {
            this.dataMap = new TreeMap<String, T>();
            if (data.size() > 0) {
                this.setColumnNames(data.get(0));
                for (int i = 1; i < data.size(); ++i) {
                    this.dataMap.put(((PositionAccessorIF)data.get(i)).getByPosition(keyPosition), data.get(i));
                }
            }
        } else {
            data.forEach(t -> this.dataMap.put(((PositionAccessorIF)t).getByPosition(keyPosition), t));
        }
    }

    @Override
    public List<T> getData() {
        return this.dataMap.values().stream().collect(Collectors.toList());
    }

    @Override
    public void replaceAll(int keyPosition, List<T> data) {
        this.dataMap = null;
        this.addAll(keyPosition, data);
    }

    @Override
    public void addAllWithId(List<T> data) {
        if (data == null) {
            return;
        }
        if (this.dataMap == null) {
            this.dataMap = new TreeMap<String, T>();
            if (data.size() > 0) {
                this.setColumnNames(data.get(0));
                for (int i = 1; i < data.size(); ++i) {
                    this.dataMap.put("" + i, data.get(i));
                }
            }
        } else {
            data.forEach(t -> this.dataMap.put("" + this.dataMap.values().size(), t));
        }
    }

    @Override
    public void replaceAllWithId(List<T> data) {
        this.dataMap = null;
        this.addAllWithId(data);
    }
}

