/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.grouper;

import gov.cms.hh.data.exchange.ClaimContainerIF;
import gov.cms.hh.data.exchange.ReturnCodeContainer;
import gov.cms.hh.data.exchange.ValidityFlagContainer;
import gov.cms.hh.data.files.TableNames_EN;
import gov.cms.hh.data.loader.DataLoader;
import gov.cms.hh.grouper.GrouperFactoryIF;
import gov.cms.hh.grouper.GrouperIF;
import gov.cms.hh.grouper.utility.Utility;
import gov.cms.hh.logic.specification.IsValidFromDate;
import gov.cms.hh.reference.objects.ClaimObject;
import gov.cms.hh.reference.objects.DiagnosisObject;
import gov.cms.hh.reference.objects.GrouperVersionObject;
import gov.cms.hh.reference.objects.ReturnCodeObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class GrouperFactory
implements GrouperFactoryIF {
    private static final Logger LOG = Logger.getLogger(GrouperFactory.class.getName());
    private final String GROUP_VER_FILE = "Versions/" + TableNames_EN.Grouper_Versions.getFileName();
    Map<String, GrouperIF> grouperList;

    public GrouperFactory(boolean loadDescription) {
        this.grouperList = this.buildGrouperPool(this.GROUP_VER_FILE, loadDescription);
        if (this.grouperList == null) {
            LOG.log(Level.SEVERE, "Grouper factory instanting error");
        } else {
            LOG.log(Level.INFO, "Grouper factory instantiated with {0} version(s)", this.grouperList.size());
        }
    }

    @Override
    public ClaimContainerIF getEmptyClaim(String claimDate) {
        GrouperIF grouper = this.getGrouper(claimDate);
        if (grouper != null) {
            return grouper.getEmptyClaim();
        }
        return null;
    }

    @Override
    public String getDiagnosisDescription(String claimDate, String diagValue) {
        GrouperIF grouper = this.getGrouper(claimDate);
        if (grouper != null) {
            DiagnosisObject dxObj = (DiagnosisObject)grouper.getAvailableTableContent(TableNames_EN.Diagnoses).getDataMap().get(diagValue);
            if (dxObj != null) {
                String desc = dxObj.getDescription();
                if (desc != null) {
                    return desc;
                }
                return "Diagnosis description not found. Check grouper setup";
            }
            return "Diagnosis code is not valid for claim dates";
        }
        return "Grouper not found";
    }

    @Override
    public void group(ClaimContainerIF claimIn) {
        if (claimIn == null) {
            return;
        }
        if (claimIn.getFromDate() != null && this.isClaimDateValid(claimIn.getFromDate())) {
            GrouperIF grouper = this.getGrouper(claimIn.getFromDate());
            if (grouper != null) {
                grouper.group(claimIn);
            }
        } else {
            this.setResultForIncorrectDate(claimIn);
        }
    }

    @Override
    public void group(File input, File output) {
        this.group(input, output, false);
    }

    @Override
    public void group(File input, File output, boolean fullRecord) {
        try {
            Scanner sc = new Scanner(input, "UTF8");
            FileWriter fileWriter = new FileWriter(output);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            while (sc.hasNextLine()) {
                printWriter.println(this.group(sc.nextLine(), fullRecord));
            }
            sc.close();
            printWriter.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(GrouperFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(GrouperFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public String group(String claimInput) {
        return this.group(claimInput, false);
    }

    @Override
    public String group(String claimInput, boolean fullRecord) {
        String retRes;
        if (claimInput == null || claimInput.isEmpty()) {
            return this.getResultForIncorrectDate();
        }
        boolean INDEX_CLAIM_ID = false;
        boolean INDEX_CLAIM_FROM_DATE = true;
        List<Integer> claimLayout = this.getDefaultGrouper().getClaimLayout();
        int claimDatePosition = claimLayout.get(0);
        int claimDateLength = claimLayout.get(1);
        if (claimInput.length() < claimDatePosition + claimDateLength) {
            return this.getResultForIncorrectDate();
        }
        String fromDate = claimInput.substring(claimDatePosition, claimDatePosition + claimDateLength);
        GrouperIF grouper = this.getGrouper(fromDate);
        int inputLength = -1;
        int outputLength = -1;
        if (grouper == null) {
            retRes = this.getResultForIncorrectDate();
            grouper = this.getDefaultGrouper();
            inputLength = Utility.sum(grouper.getClaimLayoutInputOnly());
            outputLength = Utility.sum(grouper.getClaimLayout()) - inputLength;
        } else {
            inputLength = Utility.sum(grouper.getClaimLayoutInputOnly());
            outputLength = Utility.sum(grouper.getClaimLayout()) - inputLength;
            retRes = grouper.group(Utility.adjustLine(claimInput, inputLength));
        }
        if (fullRecord) {
            return Utility.adjustLine(claimInput, inputLength) + Utility.adjustLine(retRes, outputLength - 1) + "%";
        }
        return retRes;
    }

    protected void setResultForIncorrectDate(ClaimContainerIF claim) {
        claim.setVersionUsed(this.getDefaultGrouper().getVersion());
        claim.setHippsCode("00000");
        claim.setValidityFlag(new ValidityFlagContainer("00", "Not used"));
        ReturnCodeObject rco = (ReturnCodeObject)this.getDefaultGrouper().getAvailableTableContent(TableNames_EN.Return_Codes).getDataMap().get("01");
        claim.setReturnCode(new ReturnCodeContainer(rco.getCode(), rco.getDescription()));
    }

    protected String getEmptyResult() {
        return "AA.A.AABBBBBCCDD";
    }

    protected String getResultForIncorrectDate() {
        ClaimObject claim = new ClaimObject();
        claim.setByPosition(53, this.getDefaultGrouper().getVersion());
        claim.setByPosition(54, "00000");
        claim.setByPosition(55, "00");
        claim.setByPosition(56, "01");
        return claim.tempGetOutput();
    }

    @Override
    public GrouperIF getDefaultGrouper() {
        for (GrouperIF grouper : this.grouperList.values()) {
            if (!grouper.isDefault()) continue;
            return grouper;
        }
        return null;
    }

    private GrouperIF getGrouper(String claimDate) {
        IsValidFromDate claimDateSpecs = new IsValidFromDate(claimDate);
        if (claimDateSpecs == null) {
            return null;
        }
        for (GrouperIF grouper : this.grouperList.values()) {
            if (!claimDateSpecs.isSatisfiedBy(grouper)) continue;
            return grouper;
        }
        return null;
    }

    @Override
    public boolean isClaimDateValid(String claimDate) {
        boolean ret = false;
        if (this.getGrouper(claimDate) != null) {
            ret = true;
        }
        return ret;
    }

    private Map<String, GrouperIF> buildGrouperPool(String grouperVerFile, boolean loadDescription) {
        TreeMap<String, GrouperIF> retGrouperList = null;
        InputStream inputFile = this.getClass().getClassLoader().getResourceAsStream(grouperVerFile);
        DataLoader<GrouperVersionObject> dl = new DataLoader<GrouperVersionObject>(GrouperVersionObject.class, true);
        List<GrouperVersionObject> grouperRtList = dl.loadFile(inputFile);
        try {
            for (int i = 0; i < grouperRtList.size(); ++i) {
                if (Integer.parseInt(grouperRtList.get(i).getActiveFlag()) <= 0) continue;
                Class<?> clazz = Class.forName(grouperRtList.get(i).getJavaClass());
                Constructor<?> constructor = clazz.getConstructor(Integer.class, GrouperVersionObject.class, Boolean.class);
                Object instance = constructor.newInstance(i, grouperRtList.get(i), loadDescription);
                GrouperIF grouper = (GrouperIF)instance;
                if (retGrouperList == null) {
                    retGrouperList = new TreeMap<String, GrouperIF>();
                }
                retGrouperList.put(grouper.getName(), grouper);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            Logger.getLogger(GrouperFactory.class.getName()).log(Level.SEVERE, null, e);
        }
        if (retGrouperList != null) {
            List grpList = retGrouperList.values().stream().collect(Collectors.toList());
            for (int i = 0; i < grpList.size() - 1; ++i) {
                if (!((GrouperIF)grpList.get(i)).isLinked()) continue;
                ((GrouperIF)grpList.get(i)).setNextVersion((GrouperIF)grpList.get(i + 1));
            }
            ((GrouperIF)grpList.get(grpList.size() - 1)).setUnlinked();
        }
        return retGrouperList;
    }

    @Override
    public List<GrouperIF> getAvailableVersions() {
        return this.grouperList.values().stream().collect(Collectors.toList());
    }

    @Override
    public String getBuildInfo() {
        Package pack;
        String title = null;
        String version = null;
        Properties p = new Properties();
        InputStream res = null;
        try {
            res = this.getClass().getResourceAsStream("/META-INF/maven/gov.cms/hh/pom.properties");
            if (res != null) {
                p.load(res);
                version = p.getProperty("version");
                title = p.getProperty("artifactId");
                res.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (version == null && (pack = this.getClass().getPackage()) != null) {
            version = pack.getImplementationVersion();
            if (version == null) {
                version = pack.getSpecificationVersion();
            }
            if ((title = pack.getImplementationTitle()) == null) {
                title = pack.getSpecificationTitle();
            }
        }
        if (version == null) {
            version = "(unknown)";
        }
        if (title == null) {
            title = "HH Grouper";
        }
        return "Software: " + title + ", Version: " + version;
    }
}

