/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.logic.processor;

import gov.cms.hh.claim.ClaimIF;
import gov.cms.hh.claim.OasisResponseIF;
import gov.cms.hh.claim.ReturnCode;
import gov.cms.hh.claim.ValidityFlag;
import gov.cms.hh.data.files.TableNames_EN;
import gov.cms.hh.data.meta.enumer.EditId_EN;
import gov.cms.hh.data.meta.enumer.EditType_EN;
import gov.cms.hh.data.meta.enumer.Oasis_EN;
import gov.cms.hh.diagnosis.ClinicalGroup;
import gov.cms.hh.diagnosis.ComorbidityGroup;
import gov.cms.hh.diagnosis.Diagnosis;
import gov.cms.hh.diagnosis.DiagnosisIF;
import gov.cms.hh.diagnosis.DiagnosisSubchapter;
import gov.cms.hh.grouper.DataManagerIF;
import gov.cms.hh.grouper.utility.Utility;
import gov.cms.hh.logic.specification.IsValidOasisResponse;
import gov.cms.hh.logic.validation.Edit;
import gov.cms.hh.reference.objects.ClinicalGroupObject;
import gov.cms.hh.reference.objects.ComorbidityGroupObject;
import gov.cms.hh.reference.objects.DiagnosisObject;
import gov.cms.hh.reference.objects.DiagnosisSubchapterObject;
import gov.cms.hh.reference.objects.HippsValueObject;
import gov.cms.hh.reference.objects.OasisRespondObject;
import gov.cms.hh.reference.objects.ReturnCodeObject;
import gov.cms.hh.reference.objects.ValidityFlagObject;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class HippsPositionAbstract {
    private final ClaimIF claim;
    private final DataManagerIF dataManager;

    protected DiagnosisIF findDxByComorbidity(List<DiagnosisIF> dxList, String name) {
        if (dxList == null || dxList.isEmpty() || name == null || name.isEmpty()) {
            return null;
        }
        for (DiagnosisIF dx : dxList) {
            if (dx.getEditCollection().hasEditId(EditId_EN.VALUE_INVALID) || dx.getEditCollection().hasEditId(EditId_EN.VALUE_IGNORE) || !dx.getComorbidityGroup().getName().trim().equalsIgnoreCase(name.trim())) continue;
            return dx;
        }
        return null;
    }

    protected void addHippsLogicMessage(EditId_EN hippsPosition, String text) {
        Edit edit = new Edit(hippsPosition, text, EditType_EN.SPECIFICATION, Level.INFO);
        this.getClaim().getHippsCode().addEdit(edit);
    }

    protected boolean validateFunctionalFields() {
        boolean valOther;
        boolean valHospRisk = this.validateRiskHospitalisation();
        if (!valHospRisk) {
            this.addReturnCode(Oasis_EN.M1033_HOSP_RISK_HSTRY_FALLS.getErrorReturnCode());
        }
        if (!(valHospRisk & (valOther = this.validateOtherFunctionalFields()))) {
            this.claim.getOasisFields().addEdit(new Edit(EditId_EN.VALUE_UNGROUPABLE, "OASIS has invalid or inconsistent value(s). " + EditId_EN.VALUE_UNGROUPABLE.getDescription(), EditType_EN.CONSISTENCY, Level.SEVERE));
        }
        return valHospRisk & valOther;
    }

    private String getValidValues(OasisResponseIF oResp, List<OasisRespondObject> refList) {
        ArrayList<String> validList = new ArrayList<String>();
        for (OasisRespondObject oasRespRef : refList) {
            if (!oResp.getType().name().startsWith(oasRespRef.getFieldId().trim().toUpperCase())) continue;
            validList.add(oasRespRef.getResponse());
        }
        return Utility.join(validList);
    }

    private boolean validateFunctionalField(OasisResponseIF oResp, List<OasisRespondObject> refList) {
        IsValidOasisResponse actualResp = new IsValidOasisResponse(oResp);
        for (OasisRespondObject oasRespRef : refList) {
            if (!actualResp.isSatisfiedBy(oasRespRef)) continue;
            oResp.setScore(Integer.parseInt(oasRespRef.getCategoryPoints()));
            return true;
        }
        return false;
    }

    private boolean validateOtherFunctionalFields() {
        boolean retFlag = true;
        String PREFIX_NOT = "M1033";
        List<OasisRespondObject> refList = this.dataManager.getDataMap().get(TableNames_EN.OASIS_Responses).getData();
        List<OasisResponseIF> oResList = this.claim.getOasisFields().getCollection();
        for (OasisResponseIF oResp : oResList) {
            if (oResp.getType().name().startsWith("M1033") || this.validateFunctionalField(oResp, refList)) continue;
            oResp.addEdit(new Edit(EditId_EN.VALUE_INVALID, oResp.toString() + ". Valid values=[" + this.getValidValues(oResp, refList) + "]", EditType_EN.CONSISTENCY, Level.SEVERE));
            this.addReturnCode(oResp.getType().getErrorReturnCode());
            retFlag = false;
        }
        return retFlag;
    }

    private boolean validateRiskHospitalisation() {
        boolean retFlag = true;
        String PREFIX = "M1033";
        List<String> VALID_VALUES = Arrays.asList("0", "1");
        int sum = 0;
        int noneAbove = 0;
        List<OasisResponseIF> oResList = this.claim.getOasisFields().getCollection();
        for (OasisResponseIF oResp : oResList) {
            if (!oResp.getType().name().startsWith("M1033")) continue;
            if (!VALID_VALUES.contains(oResp.getValue())) {
                oResp.addEdit(new Edit(EditId_EN.VALUE_INVALID, oResp.toString() + ". Valid values=[" + Utility.join(VALID_VALUES) + "]", EditType_EN.CONSISTENCY, Level.SEVERE));
                retFlag &= false;
                continue;
            }
            int val = Integer.parseInt(oResp.getValue());
            sum += val;
            if (oResp.getType().name().equals(Oasis_EN.M1033_HOSP_RISK_NONE_ABOVE.name())) {
                noneAbove = val;
            }
            if (!oResp.getType().name().equals(Oasis_EN.M1033_HOSP_RISK_CRNT_EXHSTN.name()) && !oResp.getType().name().equals(Oasis_EN.M1033_HOSP_RISK_OTHR_RISK.name())) continue;
            oResp.addEdit(new Edit(EditId_EN.VALUE_IGNORE, oResp.toString() + " " + EditId_EN.VALUE_IGNORE.getDescription(), EditType_EN.SPECIFICATION, Level.INFO));
        }
        if (noneAbove > 0 && sum - noneAbove > 0) {
            this.claim.getOasisFields().addEdit(new Edit(EditId_EN.VALUE_UNGROUPABLE, "If M1033_HOSP_RISK_NONE_ABOVE = 1, then all items from M1033_HOSP_RISK_HSTRY_FALLS through M1033_HOSP_RISK_OTHR_RISK must = 0. " + EditId_EN.VALUE_UNGROUPABLE.getDescription(), EditType_EN.CONSISTENCY, Level.SEVERE));
            retFlag &= false;
        }
        if (sum == 0) {
            this.claim.getOasisFields().addEdit(new Edit(EditId_EN.VALUE_UNGROUPABLE, "If M1033_HOSP_RISK_NONE_ABOVE = 0, then at least one item from M1033_HOSP_RISK_HSTRY_FALLS through M1033_HOSP_RISK_OTHR_RISK must = 1. " + EditId_EN.VALUE_UNGROUPABLE.getDescription(), EditType_EN.CONSISTENCY, Level.SEVERE));
            retFlag &= false;
        }
        return retFlag;
    }

    protected void validateDiagnoses() {
        try {
            DiagnosisIF pdx = this.claim.getPrimaryDiagnosis();
            this.validateDiagnosis(pdx);
            if (!pdx.isValid()) {
                pdx.addEdit(new Edit(EditId_EN.VALUE_INVALID, pdx.toString() + EditId_EN.VALUE_INVALID.getDescription(), EditType_EN.CONSISTENCY, Level.SEVERE));
            }
            List<DiagnosisIF> sdxList = this.claim.getSecondaryDiagnoses().getCollection();
            for (int i = 0; i < sdxList.size(); ++i) {
                DiagnosisIF diag = sdxList.get(i);
                this.validateDiagnosis(diag);
            }
        }
        catch (ParseException ex) {
            Logger.getLogger(HippsPositionAbstract.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void validateDiagnosis(DiagnosisIF dx) throws ParseException {
        DiagnosisIF dxRef = null;
        dxRef = this.getDiagnosisReference(dx.getValue());
        if (dxRef == null) {
            dx.setValid(false);
            dx.addEdit(new Edit(EditId_EN.VALUE_INVALID, dx.toString() + EditId_EN.VALUE_INVALID.getDescription(), EditType_EN.CONSISTENCY, Level.WARNING));
        } else {
            dx.setCodeFirst(dxRef.isCodeFirst());
            dx.setUnacceptablePdx(dxRef.isUnacceptablePdx());
            dx.setPrimaryAwarding(dxRef.isPrimaryAwarding());
            dx.setManifestation(dxRef.isManifestation());
            dx.setId(dxRef.getId());
            dx.setECOI(dxRef.isECOI());
            dx.setDescription(dxRef.getDescription());
            dx.setDiagnosisSubchapter(dxRef.getDiagnosisSubchapter());
            dx.setComorbidityGroup(dxRef.getComorbidityGroup());
            dx.setClinicalGroup(dxRef.getClinicalGroup());
            dx.setValid(true);
            dx.addEdit(new Edit(EditId_EN.VALUE_VALID, dxRef.toString() + EditId_EN.VALUE_VALID.getDescription(), EditType_EN.INFO, Level.INFO));
            dx.setCodeFirstCondition(dxRef.getCodeFirstCondition());
            dx.setUnspecifiedPdx(dxRef.isUnspecifiedPdx());
        }
        dx.setVerified(true);
    }

    protected DiagnosisIF getDiagnosisReference(String value) throws ParseException {
        Diagnosis dx = null;
        DiagnosisObject dxObj = (DiagnosisObject)this.dataManager.getDataMap().get(TableNames_EN.Diagnoses).getDataMap().get(value);
        if (dxObj == null) {
            return null;
        }
        ClinicalGroupObject clinicalGroupObj = (ClinicalGroupObject)this.dataManager.getDataMap().get(TableNames_EN.Clinical_Groups).getDataMap().get(dxObj.getClinicalGroup());
        ClinicalGroup clinicalGroup = null;
        if (clinicalGroupObj != null) {
            clinicalGroup = new ClinicalGroup(0, clinicalGroupObj);
        }
        ComorbidityGroupObject comorbidityGroupObj = (ComorbidityGroupObject)this.dataManager.getDataMap().get(TableNames_EN.Comorbidity_Groups).getDataMap().get(dxObj.getComorbidityGroup());
        ComorbidityGroup comorbidityGroup = null;
        if (comorbidityGroupObj != null) {
            comorbidityGroup = new ComorbidityGroup(0, comorbidityGroupObj);
        }
        List diagSubchapObjList = this.dataManager.getDataMap().get(TableNames_EN.Diagnosis_Subchapters).getData();
        DiagnosisSubchapter diagnosisSubchapter = null;
        for (DiagnosisSubchapterObject diagSubchapObj : diagSubchapObjList) {
            String key = diagSubchapObj.getDiagnosisFrom() + "-" + diagSubchapObj.getDiagnosisTo();
            if (!key.trim().equalsIgnoreCase(dxObj.getSubChapter().trim())) continue;
            diagnosisSubchapter = new DiagnosisSubchapter(diagSubchapObj);
            break;
        }
        dx = new Diagnosis(0, dxObj, clinicalGroup, comorbidityGroup, diagnosisSubchapter);
        return dx;
    }

    public boolean setHippsCode(int position, String value) {
        HippsValueObject hipps = this.getHippsValueReference(position, value);
        if (hipps != null) {
            this.getClaim().getHippsCode().setValue(hipps);
            return true;
        }
        Edit edit = new Edit(EditId_EN.VALUE_NOT_CALCULATED, "Not able to calculeate HIPPS value in position: " + position, EditType_EN.INFO, Level.SEVERE);
        this.getClaim().getHippsCode().addEdit(edit);
        return false;
    }

    private HippsValueObject getHippsValueReference(int position, String value) {
        for (Object obj : this.dataManager.getDataMap().get(TableNames_EN.HIPPS_Structure).getData()) {
            if (!((HippsValueObject)obj).getPosition().equals("" + position) || !((HippsValueObject)obj).getValue().equalsIgnoreCase(value)) continue;
            return (HippsValueObject)obj;
        }
        return null;
    }

    public boolean addReturnCode(int code) {
        ReturnCodeObject grcObj = this.getReturnCodeReference(code);
        if (grcObj != null) {
            ReturnCode grc = null;
            try {
                grc = new ReturnCode(grcObj);
            }
            catch (ParseException ex) {
                Logger.getLogger(HippsPositionAbstract.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (!this.getClaim().getReturnCodes().getCollection().contains(grc)) {
                this.getClaim().getReturnCodes().getCollection().add(grc);
            }
            return true;
        }
        Edit edit = new Edit(EditId_EN.VALUE_INVALID, "Not able to set Return Code: " + code, EditType_EN.INFO, Level.SEVERE);
        this.getClaim().getReturnCodes().addEdit(edit);
        return false;
    }

    public boolean addValidityFlag(int flag) {
        ValidityFlagObject vfObj = this.getValidityFlagReference(flag);
        if (vfObj != null) {
            ValidityFlag vf = null;
            try {
                vf = new ValidityFlag(vfObj);
            }
            catch (ParseException ex) {
                Logger.getLogger(HippsPositionAbstract.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (!this.getClaim().getValidityFlags().getCollection().contains(vf)) {
                this.getClaim().getValidityFlags().getCollection().add(vf);
            }
            return true;
        }
        Edit edit = new Edit(EditId_EN.VALUE_INVALID, "Not able to set Validity Flag: " + flag, EditType_EN.INFO, Level.SEVERE);
        this.getClaim().getValidityFlags().addEdit(edit);
        return false;
    }

    private ValidityFlagObject getValidityFlagReference(int flag) {
        for (Object obj : this.dataManager.getDataMap().get(TableNames_EN.Validity_Flags).getData()) {
            if (Integer.parseInt(((ValidityFlagObject)obj).getFlag()) != flag) continue;
            return (ValidityFlagObject)obj;
        }
        return null;
    }

    private ReturnCodeObject getReturnCodeReference(int code) {
        for (Object obj : this.dataManager.getDataMap().get(TableNames_EN.Return_Codes).getData()) {
            if (Integer.parseInt(((ReturnCodeObject)obj).getCode()) != code) continue;
            return (ReturnCodeObject)obj;
        }
        return null;
    }

    public HippsPositionAbstract(ClaimIF claim, DataManagerIF dataManager) {
        this.claim = claim;
        this.dataManager = dataManager;
    }

    public ClaimIF getClaim() {
        return this.claim;
    }

    public DataManagerIF getDataManager() {
        return this.dataManager;
    }
}

