/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.data.exchange;

import gov.cms.hh.data.meta.enumer.Oasis_EN;
import gov.cms.hh.logic.validation.EditCollection;
import gov.cms.hh.logic.validation.EditCollectionIF;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 *
 * @author CMS
 */
public class ClaimContainer implements ClaimContainerIF, Serializable {

    /**
     * ctor
     */

    public ClaimContainer() {
        this.edits = new EditCollection();
    }

    /**
     *
     * @return
     */
    @Override
    public String toString() {
        return "ClaimContainer{" + "claimId=" + claimId + ", fromDate=" 
                + fromDate + ", periodTiming=" + periodTiming + ", referralSource=" 
                + referralSource + ", pdx=" + pdx + ", sdxList=" + sdxList 
                + ", hospRiskHistoryFalls=" + hospRiskHistoryFalls 
                + ", hospRiskWeightLoss=" + hospRiskWeightLoss + ", hospRiskMultiHospital=" 
                + hospRiskMultiHospital + ", hospRiskMultiEdVisit=" + hospRiskMultiEdVisit 
                + ", hospRiskMentalBehavDecl=" + hospRiskMentalBehavDecl 
                + ", hospRiskCompliance=" + hospRiskCompliance + ", hospRiskFiveMoreMeds=" 
                + hospRiskFiveMoreMeds + ", hospRiskExhaustion=" + hospRiskExhaustion 
                + ", hospRiskOtherRisk=" + hospRiskOtherRisk + ", hospRiskNoneAbove=" 
                + hospRiskNoneAbove + ", grooming=" + grooming + ", dressUpper=" 
                + dressUpper + ", dressLower=" + dressLower + ", bathing=" 
                + bathing + ", toileting=" + toileting + ", transferring=" 
                + transferring + ", ambulation=" + ambulation + ", versionUsed=" 
                + versionUsed + ", HippsCode=" + hippsCode + ", validityFlag=" 
                + validityFlag + ", returnCode=" + returnCode + ", edits=" + edits + '}';
    }

    /**
     * @return the validityFlag
     */
    @Override
    public ValidityFlagContainerIF getValidityFlag() {
        return validityFlag;
    }

    /**
     * @return the returnCode
     */
    @Override
    public ReturnCodeContainerIF getReturnCode() {
        return returnCode;
    }

    /**
     * @return the sdxList
     */
    @Override
    public List<DxContainerIF> getSdxList() {
        return sdxList;
    }

    /**
     * @param sdxList the sdxList to set
     */
    @Override
    public void setSdxList(List<DxContainerIF> sdxList) {
        this.sdxList = sdxList;
    }
    // Input
    private String claimId;
    private String fromDate;
    private String periodTiming;
    private String referralSource;
    // Clinical
    private DxContainerIF pdx;
    private List<DxContainerIF> sdxList;
    // Functional
    private String hospRiskHistoryFalls;
    private String hospRiskWeightLoss;
    private String hospRiskMultiHospital;
    private String hospRiskMultiEdVisit;
    private String hospRiskMentalBehavDecl;
    private String hospRiskCompliance;
    private String hospRiskFiveMoreMeds;
    private String hospRiskExhaustion;
    private String hospRiskOtherRisk;
    private String hospRiskNoneAbove;
    private String grooming;
    private String dressUpper;
    private String dressLower;
    private String bathing;
    private String toileting;
    private String transferring;
    private String ambulation;
    // Output
    private String versionUsed;
    private String hippsCode;
    private ValidityFlagContainerIF validityFlag;
    private ReturnCodeContainerIF returnCode;

    // Report
    final private EditCollectionIF edits;
    
    // Development request
    private HippsContainerIF hippsContainerIF;

    /**
     * @return the claimId
     */
    @Override
    public String getClaimId() {
        return claimId;
    }

    /**
     * @param claimId the claimId to set
     */
    @Override
    public void setClaimId(String claimId) {
        this.claimId = claimId;
    }

    /**
     * @return the fromDate
     */
    @Override
    public String getFromDate() {
        return fromDate;
    }

    /**
     * @param fromDate the fromDate to set
     */
    @Override
    public void setFromDate(String fromDate) {
        this.fromDate = fromDate;
    }

    /**
     * @return the periodTiming
     */
    @Override
    public String getPeriodTiming() {
        return periodTiming;
    }

    /**
     * @param periodTiming the periodTiming to set
     */
    @Override
    public void setPeriodTiming(String periodTiming) {
        this.periodTiming = periodTiming;
    }

    /**
     * @return the referralSource
     */
    @Override
    public String getReferralSource() {
        return referralSource;
    }

    /**
     * @param referralSource the referralSource to set
     */
    @Override
    public void setReferralSource(String referralSource) {
        this.referralSource = referralSource;
    }

    /**
     * @return the hospRiskHistoryFalls
     */
    @Override
    public String getHospRiskHistoryFalls() {
        return hospRiskHistoryFalls;
    }

    /**
     * @param hospRiskHistoryFalls the hospRiskHistoryFalls to set
     */
    @Override
    public void setHospRiskHistoryFalls(String hospRiskHistoryFalls) {
        this.hospRiskHistoryFalls = hospRiskHistoryFalls;
    }

    /**
     * @return the hospRiskWeightLoss
     */
    @Override
    public String getHospRiskWeightLoss() {
        return hospRiskWeightLoss;
    }

    /**
     * @param hospRiskWeightLoss the hospRiskWeightLoss to set
     */
    @Override
    public void setHospRiskWeightLoss(String hospRiskWeightLoss) {
        this.hospRiskWeightLoss = hospRiskWeightLoss;
    }

    /**
     * @return the hospRiskMultiHospital
     */
    @Override
    public String getHospRiskMultiHospital() {
        return hospRiskMultiHospital;
    }

    /**
     * @param hospRiskMultiHospital the hospRiskMultiHospital to set
     */
    @Override
    public void setHospRiskMultiHospital(String hospRiskMultiHospital) {
        this.hospRiskMultiHospital = hospRiskMultiHospital;
    }

    /**
     * @return the hospRiskMultiEdVisit
     */
    @Override
    public String getHospRiskMultiEdVisit() {
        return hospRiskMultiEdVisit;
    }

    /**
     * @param hospRiskMultiEdVisit the hospRiskMultiEdVisit to set
     */
    @Override
    public void setHospRiskMultiEdVisit(String hospRiskMultiEdVisit) {
        this.hospRiskMultiEdVisit = hospRiskMultiEdVisit;
    }

    /**
     * @return the hospRiskMentalBehavDecl
     */
    @Override
    public String getHospRiskMentalBehavDecl() {
        return hospRiskMentalBehavDecl;
    }

    /**
     * @param hospRiskMentalBehavDecl the hospRiskMentalBehavDecl to set
     */
    @Override
    public void setHospRiskMentalBehavDecl(String hospRiskMentalBehavDecl) {
        this.hospRiskMentalBehavDecl = hospRiskMentalBehavDecl;
    }

    /**
     * @return the hospRiskCompliance
     */
    @Override
    public String getHospRiskCompliance() {
        return hospRiskCompliance;
    }

    /**
     * @param hospRiskCompliance the hospRiskCompliance to set
     */
    @Override
    public void setHospRiskCompliance(String hospRiskCompliance) {
        this.hospRiskCompliance = hospRiskCompliance;
    }

    /**
     * @return the hospRiskFiveMoreMeds
     */
    @Override
    public String getHospRiskFiveMoreMeds() {
        return hospRiskFiveMoreMeds;
    }

    /**
     * @param hospRiskFiveMoreMeds the hospRiskFiveMoreMeds to set
     */
    @Override
    public void setHospRiskFiveMoreMeds(String hospRiskFiveMoreMeds) {
        this.hospRiskFiveMoreMeds = hospRiskFiveMoreMeds;
    }

    /**
     * @return the hospRiskExhaustion
     */
    @Override
    public String getHospRiskExhaustion() {
        return hospRiskExhaustion;
    }

    /**
     * @param hospRiskRiskExhaustion the hospRiskExhaustion to set
     */
    @Override
    public void setHospRiskExhaustion(String hospRiskRiskExhaustion) {
        this.hospRiskExhaustion = hospRiskRiskExhaustion;
    }

    /**
     * @return the hospRiskOtherRisk
     */
    @Override
    public String getHospRiskOtherRisk() {
        return hospRiskOtherRisk;
    }

    /**
     * @param hospRiskOtherRisk the hospRiskOtherRisk to set
     */
    @Override
    public void setHospRiskOtherRisk(String hospRiskOtherRisk) {
        this.hospRiskOtherRisk = hospRiskOtherRisk;
    }

    /**
     * @return the hospRiskNoneAbove
     */
    @Override
    public String getHospRiskNoneAbove() {
        return hospRiskNoneAbove;
    }

    /**
     * @param hospRiskNoneAbove the hospRiskNoneAbove to set
     */
    @Override
    public void setHospRiskNoneAbove(String hospRiskNoneAbove) {
        this.hospRiskNoneAbove = hospRiskNoneAbove;
    }

    /**
     * @return the grooming
     */
    @Override
    public String getGrooming() {
        return grooming;
    }

    /**
     * @param grooming the grooming to set
     */
    @Override
    public void setGrooming(String grooming) {
        this.grooming = grooming;
    }

    /**
     * @return the dressUpper
     */
    @Override
    public String getDressUpper() {
        return dressUpper;
    }

    /**
     * @param dressUpper the dressUpper to set
     */
    @Override
    public void setDressUpper(String dressUpper) {
        this.dressUpper = dressUpper;
    }

    /**
     * @return the dressLower
     */
    @Override
    public String getDressLower() {
        return dressLower;
    }

    /**
     * @param dressLower the dressLower to set
     */
    @Override
    public void setDressLower(String dressLower) {
        this.dressLower = dressLower;
    }

    /**
     * @return the bathing
     */
    @Override
    public String getBathing() {
        return bathing;
    }

    /**
     * @param bathing the bathing to set
     */
    @Override
    public void setBathing(String bathing) {
        this.bathing = bathing;
    }

    /**
     * @return the toileting
     */
    @Override
    public String getToileting() {
        return toileting;
    }

    /**
     * @param toileting the toileting to set
     */
    @Override
    public void setToileting(String toileting) {
        this.toileting = toileting;
    }

    /**
     * @return the transferring
     */
    @Override
    public String getTransferring() {
        return transferring;
    }

    /**
     * @param transferring the transferring to set
     */
    @Override
    public void setTransferring(String transferring) {
        this.transferring = transferring;
    }

    /**
     * @return the ambulation
     */
    @Override
    public String getAmbulation() {
        return ambulation;
    }

    /**
     * @param ambulation the ambulation to set
     */
    @Override
    public void setAmbulation(String ambulation) {
        this.ambulation = ambulation;
    }

    /**
     * @return the versionUsed
     */
    @Override
    public String getVersionUsed() {
        return versionUsed;
    }

    /**
     * @param versionUsed the versionUsed to set
     */
    @Override
    public void setVersionUsed(String versionUsed) {
        this.versionUsed = versionUsed;
    }

    /**
     * @return the hippsCode
     */
    @Override
    public String getHippsCode() {
        return hippsCode;
    }

    /**
     * @param HippsCode the hippsCode to set
     */
    @Override
    public void setHippsCode(String HippsCode) {
        this.hippsCode = HippsCode;
    }

    /**
     *
     * @param pdx
     * @param poa
     */
    @Override
    public void setPdx(String pdx, String poa) {
        setPdx(new DxContainer(pdx, poa));
    }

    /**
     *
     * @param sdx
     * @param poa
     */
    @Override
    public void addSdx(String sdx, String poa) {
        if (getSdxList() == null) {
            setSdxList((List<DxContainerIF>) new ArrayList());
        }
        getSdxList().add(new DxContainer(sdx, poa));
    }

    /**
     * @return the pdx
     */
    @Override
    public DxContainerIF getPdx() {
        return pdx;
    }

    /**
     * @param pdx the pdx to set
     */
    @Override
    public void setPdx(DxContainerIF pdx) {
        this.pdx = pdx;
    }

    /**
     *
     * @return
     */
    @Override
    public String getReturnCodeValue() {
        return getReturnCode().getValue();
    }

    /**
     * @param returnCode the returnCode to set
     */
    @Override
    public void setReturnCode(ReturnCodeContainerIF returnCode) {
        this.returnCode = returnCode;
    }

    /**
     *
     * @return
     */
    @Override
    public String getReturnCodeDescription() {
        return getReturnCode().getDescription();
    }

    /**
     *
     * @return
     */
    @Override
    public String getValidityFlagValue() {
        return getValidityFlag().getValue();
    }

    /**
     *
     * @return
     */
    @Override
    public String getValidityFlagDescription() {
        return getValidityFlag().getDescription();
    }

    /**
     * @param validityFlag the validityFlag to set
     */
    @Override
    public void setValidityFlag(ValidityFlagContainerIF validityFlag) {
        this.validityFlag = validityFlag;
    }

    /**
     *
     * @return
     */
    @Override
    public Map<String, String> getFunctionalFields() {
        Map<String, String> retMap = new TreeMap<>();
        retMap.put(Oasis_EN.M1033_HOSP_RISK_HSTRY_FALLS.name(), hospRiskHistoryFalls);
        retMap.put(Oasis_EN.M1033_HOSP_RISK_WEIGHT_LOSS.name(), hospRiskWeightLoss);
        retMap.put(Oasis_EN.M1033_HOSP_RISK_MLTPL_HOSPZTN.name(), hospRiskMultiHospital);
        retMap.put(Oasis_EN.M1033_HOSP_RISK_MLTPL_ED_VISIT.name(), hospRiskMultiEdVisit);
        retMap.put(Oasis_EN.M1033_HOSP_RISK_MNTL_BHV_DCLN.name(), hospRiskMentalBehavDecl);
        retMap.put(Oasis_EN.M1033_HOSP_RISK_COMPLIANCE.name(), hospRiskCompliance);
        retMap.put(Oasis_EN.M1033_HOSP_RISK_5PLUS_MDCTN.name(), hospRiskFiveMoreMeds);
        retMap.put(Oasis_EN.M1033_HOSP_RISK_CRNT_EXHSTN.name(), hospRiskExhaustion);
        retMap.put(Oasis_EN.M1033_HOSP_RISK_OTHR_RISK.name(), hospRiskOtherRisk);
        retMap.put(Oasis_EN.M1033_HOSP_RISK_NONE_ABOVE.name(), hospRiskNoneAbove);
        retMap.put(Oasis_EN.M1800_CRNT_GROOMING.name(), grooming);
        retMap.put(Oasis_EN.M1810_CRNT_DRESS_UPPER.name(), dressUpper);
        retMap.put(Oasis_EN.M1820_CRNT_DRESS_LOWER.name(), dressLower);
        retMap.put(Oasis_EN.M1830_CRNT_BATHG.name(), bathing);
        retMap.put(Oasis_EN.M1840_CRNT_TOILTG.name(), toileting);
        retMap.put(Oasis_EN.M1850_CRNT_TRNSFRNG.name(), transferring);
        retMap.put(Oasis_EN.M1860_CRNT_AMBLTN.name(), ambulation);
        return retMap;
    }

    /**
     * @return the edits
     */
    @Override
    public EditCollectionIF getEdits() {
        return edits;
    }

    /**
     * @param edits the edits to set
     */
    @Override
    public void setEdits(EditCollectionIF edits) {
        this.edits.addEdits(edits.getEdits());
    }

    /**
     * @return the hippsContainerIF
     */
    @Override
    public HippsContainerIF getHippsContainer() {
        return hippsContainerIF;
    }

    /**
     *
     * @param hippsContainerIF
     */
    @Override
    public void setHippsContainer(HippsContainerIF hippsContainerIF) {
        this.hippsContainerIF = hippsContainerIF;
    }

}
