/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */

package gov.cms.hh.data.exchange;

import java.util.Map;
import java.util.TreeMap;

/**
 *
 * @author CMS
 */


public class HippsContainer implements HippsContainerIF {
    
    final String VALUE_POSITION_UNAVAILABLE = "NA";
    final String VALUE_UNAVAILABLE = "Value not available";
    
    Map<Integer, HippsPosition> hipps = new TreeMap();

    /**
     * ctor
     */
    public HippsContainer() {
        for (int i = 1; i < 6; i++) {
            hipps.put(i, new HippsPosition("0", VALUE_UNAVAILABLE));
        }
    }
    
    private HippsPosition getPosition(int position) {
        HippsPosition naPos = new HippsPosition("NA", "HIPPS position: '" + position + "' not applicable");
        return hipps.getOrDefault(position, naPos);
    }
    
    /**
     *
     * @param position
     * @return
     */
    @Override
    public String getPositionValue(int position) {
        return getPosition(position).getValue();
    }

    /**
     *
     * @param position
     * @param value
     */
    @Override
    public void setPositionValue(int position, String value) {
        HippsPosition pos = getPosition(position);
        if(!pos.getValue().equalsIgnoreCase(VALUE_POSITION_UNAVAILABLE)) {
            pos.setValue(value);
        }
    }

    /**
     *
     * @param position
     * @return
     */
    @Override
    public String getPositionDescription(int position) {
        return getPosition(position).getDescription();
    }

    /**
     *
     * @param position
     * @param description
     */
    @Override
    public void setPositionDescription(int position, String description) {
        HippsPosition pos = getPosition(position);
        if(!pos.getValue().equalsIgnoreCase(VALUE_POSITION_UNAVAILABLE)) {
            pos.setDescription(description);
        }
    }

    /**
     *
     * @return
     */
    @Override
    public int getPositionsCount() {
        return hipps.size();
    }
    
}
