/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.data.meta.enumer;

import gov.cms.hh.common.abstr.DescribableIF;
import gov.cms.hh.common.abstr.IdentifiableIF;

/**
 *
 * @author CMS
 */
public enum Oasis_EN implements DescribableIF, IdentifiableIF {

    // Oasis fields

    /**
     *
     */

    M1033_HOSP_RISK_HSTRY_FALLS(0,"Hosp risk: 2+ falls or injury fall in past year",7),

    /**
     *
     */
    M1033_HOSP_RISK_WEIGHT_LOSS(1,"Hosp risk: unintentional weight loss",7),

    /**
     *
     */
    M1033_HOSP_RISK_MLTPL_HOSPZTN(2,"Hosp risk: 2+ hospitalizations in past 6 months",7),

    /**
     *
     */
    M1033_HOSP_RISK_MLTPL_ED_VISIT(3,"Hosp risk: 2+ emergcy dept visits in past 6 months",7),

    /**
     *
     */
    M1033_HOSP_RISK_MNTL_BHV_DCLN(4,"Hosp risk: decline mental/emotional/behav status",7),

    /**
     *
     */
    M1033_HOSP_RISK_COMPLIANCE(5,"Hosp risk: difficulty with medical instructions",7),

    /**
     *
     */
    M1033_HOSP_RISK_5PLUS_MDCTN(6,"Hosp risk: taking five or more medications",7),

    /**
     *
     */
    M1033_HOSP_RISK_CRNT_EXHSTN(7,"Hosp risk: current exhaustion",7),

    /**
     *
     */
    M1033_HOSP_RISK_OTHR_RISK(8,"Hosp risk: other risk(s) not listed",7),

    /**
     *
     */
    M1033_HOSP_RISK_NONE_ABOVE(9,"Hosp risk: none of the above",7),
    
    /**
     *
     */
    M1800_CRNT_GROOMING(10,"Current: grooming",8),

    /**
     *
     */
    M1810_CRNT_DRESS_UPPER(11,"Current: dress upper body",9),

    /**
     *
     */
    M1820_CRNT_DRESS_LOWER(12,"Current: dress lower body",10),

    /**
     *
     */
    M1830_CRNT_BATHG(13,"Current: bathing",11),

    /**
     *
     */
    M1840_CRNT_TOILTG(14,"Current: toileting",12),

    /**
     *
     */
    M1850_CRNT_TRNSFRNG(15,"Current: transferring",13),

    /**
     *
     */
    M1860_CRNT_AMBLTN(16,"Current: ambulation",14)
    
    ;
    
    private String description;
    private int id;
    private int errorReturnCode;
    

    private Oasis_EN(int id, String description, int errorReturnCode) {
        this.id = id;
        this.description = description;
        this.errorReturnCode = errorReturnCode;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     *
     * @return
     */
    @Override
    public String toString() {
        return description;
    }

    /**
     * @return the id
     */
    @Override
    public int getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    @Override
    public void setId(int id) {
        this.id = id;
    }

    /**
     * @return the errorReturnCode
     */
    public int getErrorReturnCode() {
        return errorReturnCode;
    }

    /**
     * @param errorReturnCode the errorReturnCode to set
     */
    public void setErrorReturnCode(int errorReturnCode) {
        this.errorReturnCode = errorReturnCode;
    }
    
}
