/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.grouper;

import gov.cms.hh.data.files.TableNames_EN;
import gov.cms.hh.data.exchange.ClaimContainerIF;
import gov.cms.hh.data.loader.PositionAccessorIF;
import gov.cms.hh.common.abstr.DescribableIF;
import gov.cms.hh.common.abstr.IdentifiableIF;
import gov.cms.hh.common.abstr.NameableIF;
import java.util.Date;
import java.util.List;

/**
 *
 * @author CMS
 */
public interface GrouperIF extends IdentifiableIF, DescribableIF, NameableIF{

    /**
     *
     * @return
     */
    List<Integer> getClaimLayout();

    /**
     *
     * @return
     */
    List<Integer> getClaimLayoutInputOnly();

    /**
     *
     * @return
     */
    ClaimContainerIF getEmptyClaim();

    /**
     *
     * @param claim
     */
    void group(ClaimContainerIF claim);

    /**
     *
     * @param claimInput
     * @return
     */
    String group(String claimInput);

    /**
     *
     * @return
     */
    Date getStartDate();

    /**
     *
     * @return
     */
    Date getEndDate();

    /**
     *
     * @return
     */
    boolean isActive();

    /**
     *
     * @return
     */
    boolean isDefault();

    /**
     *
     * @return
     */
    String getVersion();

    /**
     *
     * @param tableType
     * @return
     */
    DataContainerIF<PositionAccessorIF> getAvailableTableContent(TableNames_EN tableType);

    /**
     * 
     * Set link to next version for spanning claims
     * @param nextVersion
     * 
     */    
    void setNextVersion(GrouperIF nextVersion);

    /**
     * 
     * Get link to next version for spanning claims
     * @return GrouperIF
     * 
     */    
    GrouperIF getNextVersion();

    /**
     *
     * @return linked flag
     */
    boolean isLinked();

    /**
     * 
     * Set flag to link
     * 
     */    
    void setLinked();

    /**
     * 
     * Set flag to unlink
     * 
     */
    void setUnlinked();
    
}
