/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.logic.specification;

import gov.cms.hh.data.meta.MetaData;
import static gov.cms.hh.data.meta.MetaData.FORMAT_DATE;
import gov.cms.hh.grouper.GrouperIF;
import gov.cms.hh.logic.specification.abstr.AbstractSpecification;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;

/**
 *
 * @author CMS
 */
public class IsSpanClaim extends AbstractSpecification<GrouperIF> {

    private Date date = null;

    /**
     *
     * @param date
     */
    public IsSpanClaim(String date) {
        this.date = processDate(date);
    }

    private Date processDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_DATE);
        sdf.setLenient(false);
        Date ret = null;
        try {
            ret = sdf.parse(date);
        } catch (ParseException ex) {
            // to prevent NPE
        }
        return ret;
    }

    /**
     *
     * @param gv
     * @return
     */
    @Override
    public boolean isSatisfiedBy(GrouperIF gv) {
        return isDaysInRange(gv.getEndDate(), MetaData.SPAN_CLAIM_RANGE_IN_DAYS);
    }

    private boolean isDaysInRange(final Date end, final int range) {
        if (date == null) {
            return false;
        }
        // Convert to Local Date as more safe for day range calculation 
        LocalDate startDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate endDate = end.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        // Calculate span in days 
        long days = ChronoUnit.DAYS.between(startDate, endDate);
        return (days < range);
    }
}
