/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.logic.specification;

import static gov.cms.hh.data.meta.MetaData.FORMAT_DATE;
import gov.cms.hh.grouper.GrouperIF;
import gov.cms.hh.logic.specification.abstr.AbstractSpecification;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 *
 * @author CMS
 */
public class IsValidFromDate extends AbstractSpecification<GrouperIF> {

    private Date date = null;

    /**
     *
     * @param date
     */
    public IsValidFromDate(String date) {
        this.date = processDate(date);
    }

    private Date processDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_DATE);
        sdf.setLenient(false);
        Date ret = null;
        try {
            ret = sdf.parse(date);
        } catch (ParseException ex) {
            // to prevent NPE
        }
        return ret;
    }

    /**
     *
     * @param gv
     * @return
     */
    @Override
    public boolean isSatisfiedBy(GrouperIF gv) {
        return isDateInBetweenIncludingEndPoints(gv.getStartDate(), gv.getEndDate());
    }

    private boolean isDateInBetweenIncludingEndPoints(final Date min, final Date max) {
        if (date == null) {
            return false;
        }
        return !(date.before(min) || date.after(max));
    }
}
