/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.reference.objects;

import gov.cms.hh.data.loader.RecordLayoutIF;
import gov.cms.hh.xml.layout.claim.ClaimField;
import gov.cms.hh.xml.layout.claim.ClaimLayout;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author CMS
 */
public class ClaimLayoutObject extends ClaimLayout implements RecordLayoutIF {
    
    /**
     *
     * @return
     */
    @Override
    public List<Integer> getLayout() {
        List<Integer> retList = null;
        if (getClaimField() != null) {
            for (ClaimField clFld : getClaimField()) {
                if (retList == null) {
                    retList = new ArrayList();
                }
                retList.addAll(getLayout(Integer.parseInt(clFld.getSequence())));
            }
        }
        return retList;
    }

    private List<Integer> getLayout(int fieldNumber) {
        List<Integer> retList = null;
        if (getClaimField() != null) {
            for (ClaimField clFld : getClaimField()) {
                if (Integer.parseInt(clFld.getSequence()) == fieldNumber) {
                    for (int i = 0; i < Integer.parseInt(clFld.getOccurrence()); i++) {
                        if (retList == null) {
                            retList = new ArrayList();
                        }
                        retList.add(Integer.valueOf(clFld.getLength()));
                    }
                }
            }
        }
        return retList;
    }

}
