/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.reference.objects;

import gov.cms.hh.data.loader.PositionAccessorIF;
import gov.cms.hh.xml.layout.rot.ComorbidityInteraction;

/**
 *
 * @author CMS
 */
public class ComorbidityInteractionObject extends ComorbidityInteraction implements PositionAccessorIF {

    /**
     *
     * @return
     */
    @Override
    public String toString() {
        return "Comorbidity Interaction ID:'" + getId() +
                "', Comorbidity Group 1:'" + getGroup1() +
                "', Comorbidity Group 2:'" + getGroup2() +
                "'";
    }
    
    /**
     *
     * @param position
     * @return
     */
    @Override
    public String getByPosition(int position) {
        switch(position) {
            case 0:
                return getId();
            case 1:
                return getGroup1();
            case 2:
                return getGroup2();
            default:
                return null; // Exception???
        }
    }

    /**
     *
     * @param position
     * @param value
     * @return
     */
    @Override
    public boolean setByPosition(int position, String value) {
        switch(position) {
            case 0:
                setId(value);
                return true;
            case 1:
                setGroup1(value);
                return true;
            case 2:
                setGroup2(value);
                return true;
            default:
                return false; // Exception???
        }
    }

    /**
     *
     * @return
     */
    @Override
    public int getNumberOfFields() {
        return 3;
    }


    private boolean loadDescription;
    
    /**
     * @return the loadDescription
     */
    @Override
    public boolean isLoadDescription() {
        return loadDescription;
    }

    /**
     * @param loadDescription the loadDescription to set
     */
    @Override
    public void setLoadDescription(boolean loadDescription) {
        this.loadDescription = loadDescription;
    }
    
}
