
package gov.cms.hh.v04123;

import gov.cms.hh.claim.ClaimIF;
import gov.cms.hh.grouper.DataManagerIF;
import gov.cms.hh.logic.processor.HippsPosition1;
import gov.cms.hh.logic.processor.HippsPosition3;
import gov.cms.hh.logic.processor.HippsPosition4;
import gov.cms.hh.logic.processor.HippsPosition5;
import gov.cms.hh.logic.processor.HippsPositionIF;
import gov.cms.hh.v04023.HippsProcessor_v04023;
import java.util.LinkedList;
import java.util.List;

/**
 *
 * @author CMS
 */
public class HippsProcessor_v04123 extends HippsProcessor_v04023 {
    @Override
    public void process(ClaimIF claim, DataManagerIF dataManager) {
        // Build HIPPS position logic pool
        List<HippsPositionIF> steps = new LinkedList<>();

        steps.add(new HippsPosition1(claim, dataManager));
        steps.add(new HippsPosition2_v04123(claim, dataManager));
        steps.add(new HippsPosition3(claim, dataManager));
        steps.add(new HippsPosition4(claim, dataManager));
        steps.add(new HippsPosition5(claim, dataManager));

        // Execute logic
        executeLogic(steps);
    }    
}
