
* PROGRAM: COST_SHARING_AMBULANCE.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR AMBULANCE CLAIMS;


%MACRO AMBULANCE_COST_SHARE_CAT(CATNUM,CATNAME,CATPOS);

  DATA AMBULANCE_BASEID;
    RETAIN JOIN_ID '1';
    SET &INC(WHERE = (CATEGORY = "10a&CATNUM."));
  RUN;

  DATA AMBULANCE_FILE;
    SET PBP_FILE (KEEP =
        CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
        PBP_B10A_MAXENR_&CATNAME._AMT
        PBP_B10A_MAXENR_&CATNAME._PER
        PBP_B10A_COPAY_&CATNAME._AMT_MIN
        PBP_B10A_COPAY_&CATNAME._AMT_MAX
        PBP_B10A_COINS_&CATNAME._PCT_MIN
        PBP_B10A_COINS_&CATNAME._PCT_MAX
        PBP_B10A_DED_&CATNAME._AMT
        PBP_A_PLAN_TYPE
        PBP_D_DIFF_DEDUCT_10A&CATNUM._AMT
        PBP_B10A_COINS_EHC
        PBP_B10A_COPAY_EHC
        PBP_B10A_DED_EHC
        PBP_B10A_MAXENR_EHC
        PBP_B10A_COPAY_WAV_YN
        PBP_B10A_COINS_WAV_YN);
    JOIN_ID = '1';
    %ANNUALIZATION(PBP_B10A_MAXENR_&CATNAME._PER,PBP_B10A_MAXENR_&CATNAME._AMT);
  RUN;

  PROC SQL;
    CREATE TABLE CAT_JOIN AS
    (SELECT B.CATEGORY, B.BASEID, B.VISITS, B.AMTTOT, B.YEAR, P.*
    FROM AMBULANCE_BASEID B, AMBULANCE_FILE P
    WHERE B.JOIN_ID = P.JOIN_ID)
    ORDER BY HPLAN, BASEID, YEAR, CATEGORY;
    QUIT;
  RUN;

  DATA CAT_JOIN;
    MERGE CAT_JOIN (IN = A) PBPCATS_MCCOST_DED (IN = B WHERE=(CATEGORY="10a&CATNUM."));
    BY HPLAN BASEID YEAR CATEGORY;
    IF A;
    LENGTH PLAN_DED_CAT $1;
    IF B THEN PLAN_DED_CAT='1';
    ELSE PLAN_DED_CAT='0';
  RUN;

  DATA AMBULANCE_&CATNAME.;
    SET CAT_JOIN (DROP = JOIN_ID);

    IF PBP_B10A_MAXENR_&CATNAME._AMT NE . & SUBSTR(PBP_B10A_MAXENR_EHC,&CATPOS.,1)='1' THEN
      BENE_MAXIMUM = PBP_B10A_MAXENR_&CATNAME._AMT;

    COST_SHARE_COST = 0;
    OTHER_COST = 0;
    COST = 0;

    IF PLAN_DED_CAT='1' THEN DO;
      IF PLAN_DED_AMTTOT_MC_PTB>0 THEN CAT_DEDUCTIBLE=PLAN_DED_AMTTOT_MC_PTB;
      ELSE CAT_DEDUCTIBLE=PLAN_DED_AMTTOT_MC;
    END;
    ELSE IF PBP_A_PLAN_TYPE IN('04','31','44','47') THEN
      CAT_DEDUCTIBLE=PBP_D_DIFF_DEDUCT_10A&CATNUM._AMT;
    ELSE IF SUBSTR(PBP_B10A_DED_EHC,&CATPOS.,1)='1' THEN CAT_DEDUCTIBLE=PBP_B10A_DED_&CATNAME._AMT;

    IF CAT_DEDUCTIBLE = . THEN DO;
      IF SUBSTR(PBP_B10A_COPAY_EHC,&CATPOS.,1)='1' &  PBP_B10A_COPAY_WAV_YN NE '1' THEN
        COST = SUM(COST,(VISITS*PBP_B10A_COPAY_&CATNAME._AMT_MIN));
      IF SUBSTR(PBP_B10A_COINS_EHC,&CATPOS.,1)='1' & PBP_B10A_COINS_WAV_YN NE '1' THEN
        COST = SUM(COST,(AMTTOT*PBP_B10A_COINS_&CATNAME._PCT_MIN));
    END;
    ELSE DO;
      IF AMTTOT <= CAT_DEDUCTIBLE THEN DO;
        COST = AMTTOT;
      END;
      ELSE DO;
        COST = CAT_DEDUCTIBLE;
        DEDUCT_SHARE = CAT_DEDUCTIBLE / AMTTOT;
        AMTTOT = SUM(AMTTOT,-CAT_DEDUCTIBLE);
        VISITS = VISITS * (1 - DEDUCT_SHARE);
        IF SUBSTR(PBP_B10A_COPAY_EHC,&CATPOS.,1)='1' & PBP_B10A_COPAY_WAV_YN NE '1' THEN
          COST = SUM(COST,(VISITS*PBP_B10A_COPAY_&CATNAME._AMT_MIN));
        IF SUBSTR(PBP_B10A_COINS_EHC,&CATPOS.,1)='1' & PBP_B10A_COINS_WAV_YN NE '1' THEN
          COST = SUM(COST,(AMTTOT*PBP_B10A_COINS_&CATNAME._PCT_MIN));
      END;
    END;

    IF BENE_MAXIMUM >= 0 AND COST >= 0 THEN COST = MIN(COST,BENE_MAXIMUM);

    COST_SHARE_COST = COST;

    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

  RUN;

  PROC DATASETS LIBRARY = WORK NODETAILS NOLIST;
    DELETE AMBULANCE_BASEID AMBULANCE_FILE CAT_JOIN;
    QUIT;
  RUN;

%MEND;

%MACRO AMBULANCE_COST_SHARE(SERV_CAT);

  %AMBULANCE_COST_SHARE_CAT(1,GAS,2);
  %AMBULANCE_COST_SHARE_CAT(2,AAS,1);

  DATA AMB;
    SET AMBULANCE_GAS AMBULANCE_AAS;
    *CATEGORY = "10a";
  RUN;

  PROC SUMMARY DATA = AMB NWAY MISSING;
    CLASS HPLAN YEAR BASEID CATEGORY;
    VAR COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
         OTHER_COST COST  AMTTOT;
    OUTPUT OUT = AMBULANCE (DROP = _TYPE_ _FREQ_) SUM = ;
  RUN;

  PROC APPEND DATA=AMBULANCE (KEEP=HPLAN YEAR BASEID COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
         OTHER_COST COST CATEGORY AMTTOT)  BASE = COSTDATA FORCE;
  RUN;

  PROC DATASETS LIBRARY = WORK NODETAILS NOLIST;
    DELETE AMBULANCE AMB AMBULANCE_GAS AMBULANCE_AAS;
    QUIT;
  RUN;

%MEND;
