
* PROGRAM: PBP_IMPORT_PARTD.SAS;
* DESCRIPTION: IMPORT THE INDIVIDUAL PBP TABLES AND MERGE TOGETHER;

PROC IMPORT OUT= WORK.PBP_FILE_PARTD
  DATATABLE= "PBP"
  DBMS=ACCESS REPLACE;
  DATABASE="&PBP\PBP&RUNYEAR..MDB";
  SCANMEMO=YES;
  USEDATE=NO;
  SCANTIME=YES;
RUN;

DATA PBP_FILE_PARTD;
  SET PBP_FILE_PARTD(KEEP=PBP_A_CONTRACT_NUMBER
  PBP_A_PLAN_IDENTIFIER
  PBP_A_SEGMENT_ID
  PBP_A_SPECIAL_NEED_PLAN_TYPE);
RUN;

DATA PBP_FILE_PARTD(RENAME=(PBP_A_CONTRACT_NUMBER=CONTRACT_ID PBP_A_PLAN_IDENTIFIER=PLAN_ID));
  LENGTH SEGMENT_ID_N 3 HPLAN $11;
  KEEP HPLAN PBP_A_CONTRACT_NUMBER PBP_A_PLAN_IDENTIFIER;
  SET PBP_FILE_PARTD;
  SEGMENT_ID_N = INPUT(PBP_A_SEGMENT_ID,3.);
  HPLAN = LEFT(PBP_A_CONTRACT_NUMBER!!PBP_A_PLAN_IDENTIFIER!!PUT(SEGMENT_ID_N,Z3.));
  IF PUT(HPLAN,$TYPEF.) NE 'NO';
RUN;

PROC SORT;
  BY HPLAN;
RUN;

%INCLUDE IN0(CONVERT);
RUN;

%PBPIMPCONV(PBPMRX)
RUN;

data pbpmrx;
  SET PBPMRX(KEEP=
  QID
  MRX_DRUG_BEN_YN
  MRX_BENEFIT_TYPE
  MRX_ALT_COV_LMT_YN
  MRX_ALT_COV_LMT_AMT
  MRX_ALT_DED_CHARGE
  MRX_ALT_DED_AMOUNT
  MRX_AE_CSTSHR_APPLY
  MRX_ALT_PRE_ICL_COST_SHARE
  MRX_ALT_GAP_COVG_YN
  MRX_AE_OOPTCS_APPLY
  MRX_ALT_CSTSHR_POST_OOPT
  MRX_ALT_DED_TYPE_YN
  MRX_ALT_NO_DED_TIER
  MRX_ALT_DED_TIER_CSTSHR_YN
  MRX_ALT_GEN_COINS_PCT
  MRX_ALT_GEN_COPAY_AMT
  MRX_ALT_GEN_CSTSHR_STRUCT
  MRX_FIRST_FILL
  );
RUN;

DATA PBP_MRX;
  MERGE PBP_FILE_PARTD (IN=IN1 KEEP=HPLAN)
        PBPMRX (IN=IN2 RENAME=QID=HPLAN);
  BY HPLAN;
  IF IN1 AND IN2;
RUN;

%PBPIMPCONV(PBPMRX_P)
RUN;

DATA PBPMRX_P;
  SET PBPMRX_P(KEEP=
  QID
  MRX_TIER_POST_COST_STRUCT
  MRX_TIER_POST_ID
  MRX_TIER_POST_TYPE_ID
  MRX_TIER_POST_COPAY_AMT
  MRX_TIER_POST_COINS_PCT);
RUN;

DATA PBP_MRX_P;
  MERGE PBP_FILE_PARTD (IN=IN1 KEEP=HPLAN) 
        PBPMRX_P (IN=IN2 RENAME=QID=HPLAN);
  BY HPLAN;
  IF IN1 AND IN2;
RUN;

%PBPIMPCONV(PBPMRX_T)
RUN;

DATA PBPMRX_T;
  SET PBPMRX_T(KEEP=QID
  MRX_TIER_ID
  MRX_TIER_TYPE_ID
  MRX_TIER_CSTSHR_STRUCT_TYPE
  MRX_TIER_RSPFD_COPAY_1M
  MRX_TIER_RSTD_COPAY_1M
  MRX_TIER_RSSTD_COPAY_1M
  MRX_TIER_OONP_COPAY_1M
  MRX_TIER_RSPFD_COINS_1M
  MRX_TIER_RSTD_COINS_1M
  MRX_TIER_RSSTD_COINS_1M
  MRX_TIER_OONP_COINS_1M
  MRX_TIER_GAP_COST_SHARE
  MRX_TIER_INCLUDES);
RUN;

DATA PBP_MRX_TIER;
  MERGE PBP_FILE_PARTD (IN=IN1 KEEP=HPLAN) 
        PBPMRX_T (IN=IN2 RENAME=QID=HPLAN);
  BY HPLAN;
  IF IN1 AND IN2;
RUN;
