* PROGRAM: BASEID_PLAN_YEAR.SAS;

%MACRO BASEID_PLAN(YEAR);

PROC SORT DATA=PBPCATS_MCCOST_&YEAR;
BY BASEID HPLAN;
RUN;

DATA PBPCATS_MCCOST_DED;
  SET PBPCATS_MCCOST_&YEAR;
  BY BASEID HPLAN;
  OUTPUT;
  KEEP BASEID HPLAN CATEGORY COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO OTHER_COST AMTTOT;
RUN;

PROC SORT DATA = PBPCATS_MCCOST_DED OUT = PBPCATS_MCCOST;
  BY HPLAN CATEGORY;
RUN;

*******;
*** READ THE PBP_D DATA FROM DST_DATA AND BUILD A DATASET WITH EACH ROW REPRESENTING;
*** A CONTRACT AND A CATEGORY FOR WHICH THERE IS A MAX OUT OF POCKET EXPENSE;
*** THIS DATASET HAS TWO VARIABLES: HPLAN AND CATEGORY;
*******;

********;
*** CAPPING MEDICARE COSTS;
********;

DATA MAX_CATS_M;
  SET  PBP_FILE(KEEP = HPLAN
                       PBP_A_PLAN_TYPE
                       PBP_A_NETWORK_FLAG
                       PBP_D_OUT_POCKET_AMT_YN
                       PBP_D_OUT_POCKET_AMT
                       PBP_D_INN_MAX_ENR_M_YN
                       PBP_D_INN_MAX_ENR_NM_YN
                       PBP_D_INN_MAX_ENR_M_CAT_EX
                       PBP_D_INN_MAX_ENR_NM_CAT_EX

                       PBP_D_COMB_MAX_ENR_AMT
                       PBP_D_COMB_MAX_ENR_INN_M_YN
                       PBP_D_COMB_MAX_ENR_INN_NM_YN
                       PBP_D_COMB_MAX_ENR_INN_MCAT_EX
                       PBP_D_COMB_MAX_ENR_INN_NMCATEX

                       PBP_D_MAXENR_OOPC_AMT
                       PBP_D_MAXENR_OOPC_M_CATS_YN
                       PBP_D_MAXENR_OOPC_NM_CATS_YN
                       PBP_D_MAXENR_OOPC_M_CATS
                       PBP_D_MAXENR_OOPC_NM_CATS);

  LENGTH CATEGORY $4 TYPE $4 PBP_D_INN_MAX_ENR_M_CAT_EX_S PBP_D_COMB_MAX_ENR_INN_MCAT_EX_S $1024;
  LENGTH PBP_D_MAXENR_OOPC_M_CATS_S $1024;
  TYPE=PUT(HPLAN,$TYPEF.);
  PBP_D_INN_MAX_ENR_M_CAT_EX_S=PBP_D_INN_MAX_ENR_M_CAT_EX;
  PBP_D_COMB_MAX_ENR_INN_MCAT_EX_S=PBP_D_COMB_MAX_ENR_INN_MCAT_EX;
  PBP_D_MAXENR_OOPC_M_CATS_S=PBP_D_MAXENR_OOPC_M_CATS;

  ** USE INN MAX IF AVAILABLE, COMBINED IF NOT AND THEN FOR RPPOS, USE THE MAXENR AMT;

  IF PBP_D_OUT_POCKET_AMT NE . | PBP_D_COMB_MAX_ENR_AMT NE . | PBP_D_MAXENR_OOPC_AMT  NE . THEN
    OUT_POCKET_MAX_YN='1';
  ELSE OUT_POCKET_MAX_YN='2';

  IF PBP_D_OUT_POCKET_AMT NE . THEN DO;
    IF PBP_D_INN_MAX_ENR_M_YN = '1' | TYPE = 'MSA' THEN DO I = 1 TO 48;
      CATEGORY = PUT(I,INMMAX.);
      OUTPUT;
      IF CATEGORY = '15' THEN DO;
        CATEGORY = '15m';
        OUTPUT;
        CATEGORY = '15c';
        OUTPUT;
      END;
      ELSE IF CATEGORY = '8a' THEN DO;
        CATEGORY = '8a1';
        OUTPUT;
        CATEGORY = '8a2';
        OUTPUT;
      END;
      ELSE IF CATEGORY = '8b' THEN DO;
        CATEGORY = '8b1';
        OUTPUT;
        CATEGORY = '8b2';
        OUTPUT;
        CATEGORY = '8b3';
        OUTPUT;
      END;
    END;
    ELSE DO I=1 TO LENGTH(PBP_D_INN_MAX_ENR_M_CAT_EX_S);
      SEMISPOT=INDEX(PBP_D_INN_MAX_ENR_M_CAT_EX_S,';');
      IF SEMISPOT>0 THEN DO;
        CATEGORY=SUBSTR(PBP_D_INN_MAX_ENR_M_CAT_EX_S,1,SEMISPOT-1);
        OUTPUT;
        IF CATEGORY = '15' THEN DO;
	  CATEGORY = '15m';
	  OUTPUT;
	  CATEGORY = '15c';
	  OUTPUT;
	END;
	ELSE IF CATEGORY = '8a' THEN DO;
	  CATEGORY = '8a1';
	  OUTPUT;
	  CATEGORY = '8a2';
	  OUTPUT;
	END;
	ELSE IF CATEGORY = '8b' THEN DO;
	  CATEGORY = '8b1';
	  OUTPUT;
	  CATEGORY = '8b2';
	  OUTPUT;
	  CATEGORY = '8b3';
	  OUTPUT;
        END;
        ELSE IF CATEGORY='3-1' THEN DO;
          CATEGORY='3c';
          OUTPUT;
        END;
        ELSE IF CATEGORY='3-3' THEN DO;
    	  CATEGORY='3p';
    	  OUTPUT;
    	END;
        ELSE IF CATEGORY='3-4' THEN DO;
    	  CATEGORY='3s';
    	  OUTPUT;
    	END;    	
        PBP_D_INN_MAX_ENR_M_CAT_EX_S=SUBSTR(PBP_D_INN_MAX_ENR_M_CAT_EX_S,SEMISPOT+1);
      END;
    END;
  END;
  ELSE IF PBP_D_OUT_POCKET_AMT =. & PBP_D_COMB_MAX_ENR_AMT NE . THEN DO;
    IF PBP_D_COMB_MAX_ENR_INN_M_YN = '1' | TYPE = 'MSA' THEN DO I = 1 TO 48;
      CATEGORY = PUT(I,COMMMAX.);
      OUTPUT;
      IF CATEGORY = '15' THEN DO;
        CATEGORY = '15m';
        OUTPUT;
        CATEGORY = '15c';
        OUTPUT;
      END;
      ELSE IF CATEGORY = '8a' THEN DO;
        CATEGORY = '8a1';
        OUTPUT;
        CATEGORY = '8a2';
        OUTPUT;
      END;
      ELSE IF CATEGORY = '8b' THEN DO;
        CATEGORY = '8b1';
        OUTPUT;
        CATEGORY = '8b2';
        OUTPUT;
        CATEGORY = '8b3';
        OUTPUT;
      END;
    END;
    ELSE DO I=1 TO LENGTH(PBP_D_COMB_MAX_ENR_INN_MCAT_EX_S);
      SEMISPOT=INDEX(PBP_D_COMB_MAX_ENR_INN_MCAT_EX_S,';');
      IF SEMISPOT>0 THEN DO;
        CATEGORY=SUBSTR(PBP_D_COMB_MAX_ENR_INN_MCAT_EX_S,1,SEMISPOT-1);
        OUTPUT;
        IF CATEGORY = '15' THEN DO;
          CATEGORY = '15m';
    	  OUTPUT;
    	  CATEGORY = '15c';
    	  OUTPUT;
    	END;
    	ELSE IF CATEGORY = '8a' THEN DO;
    	  CATEGORY = '8a1';
    	  OUTPUT;
    	  CATEGORY = '8a2';
    	  OUTPUT;
    	END;
    	ELSE IF CATEGORY = '8b' THEN DO;
    	  CATEGORY = '8b1';
    	  OUTPUT;
    	  CATEGORY = '8b2';
    	  OUTPUT;
    	  CATEGORY = '8b3';
    	  OUTPUT;
        END;
        ELSE IF CATEGORY='3-1' THEN DO;
          CATEGORY='3c';
          OUTPUT;
        END;
        ELSE IF CATEGORY='3-3' THEN DO;
          CATEGORY='3p';
          OUTPUT;
        END;
        ELSE IF CATEGORY='3-4' THEN DO;
          CATEGORY='3s';
          OUTPUT;
        END;        
        PBP_D_COMB_MAX_ENR_INN_MCAT_EX_S=SUBSTR(PBP_D_COMB_MAX_ENR_INN_MCAT_EX_S,SEMISPOT+1);
      END;
    END;
  END;
  ELSE IF PBP_D_OUT_POCKET_AMT = . & PBP_D_COMB_MAX_ENR_AMT = . THEN DO;
    IF PBP_D_MAXENR_OOPC_M_CATS_YN = '1' | TYPE = 'MSA' THEN DO I = 1 TO 48;
      CATEGORY = PUT(I,OPMMAX.);
      OUTPUT;
      IF CATEGORY = '15' THEN DO;
        CATEGORY = '15m';
        OUTPUT;
        CATEGORY = '15c';
        OUTPUT;
      END;
      ELSE IF CATEGORY = '8a' THEN DO;
        CATEGORY = '8a1';
        OUTPUT;
        CATEGORY = '8a2';
        OUTPUT;
      END;
      ELSE IF CATEGORY = '8b' THEN DO;
        CATEGORY = '8b1';
        OUTPUT;
        CATEGORY = '8b2';
        OUTPUT;
        CATEGORY = '8b3';
        OUTPUT;
      END;
    END;
    ELSE DO I=1 TO LENGTH(PBP_D_MAXENR_OOPC_M_CATS_S);
      SEMISPOT=INDEX(PBP_D_MAXENR_OOPC_M_CATS_S,';');
      IF SEMISPOT>0 THEN DO;
        CATEGORY=SUBSTR(PBP_D_MAXENR_OOPC_M_CATS_S,1,SEMISPOT-1);
        OUTPUT;
        IF CATEGORY = '15' THEN DO;
          CATEGORY = '15m';
      	  OUTPUT;
       	  CATEGORY = '15c';
       	  OUTPUT;
       	END;
       	ELSE IF CATEGORY = '8a' THEN DO;
       	  CATEGORY = '8a1';
       	  OUTPUT;
       	  CATEGORY = '8a2';
       	  OUTPUT;
       	END;
       	ELSE IF CATEGORY = '8b' THEN DO;
       	  CATEGORY = '8b1';
       	  OUTPUT;
       	  CATEGORY = '8b2';
       	  OUTPUT;
       	  CATEGORY = '8b3';
       	  OUTPUT;
        END;
        ELSE IF CATEGORY='3-1' THEN DO;
          CATEGORY='3c';
          OUTPUT;
        END;
        ELSE IF CATEGORY='3-3' THEN DO;
          CATEGORY='3p';
          OUTPUT;
        END;
        ELSE IF CATEGORY='3-4' THEN DO;
          CATEGORY='3s';
          OUTPUT;
        END;        
        PBP_D_MAXENR_OOPC_M_CATS_S=SUBSTR(PBP_D_MAXENR_OOPC_M_CATS_S,SEMISPOT+1);
      END;
    END;
  END;
  KEEP HPLAN TYPE CATEGORY;
RUN;

DATA MAX_CATS_NM;
  SET  PBP_FILE(KEEP = HPLAN
                       PBP_A_PLAN_TYPE
                       PBP_A_NETWORK_FLAG
                       PBP_D_OUT_POCKET_AMT_YN
                       PBP_D_OUT_POCKET_AMT
                       PBP_D_INN_MAX_ENR_M_YN
                       PBP_D_INN_MAX_ENR_NM_YN
                       PBP_D_INN_MAX_ENR_M_CAT_EX
                       PBP_D_INN_MAX_ENR_NM_CAT_EX

                       PBP_D_COMB_MAX_ENR_AMT
                       PBP_D_COMB_MAX_ENR_INN_M_YN
                       PBP_D_COMB_MAX_ENR_INN_NM_YN
                       PBP_D_COMB_MAX_ENR_INN_MCAT_EX
                       PBP_D_COMB_MAX_ENR_INN_NMCATEX

                       PBP_D_MAXENR_OOPC_AMT
                       PBP_D_MAXENR_OOPC_M_CATS_YN
                       PBP_D_MAXENR_OOPC_NM_CATS_YN
                       PBP_D_MAXENR_OOPC_M_CATS
                       PBP_D_MAXENR_OOPC_NM_CATS);

  LENGTH CATEGORY $4 TYPE $4 PBP_D_INN_MAX_ENR_NM_CAT_EX_S PBP_D_COMB_MAX_ENR_INN_NMCATEX_S $1024;
  LENGTH PBP_D_MAXENR_OOPC_NM_CATS_S $1024;
  TYPE=PUT(HPLAN,$TYPEF.);
  PBP_D_INN_MAX_ENR_NM_CAT_EX_S=PBP_D_INN_MAX_ENR_NM_CAT_EX;
  PBP_D_COMB_MAX_ENR_INN_NMCATEX_S=PBP_D_COMB_MAX_ENR_INN_NMCATEX;
  PBP_D_MAXENR_OOPC_NM_CATS_S=PBP_D_MAXENR_OOPC_NM_CATS;

  ** USE INN MAX IF AVAILABLE, COMBINED IF NOT AND THEN FOR RPPOS, USE THE MAXENR AMT;

  IF PBP_D_OUT_POCKET_AMT NE . | PBP_D_COMB_MAX_ENR_AMT NE . | PBP_D_MAXENR_OOPC_AMT  NE . THEN
    OUT_POCKET_MAX_YN='1';
  ELSE OUT_POCKET_MAX_YN='2';
   

  IF PBP_D_OUT_POCKET_AMT NE . THEN DO;
    IF PBP_D_INN_MAX_ENR_NM_YN = '1' | TYPE = 'MSA' THEN DO I = 1 TO 58;
      CATEGORY = PUT(I,INNMMAX.);
      OUTPUT;
      IF CATEGORY = '15' THEN DO;
        CATEGORY = '15m';
        OUTPUT;
        CATEGORY = '15c';
        OUTPUT;
      END;
    END;
    ELSE DO I=1 TO LENGTH(PBP_D_INN_MAX_ENR_NM_CAT_EX_S);
      SEMISPOT=INDEX(PBP_D_INN_MAX_ENR_NM_CAT_EX_S,';');
      IF SEMISPOT>0 THEN DO;
        CATEGORY=SUBSTR(PBP_D_INN_MAX_ENR_NM_CAT_EX_S,1,SEMISPOT-1);
        OUTPUT;
        IF CATEGORY = '15' THEN DO;
          CATEGORY = '15m';
      	  OUTPUT;
       	  CATEGORY = '15c';
       	  OUTPUT;
       	END;
        ELSE IF CATEGORY='3-1' THEN DO;
          CATEGORY='3c';
          OUTPUT;
        END;
        ELSE IF CATEGORY='3-3' THEN DO;
          CATEGORY='3p';
          OUTPUT;
        END;
        ELSE IF CATEGORY='3-4' THEN DO;
          CATEGORY='3s';
          OUTPUT;
        END;        
        PBP_D_INN_MAX_ENR_NM_CAT_EX_S=SUBSTR(PBP_D_INN_MAX_ENR_NM_CAT_EX_S,SEMISPOT+1);
      END;
    END;
  END;
  ELSE IF PBP_D_OUT_POCKET_AMT =. & PBP_D_COMB_MAX_ENR_AMT NE . THEN DO;
    IF PBP_D_COMB_MAX_ENR_INN_NM_YN = '1' | TYPE = 'MSA' THEN DO I = 1 TO 52;
      CATEGORY = PUT(I,COMNMMAX.);
      OUTPUT;
      IF CATEGORY = '15' THEN DO;
        CATEGORY = '15m';
        OUTPUT;
        CATEGORY = '15c';
        OUTPUT;
      END;
    END;
    ELSE DO I=1 TO LENGTH(PBP_D_COMB_MAX_ENR_INN_NMCATEX_S);
      SEMISPOT=INDEX(PBP_D_COMB_MAX_ENR_INN_NMCATEX_S,';');
      IF SEMISPOT>0 THEN DO;
        CATEGORY=SUBSTR(PBP_D_COMB_MAX_ENR_INN_NMCATEX_S,1,SEMISPOT-1);
        OUTPUT;
        IF CATEGORY = '15' THEN DO;
          CATEGORY = '15m';
       	  OUTPUT;
       	  CATEGORY = '15c';
       	  OUTPUT;
       	END;
        ELSE IF CATEGORY='3-1' THEN DO;
          CATEGORY='3c';
          OUTPUT;
        END;
        ELSE IF CATEGORY='3-3' THEN DO;
          CATEGORY='3p';
          OUTPUT;
        END;
        ELSE IF CATEGORY='3-4' THEN DO;
          CATEGORY='3s';
          OUTPUT;
        END;        
        PBP_D_COMB_MAX_ENR_INN_NMCATEX_S=SUBSTR(PBP_D_COMB_MAX_ENR_INN_NMCATEX_S,SEMISPOT+1);
      END;
    END;
  END;
  ELSE IF PBP_D_OUT_POCKET_AMT = . & PBP_D_COMB_MAX_ENR_AMT = . THEN DO;
    IF PBP_D_MAXENR_OOPC_NM_CATS_YN = '1' | TYPE = 'MSA' THEN DO I = 1 TO 52;
      CATEGORY = PUT(I,OPNMMAX.);
      OUTPUT;
      IF CATEGORY = '15' THEN DO;
        CATEGORY = '15m';
        OUTPUT;
        CATEGORY = '15c';
        OUTPUT;
      END;
    END;
    ELSE DO I=1 TO LENGTH(PBP_D_MAXENR_OOPC_NM_CATS_S);
      SEMISPOT=INDEX(PBP_D_MAXENR_OOPC_NM_CATS_S,';');
      IF SEMISPOT>0 THEN DO;
        CATEGORY=SUBSTR(PBP_D_MAXENR_OOPC_NM_CATS_S,1,SEMISPOT-1);
        OUTPUT;
        IF CATEGORY = '15' THEN DO;
          CATEGORY = '15m';
       	  OUTPUT;
       	  CATEGORY = '15c';
       	  OUTPUT;
      	END;
        ELSE IF CATEGORY='3-1' THEN DO;
          CATEGORY='3c';
          OUTPUT;
        END;
        ELSE IF CATEGORY='3-3' THEN DO;
          CATEGORY='3p';
          OUTPUT;
        END;
        ELSE IF CATEGORY='3-4' THEN DO;
          CATEGORY='3s';
          OUTPUT;
        END;        
        PBP_D_MAXENR_OOPC_NM_CATS_S=SUBSTR(PBP_D_MAXENR_OOPC_NM_CATS_S,SEMISPOT+1);
      END;
    END;
  END;
  KEEP HPLAN TYPE CATEGORY;
RUN;

PROC SORT DATA = MAX_CATS_M OUT=MAX_CATS_M;
  BY HPLAN TYPE CATEGORY;
RUN;

PROC SORT DATA = MAX_CATS_NM OUT=MAX_CATS_NM;
  BY HPLAN TYPE CATEGORY;
RUN;

DATA MAX_CATS;
  MERGE MAX_CATS_M (IN=A)
        MAX_CATS_NM (IN=B);
  BY HPLAN TYPE CATEGORY;
  IF A | B;
  LENGTH MEDICARE_FLG NONMEDICARE_FLG $1;
  IF A THEN MEDICARE_FLG = '1';
  IF B THEN NONMEDICARE_FLG = '1';
RUN;

*******;
*** MERGE ON THE FILE THAT INDICATES WHETHER A PLAN HAD A MAXIMUM OOP EXPENSE;
*** IN A PARTICULAR CATEGORY;
*******;

DATA PBPCATS_MERGE;
  MERGE PBPCATS_MCCOST(IN = A)
        MAX_CATS(IN = B);
  BY HPLAN CATEGORY;
  IF A & B THEN MAXGRP = '1';
  ELSE MAXGRP = '0';
  IF A;
RUN;

PROC SORT DATA = PBPCATS_MERGE;
  BY BASEID HPLAN CATEGORY;
RUN;

PROC SUMMARY DATA = PBPCATS_MERGE NWAY MISSING;
  WHERE MEDICARE_FLG='1' & MAXGRP = '1' & TYPE ^= 'MSA';
  CLASS HPLAN BASEID;
  VAR COST_SHARE_COST_MC;
  OUTPUT OUT = PBPCATS_SUMMARY_M (DROP = _FREQ_ _TYPE_) SUM=;
RUN;

PROC SUMMARY DATA = PBPCATS_MERGE NWAY MISSING;
  WHERE NONMEDICARE_FLG='1' & MAXGRP = '1' & TYPE ^= 'MSA';
  CLASS HPLAN BASEID;
  VAR COST_SHARE_COST_AMO;
  OUTPUT OUT = PBPCATS_SUMMARY_NM (DROP = _FREQ_ _TYPE_) SUM=;
RUN;

PROC SUMMARY DATA = PBPCATS_MERGE NWAY MISSING;
  WHERE TYPE='MSA' & MAXGRP = '1' ;
  CLASS HPLAN BASEID ;
  VAR COST_SHARE_COST_MC COST_SHARE_COST_AMO OTHER_COST;
  OUTPUT OUT = PBPCATS_SUMMARY_MSA (DROP = _FREQ_ _TYPE_) SUM=;
RUN;

DATA PBPCATS_SUMMARY_M_NM;
  MERGE PBPCATS_SUMMARY_M (IN=A)
        PBPCATS_SUMMARY_NM (IN=B);
  BY HPLAN BASEID;
  IF A | B;
RUN;

DATA PBPCATS_SUMMARY;
  SET PBPCATS_SUMMARY_M_NM
      PBPCATS_SUMMARY_MSA;
  BY HPLAN BASEID;
RUN;


*******;
*** GET THE OUT OF POCKET MAXIMUM FROM THE PBP DATA;
*** NO LONGER A PERIODICITY FOR OUT OF POCKET MAX;
*******;

DATA PBP_OOPCMAX;
  SET  PBP_FILE(KEEP=HPLAN
                     PBP_A_PLAN_TYPE
                     PBP_A_NETWORK_FLAG
                     PBP_D_OUT_POCKET_AMT_YN
                     PBP_D_OUT_POCKET_AMT
                     PBP_D_MAXENR_OOPC_AMT
                     PBP_D_COMB_MAX_ENR_AMT
                     PBP_D_INN_MAX_ENR_M_YN  
                     PBP_D_MSA_DED_AMT 
                     PBP_D_MSA_ANNUAL_AMT
                     PBP_D_INN_MAX_ENR_OOPC_BENS
                     PBP_D_COMB_MAX_ENR_OOPC_BENS
                     PBP_D_MAXENR_OOPC_BENS);

  ** USE INN MAX IF AVAILABLE, COMBINED IF NOT AND THEN FOR RPPOS, USE THE MAXENR AMT;
  LENGTH PBP_D_OUT_POCKET_TYPE MFLAG NMFLAG $1;

  IF PBP_D_OUT_POCKET_AMT NE . | PBP_D_COMB_MAX_ENR_AMT NE . | PBP_D_MAXENR_OOPC_AMT  NE . THEN
    OUT_POCKET_MAX_YN='1';
  ELSE OUT_POCKET_MAX_YN='2';

  IF PBP_D_OUT_POCKET_AMT NE . THEN DO;
    OUT_POCKET_AMT = PBP_D_OUT_POCKET_AMT;
    SELECT(PBP_D_INN_MAX_ENR_OOPC_BENS);
      WHEN ('01') PBP_D_OUT_POCKET_TYPE='1';
      WHEN ('10') PBP_D_OUT_POCKET_TYPE='2';
      WHEN ('11') PBP_D_OUT_POCKET_TYPE='3';
      OTHERWISE;
    END;
  END;

  ELSE IF PBP_D_OUT_POCKET_AMT=. & PBP_D_COMB_MAX_ENR_AMT NE . THEN DO;
    OUT_POCKET_AMT =PBP_D_COMB_MAX_ENR_AMT;
    IF SUBSTR(PBP_D_COMB_MAX_ENR_OOPC_BENS,2,1)='1' THEN MFLAG='1';
    IF SUBSTR(PBP_D_COMB_MAX_ENR_OOPC_BENS,3,1)='1' THEN NMFLAG='1'; 
    IF MFLAG='1' & NMFLAG='1' THEN PBP_D_OUT_POCKET_TYPE='3';
    ELSE IF MFLAG='1' & NMFLAG=' ' THEN PBP_D_OUT_POCKET_TYPE='1';
    ELSE IF MFLAG=' ' & NMFLAG='1' THEN PBP_D_OUT_POCKET_TYPE='2';
  END;

  ELSE IF PBP_D_OUT_POCKET_AMT=. & PBP_D_COMB_MAX_ENR_AMT=. THEN DO;
    OUT_POCKET_AMT =PBP_D_MAXENR_OOPC_AMT;
    SELECT(PBP_D_MAXENR_OOPC_BENS);
      WHEN ('01') PBP_D_OUT_POCKET_TYPE='1';
      WHEN ('10') PBP_D_OUT_POCKET_TYPE='2';
      WHEN ('11') PBP_D_OUT_POCKET_TYPE='3';
      OTHERWISE;
    END;
  END;

  IF OUT_POCKET_AMT >= 0 | PUT(HPLAN,$TYPEF.)='MSA';
  
  KEEP HPLAN OUT_POCKET_AMT PBP_D_MSA_DED_AMT PBP_D_MSA_ANNUAL_AMT PBP_D_OUT_POCKET_TYPE;
  
RUN;

PROC SORT DATA = PBP_OOPCMAX;
  BY HPLAN;
RUN;

******;
*** CAP THE COST_SHARE_COST AMOUNT AND COMPUTE REDUCTION FACTORS (BASEID/PLAN);
******;

DATA PBPCATS_PBP_&YEAR;
  MERGE PBPCATS_SUMMARY(IN = A) 
        PBP_OOPCMAX(IN = B);
  BY HPLAN;
  IF A & B;
  
  COST_SHARE_COST = SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO);
  
  IF PUT(HPLAN,$TYPEF.) ^= 'MSA' THEN DO;
    IF COST_SHARE_COST <= OUT_POCKET_AMT THEN COST_SHARE_COST_REDUCTION = 1;
    ELSE IF COST_SHARE_COST > 0 THEN COST_SHARE_COST_REDUCTION = MIN(COST_SHARE_COST, OUT_POCKET_AMT) / COST_SHARE_COST;
    ELSE COST_SHARE_COST_REDUCTION = 0;

    COST_SHARE_COST_REDUCTION_MC = 1;
    COST_SHARE_COST_REDUCTION_AMO = 1;

    ***SET OUT_POCKET_AMT TO OUT_POCKET_MC_AMT ***;
    ***OUT_POCKET_AMT INN and/or COMBINED MUST INCLUDE ALL MC SERVICES ***;

    IF PBP_D_OUT_POCKET_TYPE = '1' THEN DO;
      IF COST_SHARE_COST_MC <= OUT_POCKET_AMT THEN COST_SHARE_COST_REDUCTION_MC = 1;
      ELSE IF COST_SHARE_COST_MC > 0 THEN
        COST_SHARE_COST_REDUCTION_MC = MIN(COST_SHARE_COST_MC,OUT_POCKET_AMT) / COST_SHARE_COST_MC;
      ELSE COST_SHARE_COST_REDUCTION_MC = 0;
    END;
    ELSE IF PBP_D_OUT_POCKET_TYPE = '2' THEN DO;
      IF COST_SHARE_COST_AMO <= OUT_POCKET_AMT THEN COST_SHARE_COST_REDUCTION_AMO = 1;
      ELSE IF COST_SHARE_COST_AMO > 0 THEN
        COST_SHARE_COST_REDUCTION_AMO = MIN(COST_SHARE_COST_AMO,OUT_POCKET_AMT) / COST_SHARE_COST_AMO;
      ELSE COST_SHARE_COST_REDUCTION_AMO = 0;
    END;
    ELSE IF PBP_D_OUT_POCKET_TYPE = '3' THEN DO;

      COST_SHARE_COST_SUM = SUM(COST_SHARE_COST_MC, COST_SHARE_COST_AMO);

      * NEITHER CAP BINDING;
      IF COST_SHARE_COST_SUM <= OUT_POCKET_AMT THEN DO;
        COST_SHARE_COST_REDUCTION_MC = 1;
        COST_SHARE_COST_REDUCTION_AMO = 1;
      END;
      ELSE IF COST_SHARE_COST_SUM > OUT_POCKET_AMT THEN DO;
        IF COST_SHARE_COST_MC > 0 THEN
          COST_SHARE_COST_REDUCTION_MC = OUT_POCKET_AMT/COST_SHARE_COST_SUM;
        ELSE COST_SHARE_COST_REDUCTION_MC = 0;
        
        IF COST_SHARE_COST_AMO > 0 THEN
          COST_SHARE_COST_REDUCTION_AMO = OUT_POCKET_AMT/COST_SHARE_COST_SUM;
        ELSE COST_SHARE_COST_REDUCTION_AMO = 0;
      END;
    END;
  END;
  ELSE IF PUT(HPLAN,$TYPEF.) = 'MSA' THEN DO;
    IF SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO) < PBP_D_MSA_ANNUAL_AMT THEN DO;
      COST_SHARE_COST_REDUCTION_MC = 0;
      COST_SHARE_COST_REDUCTION_AMO = 0;
      MSA_BALANCE=SUM(PBP_D_MSA_ANNUAL_AMT,-COST_SHARE_COST_MC,-COST_SHARE_COST_AMO);
    END;
    ELSE IF SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO) >= PBP_D_MSA_ANNUAL_AMT THEN DO;
      COST_SHARE_COST_REDUCTION_MC = 1 - (PBP_D_MSA_ANNUAL_AMT/SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO));
      COST_SHARE_COST_REDUCTION_AMO = 1 - (PBP_D_MSA_ANNUAL_AMT/SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO));
    END;
  END; 

RUN;

PROC SORT DATA = PBPCATS_PBP_&YEAR
               (KEEP = HPLAN BASEID COST_SHARE_COST_REDUCTION
                       COST_SHARE_COST_REDUCTION_MC
                       COST_SHARE_COST_REDUCTION_AMO
                       MSA_BALANCE)
          OUT = PBPCATS_PBP_MAX;
  BY BASEID HPLAN;
RUN;

******;
*** MERGE COST SHARE REDUCTION FACTORS (BASEID/PLAN) ONTO CATEGORY FILE (BASEID/PLAN/CATEGORY);
******;

DATA PBPCATS;
  MERGE PBPCATS_MERGE(IN = A)
        PBPCATS_PBP_MAX(IN = B);
  BY BASEID HPLAN;
  IF A & B & MAXGRP = '1' THEN DO;
    IF PUT(HPLAN,$TYPEF.) ^= 'MSA' THEN DO;
      IF MEDICARE_FLG='1' THEN COST_SHARE_COST_MC = COST_SHARE_COST_MC * COST_SHARE_COST_REDUCTION_MC;
      IF NONMEDICARE_FLG='1' THEN COST_SHARE_COST_AMO = COST_SHARE_COST_AMO * COST_SHARE_COST_REDUCTION_AMO;
      COST_SHARE_COST=SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO);
    END;
    ELSE IF PUT(HPLAN,$TYPEF.) = 'MSA' THEN DO;
      IF MEDICARE_FLG='1' THEN COST_SHARE_COST_MC  = COST_SHARE_COST_MC * COST_SHARE_COST_REDUCTION_MC;
      IF NONMEDICARE_FLG='1' THEN COST_SHARE_COST_AMO = COST_SHARE_COST_AMO * COST_SHARE_COST_REDUCTION_AMO;
      COST_SHARE_COST=SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO);
    END;
  END;

  COST = SUM(COST_SHARE_COST_MC, COST_SHARE_COST_AMO, OTHER_COST);
  COST_CHECK = SUM(COST_SHARE_COST, OTHER_COST);
  IF CATEGORY = '' THEN DELETE;
 
  KEEP BASEID HPLAN COST CATEGORY COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO OTHER_COST COST_CHECK MSA_BALANCE AMTTOT;
  
RUN;

*** MONTHLY COST FOR PEOPLE WITH UTILIZATION BY CATEGORY;

DATA BASEID_PLAN_CATEGORY;
  MERGE PBPCATS(IN = A)

        &INP(IN = B KEEP = BASEID INDMON CSYRWGT YEAR WHERE=(YEAR="&YEAR"));

  BY BASEID;
  IF A;

  MONTHLY_COST = COST / INDMON;
  MONTHLY_COST_CHECK = COST_CHECK / INDMON;
  MONTHLY_COST_MC    = COST_SHARE_COST_MC / INDMON;
  MONTHLY_COST_AMO   = COST_SHARE_COST_AMO / INDMON;
  MONTHLY_OTHER_COST = OTHER_COST / INDMON;

  RENAME CSYRWGT = CWGT;

RUN;

* CREATE ALL CATEGORY SUMMING UP MONTHLY COST ACROSS CATEGORIES;
* FOR A PERSON PLAN;

DATA BASEID_PLAN_CATEGORY_ALL;
  SET BASEID_PLAN_CATEGORY;
  BY BASEID HPLAN;

  RETAIN TOT_COSTS TOT_COSTS_CHECK TOT_COSTS_MC TOT_COSTS_AMO TOT_COSTS_OTHER;

  OUTPUT;

  IF FIRST.HPLAN THEN DO;
    TOT_COSTS = 0;
    TOT_COSTS_MC = 0;
    TOT_COSTS_AMO = 0;
    TOT_COSTS_OTHER = 0;
  END;
  IF FIRST.HPLAN THEN TOT_COSTS_CHECK = 0;

  TOT_COSTS + MONTHLY_COST;
  TOT_COSTS_MC + MONTHLY_COST_MC;
  TOT_COSTS_AMO + MONTHLY_COST_AMO;
  TOT_COSTS_OTHER + MONTHLY_OTHER_COST;
  TOT_COSTS_CHECK + MONTHLY_COST_CHECK;

  IF LAST.HPLAN THEN DO;
    CATEGORY = 'ALL';
    MONTHLY_COST = TOT_COSTS;
    MONTHLY_COST_MC = TOT_COSTS_MC;
    MONTHLY_COST_AMO = TOT_COSTS_AMO;
    MONTHLY_OTHER_COST = TOT_COSTS_OTHER;
    MONTHLY_COST_CHECK = TOT_COSTS_CHECK;
    OUTPUT;
  END;

  DROP TOT_COSTS TOT_COSTS_CHECK TOT_COSTS_MC TOT_COSTS_AMO TOT_COSTS_OTHER;
RUN;

PROC SORT DATA = BASEID_PLAN_CATEGORY_ALL;
  BY HPLAN CATEGORY;
RUN;

* ADD THE MISSING MEMBERS OF THE COHORT WITH NO UTILIZATION;
* FOR EACH PLAN/CATEGORY ADD A ROW FOR THE PEOPLE WITH NO UTILIZATION;
* FOR EACH PLAN WRITE OUT AN ALL CATEGORY ROW FOR EACH MISSING PERSON;

%obsnvars(MISSING_CELLS_&YEAR.);

DATA BASEID_PLAN_CATEGORY_COMPLETE;

  %IF "&NOBS." > "0" %THEN %DO;
    IF _N_ = 1 THEN SET  MISSING_CELLS_&YEAR;
  %END;
  SET BASEID_PLAN_CATEGORY_ALL;
  BY HPLAN CATEGORY;
  OUTPUT;

  IF LAST.HPLAN THEN DO;
    CATEGORY = 'ALL';
    BASEID = 'MISS';
    CWGT = CSYRWGT;
    COST = 0;
    MONTHLY_COST = 0;
    MONTHLY_COST_MC = 0;
    MONTHLY_COST_AMO = 0;
    MONTHLY_OTHER_COST = 0;
    OUTPUT;
  END;

  KEEP BASEID HPLAN CATEGORY CWGT COST MONTHLY_COST
       MONTHLY_COST_MC MONTHLY_COST_AMO MONTHLY_OTHER_COST YEAR MSA_BALANCE INDMON AMTTOT;
RUN;

DATA BASEID_PLAN_CATEGORY_COMPLETE;
  SET BASEID_PLAN_CATEGORY_COMPLETE;
  IF CATEGORY IN('10a1','10a2') THEN CATEGORY='10a';
  ELSE IF CATEGORY IN('9a1','9a2') THEN CATEGORY='9a';
RUN;

PROC SUMMARY DATA=BASEID_PLAN_CATEGORY_COMPLETE NWAY MISSING;
  CLASS HPLAN CATEGORY YEAR BASEID CWGT INDMON;
  VAR MONTHLY_COST MONTHLY_COST_MC MONTHLY_COST_AMO MONTHLY_OTHER_COST MSA_BALANCE AMTTOT;
  OUTPUT OUT=BASEID_PLAN_CATEGORY_COMP_&YEAR (DROP=_TYPE_ _FREQ_) SUM=;
RUN;



%MEND;
RUN;


%BASEID_PLAN(&YEAR1);
RUN;
%BASEID_PLAN(&YEAR2);
RUN;