* PROGRAM:  PBP_DRUG_VARIABLES_SSM.SAS;
* DESCRIPTION: PREPARE THE DRUG VARIABLES FOR SENIOR SAVINGS;

LIBNAME FORM "&FORMULARY";

LIBNAME LIBRARY "&INPUTDIR";


DATA PBP_SSM_TIERS (DROP=I J Z);
  SET PBP_MRX_SSM;

  LENGTH ANYFLAG MRX_TIER_ID $1;
  ARRAY XCOHORT(5)      $1 COHORT1_FLAG COHORT2_FLAG COHORT3_FLAG COHORT4_FLAG COHORT5_FLAG;
  ARRAY XCOHORT_COPAY(5)   COHORT_1_COPAY COHORT_2_COPAY COHORT_3_COPAY COHORT_4_COPAY COHORT_5_COPAY;

  ARRAY XSRCS_COPAY(5)     MRX_SSM_SRCS_COPAY_1M_1_NUM MRX_SSM_SRCS_COPAY_1M_2_NUM MRX_SSM_SRCS_COPAY_1M_3_NUM
                           MRX_SSM_SRCS_COPAY_1M_4_NUM MRX_SSM_SRCS_COPAY_1M_5_NUM;
                       
  ARRAY XPRCS_COPAY(5)     MRX_SSM_PRCS_COPAY_1M_1_NUM MRX_SSM_PRCS_COPAY_1M_2_NUM MRX_SSM_PRCS_COPAY_1M_3_NUM
                           MRX_SSM_PRCS_COPAY_1M_4_NUM MRX_SSM_PRCS_COPAY_1M_5_NUM;
                       
  ARRAY XMRXSSM(5) $7      MRX_SSM_CUI_TIERS_1_CHK MRX_SSM_CUI_TIERS_2_CHK MRX_SSM_CUI_TIERS_3_CHK
                           MRX_SSM_CUI_TIERS_4_CHK MRX_SSM_CUI_TIERS_5_CHK;
  DO I=1 TO 5;
    XCOHORT(I)='0';
  END;

  DO I=1 TO 7;
    ANYFLAG='0';
    DO J=1 TO MRX_SSM_COHORTS_CNT_RDO;
      IF SUBSTR(XMRXSSM(J),I,1)='1' THEN DO;
        ANYFLAG='1';
        XCOHORT(J)='1';
        IF I=1 THEN MRX_TIER_ID='7';
        ELSE MRX_TIER_ID=PUT(I-1,1.);
        IF XSRCS_COPAY(J)^=. THEN XCOHORT_COPAY(J)=XSRCS_COPAY(J);
        ELSE XCOHORT_COPAY(J)= XPRCS_COPAY(J);
      END;
    END;
    DO Z=1 TO 5;
      IF SUBSTR(XMRXSSM(Z),I,1)='0' THEN DO;
        XCOHORT(Z)='0';
        XCOHORT_COPAY(Z)=.;
      END;
    END;
    IF ANYFLAG='1' THEN OUTPUT;
  END;
RUN;

PROC SORT DATA=PBP_SSM_TIERS;
  BY HPLAN MRX_TIER_ID;
RUN;
