* PROGRAM NAME: JSON_IMPORT_PBPB16.SAS;
* DESCRIPTION: IMPORT JSON TABLES;

%MACRO PBPB16();
PROC SQL;
CREATE TABLE PBPB16_JSON AS
SELECT
	segment_0.qid,
	PBP_B16A_BENDESC_AMO_OE_0 AS PBP_B16A_BENDESC_AMO_OE,
	PBP_B16A_BENDESC_AMO_PC_1 AS PBP_B16A_BENDESC_AMO_PC,
	PBP_B16A_BENDESC_AMO_DX_2 AS PBP_B16A_BENDESC_AMO_DX,
	PBP_B16B_BENDESC_AMO_RS_3 AS PBP_B16B_BENDESC_AMO_RS,
	PBP_B16B_BENDESC_AMO_END_4 AS PBP_B16B_BENDESC_AMO_END,
	PBP_B16B_BENDESC_AMO_PERI_5 AS PBP_B16B_BENDESC_AMO_PERI,
	PBP_B16B_BENDESC_AMO_EXT_6 AS PBP_B16B_BENDESC_AMO_EXT,
	PBP_B16B_BENDESC_AMO_POO_7 AS PBP_B16B_BENDESC_AMO_POO,
	
	CASE WHEN PBP_B16B_COINS_EHC_76 IN ('1','3') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16B_COINS_EHC_8 IN ('1','3') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16B_COINS_EHC_40 IN ('1','3') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16B_COINS_EHC_45 IN ('1','3') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16B_COINS_EHC_52 IN ('1','3') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16B_COINS_EHC_56 IN ('1','3') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16B_COINS_EHC_60 IN ('1','3') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16B_COINS_EHC_65 IN ('1','3') THEN '1' ELSE '0' END AS PBP_B16B_COINS_EHC,
	
	PBP_B16B_MAXENR_TYPE_9 AS PBP_B16B_MAXENR_TYPE,
	COALESCE(PBP_B16B_COPAY_AMT_MC_MIN_10, PBP_B16B_COPAY_AMT_MC_MIN_93) AS PBP_B16B_COPAY_AMT_MC_MIN,
	COALESCE(PBP_B16B_COINS_PCT_MC_MIN_11, PBP_B16B_COINS_PCT_MC_MIN_84) AS PBP_B16B_COINS_PCT_MC_MIN,
	PBP_B16B_MAXENR_PER_12 AS PBP_B16B_MAXENR_PER,
	PBP_B16B_MAXENR_AMT_13 AS PBP_B16B_MAXENR_AMT,

	CASE WHEN PBP_B16B_COPAY_EHC_75 IN ('1','3') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16B_COPAY_EHC_14 IN ('1','3') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16B_COPAY_EHC_44 IN ('1','3') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16B_COPAY_EHC_46 IN ('1','3') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16B_COPAY_EHC_51 IN ('1','3') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16B_COPAY_EHC_58 IN ('1','3') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16B_COPAY_EHC_61 IN ('1','3') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16B_COPAY_EHC_68 IN ('1','3') THEN '1' ELSE '0' END AS PBP_B16B_COPAY_EHC,         

	COALESCE(PBP_B16B_DED_AMT_15, PBP_B16B_DED_AMT_16) AS PBP_B16B_DED_AMT,
	PBP_B16A_MAXENR_AMT_17 AS PBP_B16A_MAXENR_AMT,
	PBP_B16A_MAXPLAN_AMT_18 AS PBP_B16A_MAXPLAN_AMT,
	PBP_B16A_DED_AMT_19 AS PBP_B16A_DED_AMT,
	PBP_B16A_MAXPLAN_PER_20 AS PBP_B16A_MAXPLAN_PER,
	COALESCE(PBP_B16A_COPAY_AMT_OVMAX_21, PBP_B16A_COPAY_AMT_OVMAX_102) AS PBP_B16A_COPAY_AMT_OVMAX,
	PBP_B16A_MAXENR_PER_22 AS PBP_B16A_MAXENR_PER,
	COALESCE(PBP_B16A_COPAY_AMT_OVMIN_23, PBP_B16A_COPAY_AMT_OVMIN_103) AS PBP_B16A_COPAY_AMT_OVMIN,
	COALESCE(PBP_B16A_COINS_PCT_MAXOV_24, PBP_B16A_COINS_PCT_MAXOV_104) AS PBP_B16A_COINS_PCT_MAXOV,
	COALESCE(PBP_B16A_COINS_PCT_MINOV_25, PBP_B16A_COINS_PCT_MINOV_105) AS PBP_B16A_COINS_PCT_MINOV,
	PBP_B16A_BENDESC_NUMV_OE_26 AS PBP_B16A_BENDESC_NUMV_OE,
	PBP_B16A_BENDESC_PER_OE_27 AS PBP_B16A_BENDESC_PER_OE,
	COALESCE(PBP_B16A_COINS_PCT_OE_28, PBP_B16A_COINS_PCT_OE_85) AS PBP_B16A_COINS_PCT_OE,
	COALESCE(PBP_B16A_COPAY_AMT_OEMIN_29, PBP_B16A_COPAY_AMT_OEMIN_94) AS PBP_B16A_COPAY_AMT_OEMIN,

	CASE WHEN PBP_B16A_COPAY_EHC_83 in ('1','3') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16A_COPAY_EHC_79 in ('1','3') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16A_COPAY_EHC_30 in ('1','3') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16A_COPAY_EHC_81 in ('1','3') THEN '1' ELSE '0' END AS PBP_B16A_COPAY_EHC,

	COALESCE(PBP_B16A_COINS_PCT_PC_31, PBP_B16A_COINS_PCT_PC_86) AS PBP_B16A_COINS_PCT_PC,
	COALESCE(PBP_B16A_COPAY_AMT_PCMIN_32, PBP_B16A_COPAY_AMT_PCMIN_95) AS PBP_B16A_COPAY_AMT_PCMIN,
	PBP_B16A_BENDESC_NUMV_PC_33 AS PBP_B16A_BENDESC_NUMV_PC,

	CASE WHEN PBP_B16A_COINS_EHC_82 in ('1','3') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16A_COINS_EHC_78 in ('1','3') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16A_COINS_EHC_34 in ('1','3') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16A_COINS_EHC_80 in ('1','3') THEN '1' ELSE '0' END AS PBP_B16A_COINS_EHC,          

	PBP_B16A_BENDESC_PER_PC_35 AS PBP_B16A_BENDESC_PER_PC,
	COALESCE(PBP_B16A_COPAY_AMT_DXMIN_36, PBP_B16A_COPAY_AMT_DXMIN_96) AS PBP_B16A_COPAY_AMT_DXMIN,
	PBP_B16A_BENDESC_PER_DX_37 AS PBP_B16A_BENDESC_PER_DX,
	PBP_B16A_BENDESC_NUMV_DX_38 AS PBP_B16A_BENDESC_NUMV_DX,
	COALESCE(PBP_B16A_COINS_PCT_DX_39, PBP_B16A_COINS_PCT_DX_87) AS PBP_B16A_COINS_PCT_DX,         

	PBP_B16B_MAXPLAN_AMT_41 AS PBP_B16B_MAXPLAN_AMT,
	PBP_B16B_MAXBENE_TYPE_42 AS PBP_B16B_MAXBENE_TYPE,
	PBP_B16B_MAXPLAN_PER_43 AS PBP_B16B_MAXPLAN_PER,
	
	PBP_B16B_BENDESC_NUMV_RS_47 AS PBP_B16B_BENDESC_NUMV_RS,
	COALESCE(PBP_B16B_COINS_PCT_RS_MIN_48, PBP_B16B_COINS_PCT_RS_MIN_88) AS PBP_B16B_COINS_PCT_RS_MIN,
	COALESCE(PBP_B16B_COPAY_AMT_RS_MIN_49, PBP_B16B_COPAY_AMT_RS_MIN_97) AS PBP_B16B_COPAY_AMT_RS_MIN,
	PBP_B16B_BENDESC_PER_RS_50 AS PBP_B16B_BENDESC_PER_RS,
	
	PBP_B16B_BENDESC_PER_END_53 AS PBP_B16B_BENDESC_PER_END,
	COALESCE(PBP_B16B_COINS_PCT_END_MIN_54, PBP_B16B_COINS_PCT_END_MIN_89) AS PBP_B16B_COINS_PCT_END_MIN,
	PBP_B16B_BENDESC_NUM_END_55 AS PBP_B16B_BENDESC_NUM_END,

	COALESCE(PBP_B16B_COPAY_AMT_END_MIN_57, PBP_B16B_COPAY_AMT_END_MIN_98) AS PBP_B16B_COPAY_AMT_END_MIN,

	PBP_B16B_BENDESC_PER_PERI_59 AS PBP_B16B_BENDESC_PER_PERI,

	COALESCE(PBP_B16B_COINS_PCT_PERI_MIN_62, PBP_B16B_COINS_PCT_PERI_MIN_90) AS PBP_B16B_COINS_PCT_PERI_MIN,
	COALESCE(PBP_B16B_COPAY_AMT_PERI_MIN_63, PBP_B16B_COPAY_AMT_PERI_MIN_99) AS PBP_B16B_COPAY_AMT_PERI_MIN,
	PBP_B16B_BENDESC_NUM_PERI_64 AS PBP_B16B_BENDESC_NUM_PERI,

	PBP_B16B_BENDESC_PER_EXT_66 AS PBP_B16B_BENDESC_PER_EXT,
	COALESCE(PBP_B16B_COPAY_AMT_EXT_MIN_67, PBP_B16B_COPAY_AMT_EXT_MIN_100) AS PBP_B16B_COPAY_AMT_EXT_MIN,

	PBP_B16B_BENDESC_NUM_EXT_69 AS PBP_B16B_BENDESC_NUM_EXT,
	COALESCE(PBP_B16B_COINS_PCT_EXT_MIN_70, PBP_B16B_COINS_PCT_EXT_MIN_91) AS PBP_B16B_COINS_PCT_EXT_MIN,
	PBP_B16B_BENDESC_NUMV_POO_71 AS PBP_B16B_BENDESC_NUMV_POO,
	COALESCE(PBP_B16B_COPAY_AMT_POO_MIN_72, PBP_B16B_COPAY_AMT_POO_MIN_101) AS PBP_B16B_COPAY_AMT_POO_MIN,
	COALESCE(PBP_B16B_COINS_PCT_POO_MIN_73, PBP_B16B_COINS_PCT_POO_MIN_92) AS PBP_B16B_COINS_PCT_POO_MIN,
	PBP_B16B_BENDESC_PER_POO_74 AS PBP_B16B_BENDESC_PER_POO,

	CASE WHEN PBP_B16A_COINS_CSERV_SC_106 IN ('1') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16A_COINS_CSERV_SC_107 IN ('1') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16A_COINS_CSERV_SC_108 IN ('1') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16A_COINS_CSERV_SC_109 IN ('1') THEN '1' ELSE '0' END AS PBP_B16A_COINS_CSERV_SC_POV,

	CASE WHEN PBP_B16A_COPAY_CSERV_SC_110 IN ('1') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16A_COPAY_CSERV_SC_111 IN ('1') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16A_COPAY_CSERV_SC_112 IN ('1') THEN '1' ELSE '0' END ||
		CASE WHEN PBP_B16A_COPAY_CSERV_SC_113 IN ('1') THEN '1' ELSE '0' END AS PBP_B16A_COPAY_CSERV_SC_POV

FROM
	(
	SELECT
		qid,
		MAX(PBP_B16A_BENDESC_AMO_OE_0) AS PBP_B16A_BENDESC_AMO_OE_0,
		MAX(PBP_B16A_BENDESC_AMO_PC_1) AS PBP_B16A_BENDESC_AMO_PC_1,
		MAX(PBP_B16A_BENDESC_AMO_DX_2) AS PBP_B16A_BENDESC_AMO_DX_2,
		MAX(PBP_B16B_BENDESC_AMO_RS_3) AS PBP_B16B_BENDESC_AMO_RS_3,
		MAX(PBP_B16B_BENDESC_AMO_END_4) AS PBP_B16B_BENDESC_AMO_END_4,
		MAX(PBP_B16B_BENDESC_AMO_PERI_5) AS PBP_B16B_BENDESC_AMO_PERI_5
	FROM
		(
		SELECT
			put(cat(contractId,
			planId,
			put(segmentId,
			z3.)),
			$11.) AS qid,
			CASE
				WHEN nonMedicare_nonMedBenOffDet.categoryCode IN('16a1') THEN CATS(nonMedicare_nonMedBenOffDet.inNetworkOptionSelected)
				ELSE ''
			END AS PBP_B16A_BENDESC_AMO_OE_0,
			CASE
				WHEN nonMedicare_nonMedBenOffDet.categoryCode IN('16a2') THEN CATS(nonMedicare_nonMedBenOffDet.inNetworkOptionSelected)
				ELSE ''
			END AS PBP_B16A_BENDESC_AMO_PC_1,
			CASE
				WHEN nonMedicare_nonMedBenOffDet.categoryCode IN('16a4') THEN CATS(nonMedicare_nonMedBenOffDet.inNetworkOptionSelected)
				ELSE ''
			END AS PBP_B16A_BENDESC_AMO_DX_2,
			CASE
				WHEN nonMedicare_nonMedBenOffDet.categoryCode IN('16b3') THEN CATS(nonMedicare_nonMedBenOffDet.inNetworkOptionSelected)
				ELSE ''
			END AS PBP_B16B_BENDESC_AMO_RS_3,
			CASE
				WHEN nonMedicare_nonMedBenOffDet.categoryCode IN('16b4') THEN CATS(nonMedicare_nonMedBenOffDet.inNetworkOptionSelected)
				ELSE ''
			END AS PBP_B16B_BENDESC_AMO_END_4,
			CASE
				WHEN nonMedicare_nonMedBenOffDet.categoryCode IN('16b5') THEN CATS(nonMedicare_nonMedBenOffDet.inNetworkOptionSelected)
				ELSE ''
			END AS PBP_B16B_BENDESC_AMO_PERI_5
		FROM
			jsonlib.root
		LEFT JOIN jsonlib.pbp AS pbp ON
			root.ordinal_root = pbp.ordinal_root
		LEFT JOIN jsonlib.pbp_benefitOfferin AS pbp_benefitOfferin ON
			pbp.ordinal_pbp = pbp_benefitOfferin.ordinal_pbp
		LEFT JOIN jsonlib.benefitOfferin_nonMedicare AS benefitOfferin_nonMedicare ON
			pbp_benefitOfferin.ordinal_benefitOfferin = benefitOfferin_nonMedicare.ordinal_benefitOfferin
		LEFT JOIN jsonlib.nonMedicare_nonMedBenOffDet AS nonMedicare_nonMedBenOffDet ON
			benefitOfferin_nonMedicare.ordinal_nonMedicare = nonMedicare_nonMedBenOffDet.ordinal_nonMedicare ) main
	GROUP BY
		qid) segment_0
LEFT JOIN (
	SELECT
		qid,
		MAX(PBP_B16B_BENDESC_AMO_EXT_6) AS PBP_B16B_BENDESC_AMO_EXT_6,
		MAX(PBP_B16B_BENDESC_AMO_POO_7) AS PBP_B16B_BENDESC_AMO_POO_7,
		MAX(PBP_B16B_COINS_EHC_8) AS PBP_B16B_COINS_EHC_8,
		MAX(PBP_B16B_MAXENR_TYPE_9) AS PBP_B16B_MAXENR_TYPE_9,
		MAX(PBP_B16B_COPAY_AMT_MC_MIN_10) AS PBP_B16B_COPAY_AMT_MC_MIN_10,
		MAX(PBP_B16B_COINS_PCT_MC_MIN_11) AS PBP_B16B_COINS_PCT_MC_MIN_11
	FROM
		(
		SELECT
			put(cat(contractId,
			planId,
			put(segmentId,
			z3.)),
			$11.) AS qid,
			CASE
				WHEN nonMedicare_nonMedBenOffDet.categoryCode IN('16b6') THEN CATS(nonMedicare_nonMedBenOffDet.inNetworkOptionSelected)
				ELSE ''
			END AS PBP_B16B_BENDESC_AMO_EXT_6,
			CASE
				WHEN nonMedicare_nonMedBenOffDet.categoryCode IN('16b7') THEN CATS(nonMedicare_nonMedBenOffDet.inNetworkOptionSelected)
				ELSE ''
			END AS PBP_B16B_BENDESC_AMO_POO_7,
			CASE
				WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b')
					AND benefitDetails_benefDetaiInfo.categoryTypeId = 1 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceAmountYesNoMinMax)
					ELSE ''
				END AS PBP_B16B_COINS_EHC_8,
				CASE
					WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b')
						AND benefitDetails_benefDetaiInfo.categoryTypeId = 1 THEN CATS(benefitDetails_MooCosTypCom.moopCostTypeRadioGroup)
						ELSE ''
					END AS PBP_B16B_MAXENR_TYPE_9,
					CASE
						WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b')
							AND benefitDetails_benefDetaiInfo.categoryTypeId = 1 THEN CATS(benefitDetails_CopayCompo.bdCopaymentMinAmount)
							ELSE ''
						END AS PBP_B16B_COPAY_AMT_MC_MIN_10,
						CASE
							WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b')
								AND benefitDetails_benefDetaiInfo.categoryTypeId = 1 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceMinAmount)
								ELSE ''
							END AS PBP_B16B_COINS_PCT_MC_MIN_11
						FROM
							jsonlib.root
						LEFT JOIN jsonlib.pbp AS pbp ON
							root.ordinal_root = pbp.ordinal_root
						LEFT JOIN jsonlib.pbp_benefitOfferin AS pbp_benefitOfferin ON
							pbp.ordinal_pbp = pbp_benefitOfferin.ordinal_pbp
						LEFT JOIN jsonlib.benefitOfferin_nonMedicare AS benefitOfferin_nonMedicare ON
							pbp_benefitOfferin.ordinal_benefitOfferin = benefitOfferin_nonMedicare.ordinal_benefitOfferin
						LEFT JOIN jsonlib.nonMedicare_nonMedBenOffDet AS nonMedicare_nonMedBenOffDet ON
							benefitOfferin_nonMedicare.ordinal_nonMedicare = nonMedicare_nonMedBenOffDet.ordinal_nonMedicare
						LEFT JOIN jsonlib.pbp_benefitDetails AS pbp_benefitDetails ON
							pbp.ordinal_pbp = pbp_benefitDetails.ordinal_pbp
						LEFT JOIN jsonlib.benefitDetails_benefDetaiInfo AS benefitDetails_benefDetaiInfo ON
							pbp_benefitDetails.ordinal_benefitDetails = benefitDetails_benefDetaiInfo.ordinal_benefitDetails
						LEFT JOIN jsonlib.benefDetaiInfo_benefitDetails AS benefDetaiInfo_benefitDetails ON
							benefitDetails_benefDetaiInfo.ordinal_benefDetaiInfo = benefDetaiInfo_benefitDetails.ordinal_benefDetaiInfo
						LEFT JOIN jsonlib.benefitDetails_CoinsCompo AS benefitDetails_CoinsCompo ON
							benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CoinsCompo.ordinal_benefitDetails
						LEFT JOIN jsonlib.benefitDetails_MooCosTypCom AS benefitDetails_MooCosTypCom ON
							benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_MooCosTypCom.ordinal_benefitDetails
						LEFT JOIN jsonlib.benefitDetails_CopayCompo AS benefitDetails_CopayCompo ON
							benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CopayCompo.ordinal_benefitDetails ) main
	GROUP BY
		qid) segment_1 ON
	segment_0.qid = segment_1.qid
LEFT JOIN (
	SELECT
		qid,
		MAX(PBP_B16B_MAXENR_PER_12) AS PBP_B16B_MAXENR_PER_12,
		MAX(PBP_B16B_MAXENR_AMT_13) AS PBP_B16B_MAXENR_AMT_13,
		MAX(PBP_B16B_COPAY_EHC_14) AS PBP_B16B_COPAY_EHC_14,
		MAX(PBP_B16B_DED_AMT_15) AS PBP_B16B_DED_AMT_15,
		MAX(PBP_B16B_DED_AMT_16) AS PBP_B16B_DED_AMT_16,
		MAX(PBP_B16A_MAXENR_AMT_17) AS PBP_B16A_MAXENR_AMT_17
	FROM
		(
		SELECT
			put(cat(contractId,
			planId,
			put(segmentId,
			z3.)),
			$11.) AS qid,
			CASE
				WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b')
					AND benefitDetails_benefDetaiInfo.categoryTypeId = 1 THEN CATS(benefitDetails_MooCosTypCom.moopCostTypeMoopPeriodicity)
					ELSE ''
				END AS PBP_B16B_MAXENR_PER_12,
				CASE
					WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b')
						AND benefitDetails_benefDetaiInfo.categoryTypeId = 1 THEN CATS(benefitDetails_MooCosTypCom.moopCostTypeMoopAmt)
						ELSE ''
					END AS PBP_B16B_MAXENR_AMT_13,
					CASE
						WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b')
							AND benefitDetails_benefDetaiInfo.categoryTypeId = 1 THEN CATS(benefitDetails_CopayCompo.bdCopaymentAmountYesNoMinMax)
							ELSE ''
						END AS PBP_B16B_COPAY_EHC_14,
						CASE
							WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b')
								AND benefitDetails_benefDetaiInfo.categoryTypeId = 1 THEN CATS(benefitDetails_DedAmoCom.bdMedicareDeductibleAmt)
								ELSE ''
							END AS PBP_B16B_DED_AMT_15,
						CASE
							WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b')
								AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_DedAmoCom.bdMedicareDeductibleAmt)
								ELSE ''
							END AS PBP_B16B_DED_AMT_16,
								CASE
									WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a')
										AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_MooAmoCom.bdMoopAmount)
										ELSE ''
									END AS PBP_B16A_MAXENR_AMT_17
								FROM
									jsonlib.root
								LEFT JOIN jsonlib.pbp AS pbp ON
									root.ordinal_root = pbp.ordinal_root
								LEFT JOIN jsonlib.pbp_benefitDetails AS pbp_benefitDetails ON
									pbp.ordinal_pbp = pbp_benefitDetails.ordinal_pbp
								LEFT JOIN jsonlib.benefitDetails_benefDetaiInfo AS benefitDetails_benefDetaiInfo ON
									pbp_benefitDetails.ordinal_benefitDetails = benefitDetails_benefDetaiInfo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefDetaiInfo_benefitDetails AS benefDetaiInfo_benefitDetails ON
									benefitDetails_benefDetaiInfo.ordinal_benefDetaiInfo = benefDetaiInfo_benefitDetails.ordinal_benefDetaiInfo
								LEFT JOIN jsonlib.benefitDetails_MooCosTypCom AS benefitDetails_MooCosTypCom ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_MooCosTypCom.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_CopayCompo AS benefitDetails_CopayCompo ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CopayCompo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_DedAmoCom AS benefitDetails_DedAmoCom ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_DedAmoCom.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_DenCoiCom AS benefitDetails_DenCoiCom ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_DenCoiCom.ordinal_benefitDetails
								LEFT JOIN jsonlib.DenCoiCom_bdDenCoiSerOpt2 AS DenCoiCom_bdDenCoiSerOpt2 ON
									benefitDetails_DenCoiCom.ordinal_DenCoiCom = DenCoiCom_bdDenCoiSerOpt2.ordinal_DenCoiCom
								LEFT JOIN jsonlib.benefitDetails_MooAmoCom AS benefitDetails_MooAmoCom ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_MooAmoCom.ordinal_benefitDetails ) main
	GROUP BY
		qid) segment_2 ON
	segment_0.qid = segment_2.qid
LEFT JOIN (
	SELECT
		qid,
		MAX(PBP_B16A_MAXPLAN_AMT_18) AS PBP_B16A_MAXPLAN_AMT_18,
		MAX(PBP_B16A_DED_AMT_19) AS PBP_B16A_DED_AMT_19,
		MAX(PBP_B16A_MAXPLAN_PER_20) AS PBP_B16A_MAXPLAN_PER_20,
		MAX(PBP_B16A_COPAY_AMT_OVMAX_21) AS PBP_B16A_COPAY_AMT_OVMAX_21,
		MAX(PBP_B16A_MAXENR_PER_22) AS PBP_B16A_MAXENR_PER_22,
		MAX(PBP_B16A_COPAY_AMT_OVMIN_23) AS PBP_B16A_COPAY_AMT_OVMIN_23
	FROM
		(
		SELECT
			put(cat(contractId,
			planId,
			put(segmentId,
			z3.)),
			$11.) AS qid,
			CASE
				WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a')
					AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_PlaBenCovCom.bdMaximumAmount)
					ELSE ''
				END AS PBP_B16A_MAXPLAN_AMT_18,
				CASE
					WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a')
						AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_DedAmoCom.bdMedicareDeductibleAmt)
						ELSE ''
					END AS PBP_B16A_DED_AMT_19,
					CASE
						WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a')
							AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_PlaBenCovCom.bdCoveragePeriodicity)
							ELSE ''
						END AS PBP_B16A_MAXPLAN_PER_20,
						CASE
							WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a')
								AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_DenCopCom.bdDentalCopaymentMaxAmount)
								ELSE ''
							END AS PBP_B16A_COPAY_AMT_OVMAX_21,
							CASE
								WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a')
									AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_MooAmoCom.bdMoopPeriodicity)
									ELSE ''
								END AS PBP_B16A_MAXENR_PER_22,
								CASE
									WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a')
										AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_DenCopCom.bdDentalCopaymentMinAmount)
										ELSE ''
									END AS PBP_B16A_COPAY_AMT_OVMIN_23
								FROM
									jsonlib.root
								LEFT JOIN jsonlib.pbp AS pbp ON
									root.ordinal_root = pbp.ordinal_root
								LEFT JOIN jsonlib.pbp_benefitDetails AS pbp_benefitDetails ON
									pbp.ordinal_pbp = pbp_benefitDetails.ordinal_pbp
								LEFT JOIN jsonlib.benefitDetails_benefDetaiInfo AS benefitDetails_benefDetaiInfo ON
									pbp_benefitDetails.ordinal_benefitDetails = benefitDetails_benefDetaiInfo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefDetaiInfo_benefitDetails AS benefDetaiInfo_benefitDetails ON
									benefitDetails_benefDetaiInfo.ordinal_benefDetaiInfo = benefDetaiInfo_benefitDetails.ordinal_benefDetaiInfo
								LEFT JOIN jsonlib.benefitDetails_PlaBenCovCom AS benefitDetails_PlaBenCovCom ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_PlaBenCovCom.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_DedAmoCom AS benefitDetails_DedAmoCom ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_DedAmoCom.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_DenCopCom AS benefitDetails_DenCopCom ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_DenCopCom.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_MooAmoCom AS benefitDetails_MooAmoCom ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_MooAmoCom.ordinal_benefitDetails ) main
	GROUP BY
		qid) segment_3 ON
	segment_0.qid = segment_3.qid
LEFT JOIN (
	SELECT
		qid,
		MAX(PBP_B16A_COINS_PCT_MAXOV_24) AS PBP_B16A_COINS_PCT_MAXOV_24,
		MAX(PBP_B16A_COINS_PCT_MINOV_25) AS PBP_B16A_COINS_PCT_MINOV_25,
		MAX(PBP_B16A_BENDESC_NUMV_OE_26) AS PBP_B16A_BENDESC_NUMV_OE_26,
		MAX(PBP_B16A_BENDESC_PER_OE_27) AS PBP_B16A_BENDESC_PER_OE_27,
		MAX(PBP_B16A_COINS_PCT_OE_28) AS PBP_B16A_COINS_PCT_OE_28,
		MAX(PBP_B16A_COPAY_AMT_OEMIN_29) AS PBP_B16A_COPAY_AMT_OEMIN_29
	FROM
		(
		SELECT
			put(cat(contractId,
			planId,
			put(segmentId,
			z3.)),
			$11.) AS qid,
			CASE
				WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a')
					AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_DenCoiCom.bdDentalCoinsuranceMaxPer)
					ELSE ''
				END AS PBP_B16A_COINS_PCT_MAXOV_24,
				CASE
					WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a')
						AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_DenCoiCom.bdDentalCoinsuranceMinPer)
						ELSE ''
					END AS PBP_B16A_COINS_PCT_MINOV_25,
					CASE
						WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a1')
							AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_BenUnlCom.bdIndicateNumOfVisit)
							ELSE ''
						END AS PBP_B16A_BENDESC_NUMV_OE_26,
						CASE
							WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a1')
								AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_BenUnlCom.bdBenefitUnlimitedPeriodicity)
								ELSE ''
							END AS PBP_B16A_BENDESC_PER_OE_27,
							CASE
								WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a1')
									AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceMinAmount)
									ELSE ''
								END AS PBP_B16A_COINS_PCT_OE_28,
								CASE
									WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a1')
										AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentMinAmount)
										ELSE ''
									END AS PBP_B16A_COPAY_AMT_OEMIN_29
								FROM
									jsonlib.root
								LEFT JOIN jsonlib.pbp AS pbp ON
									root.ordinal_root = pbp.ordinal_root
								LEFT JOIN jsonlib.pbp_benefitDetails AS pbp_benefitDetails ON
									pbp.ordinal_pbp = pbp_benefitDetails.ordinal_pbp
								LEFT JOIN jsonlib.benefitDetails_benefDetaiInfo AS benefitDetails_benefDetaiInfo ON
									pbp_benefitDetails.ordinal_benefitDetails = benefitDetails_benefDetaiInfo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefDetaiInfo_benefitDetails AS benefDetaiInfo_benefitDetails ON
									benefitDetails_benefDetaiInfo.ordinal_benefDetaiInfo = benefDetaiInfo_benefitDetails.ordinal_benefDetaiInfo
								LEFT JOIN jsonlib.benefitDetails_DenCoiCom AS benefitDetails_DenCoiCom ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_DenCoiCom.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_BenUnlCom AS benefitDetails_BenUnlCom ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_BenUnlCom.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_CoinsCompo AS benefitDetails_CoinsCompo ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CoinsCompo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_CopayCompo AS benefitDetails_CopayCompo ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CopayCompo.ordinal_benefitDetails ) main
	GROUP BY
		qid) segment_4 ON
	segment_0.qid = segment_4.qid
LEFT JOIN (
	SELECT
		qid,
		MAX(PBP_B16A_COPAY_EHC_30) AS PBP_B16A_COPAY_EHC_30,
		MAX(PBP_B16A_COINS_PCT_PC_31) AS PBP_B16A_COINS_PCT_PC_31,
		MAX(PBP_B16A_COPAY_AMT_PCMIN_32) AS PBP_B16A_COPAY_AMT_PCMIN_32,
		MAX(PBP_B16A_BENDESC_NUMV_PC_33) AS PBP_B16A_BENDESC_NUMV_PC_33,
		MAX(PBP_B16A_COINS_EHC_34) AS PBP_B16A_COINS_EHC_34,
		MAX(PBP_B16A_BENDESC_PER_PC_35) AS PBP_B16A_BENDESC_PER_PC_35
	FROM
		(
		SELECT
			put(cat(contractId,
			planId,
			put(segmentId,
			z3.)),
			$11.) AS qid,
			CASE
				WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a2')
					AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentAmountYesNoMinMax)
					ELSE ''
				END AS PBP_B16A_COPAY_EHC_30,
				CASE
					WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a2')
						AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceMinAmount)
						ELSE ''
					END AS PBP_B16A_COINS_PCT_PC_31,
					CASE
						WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a2')
							AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentMinAmount)
							ELSE ''
						END AS PBP_B16A_COPAY_AMT_PCMIN_32,
						CASE
							WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a2')
								AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_BenUnlCom.bdIndicateNumOfVisit)
								ELSE ''
							END AS PBP_B16A_BENDESC_NUMV_PC_33,
							CASE
								WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a2')
									AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceAmountYesNoMinMax)
									ELSE ''
								END AS PBP_B16A_COINS_EHC_34,
								CASE
									WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a2')
										AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_BenUnlCom.bdBenefitUnlimitedPeriodicity)
										ELSE ''
									END AS PBP_B16A_BENDESC_PER_PC_35
								FROM
									jsonlib.root
								LEFT JOIN jsonlib.pbp AS pbp ON
									root.ordinal_root = pbp.ordinal_root
								LEFT JOIN jsonlib.pbp_benefitDetails AS pbp_benefitDetails ON
									pbp.ordinal_pbp = pbp_benefitDetails.ordinal_pbp
								LEFT JOIN jsonlib.benefitDetails_benefDetaiInfo AS benefitDetails_benefDetaiInfo ON
									pbp_benefitDetails.ordinal_benefitDetails = benefitDetails_benefDetaiInfo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefDetaiInfo_benefitDetails AS benefDetaiInfo_benefitDetails ON
									benefitDetails_benefDetaiInfo.ordinal_benefDetaiInfo = benefDetaiInfo_benefitDetails.ordinal_benefDetaiInfo
								LEFT JOIN jsonlib.benefitDetails_CopayCompo AS benefitDetails_CopayCompo ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CopayCompo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_CoinsCompo AS benefitDetails_CoinsCompo ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CoinsCompo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_BenUnlCom AS benefitDetails_BenUnlCom ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_BenUnlCom.ordinal_benefitDetails ) main
	GROUP BY
		qid) segment_5 ON
	segment_0.qid = segment_5.qid
LEFT JOIN (
	SELECT
		qid,
		MAX(PBP_B16A_COPAY_AMT_DXMIN_36) AS PBP_B16A_COPAY_AMT_DXMIN_36,
		MAX(PBP_B16A_BENDESC_PER_DX_37) AS PBP_B16A_BENDESC_PER_DX_37,
		MAX(PBP_B16A_BENDESC_NUMV_DX_38) AS PBP_B16A_BENDESC_NUMV_DX_38,
		MAX(PBP_B16A_COINS_PCT_DX_39) AS PBP_B16A_COINS_PCT_DX_39,
		MAX(PBP_B16B_COINS_EHC_40) AS PBP_B16B_COINS_EHC_40,
		MAX(PBP_B16B_MAXPLAN_AMT_41) AS PBP_B16B_MAXPLAN_AMT_41
	FROM
		(
		SELECT
			put(cat(contractId,
			planId,
			put(segmentId,
			z3.)),
			$11.) AS qid,
			CASE
				WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a4')
					AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentMinAmount)
					ELSE ''
				END AS PBP_B16A_COPAY_AMT_DXMIN_36,
				CASE
					WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a4')
						AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_BenUnlCom.bdBenefitUnlimitedPeriodicity)
						ELSE ''
					END AS PBP_B16A_BENDESC_PER_DX_37,
					CASE
						WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a4')
							AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_BenUnlCom.bdIndicateNumOfVisit)
							ELSE ''
						END AS PBP_B16A_BENDESC_NUMV_DX_38,
						CASE
							WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a4')
								AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceMinAmount)
								ELSE ''
							END AS PBP_B16A_COINS_PCT_DX_39,
							CASE
								WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b1')
									AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceAmountYesNoMinMax)
									ELSE ''
								END AS PBP_B16B_COINS_EHC_40,
								CASE
									WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b')
										AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_MaPlComDeCom.bdMaxPlanComprDentaAmoun)
										ELSE ''
									END AS PBP_B16B_MAXPLAN_AMT_41
								FROM
									jsonlib.root
								LEFT JOIN jsonlib.pbp AS pbp ON
									root.ordinal_root = pbp.ordinal_root
								LEFT JOIN jsonlib.pbp_benefitDetails AS pbp_benefitDetails ON
									pbp.ordinal_pbp = pbp_benefitDetails.ordinal_pbp
								LEFT JOIN jsonlib.benefitDetails_benefDetaiInfo AS benefitDetails_benefDetaiInfo ON
									pbp_benefitDetails.ordinal_benefitDetails = benefitDetails_benefDetaiInfo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefDetaiInfo_benefitDetails AS benefDetaiInfo_benefitDetails ON
									benefitDetails_benefDetaiInfo.ordinal_benefDetaiInfo = benefDetaiInfo_benefitDetails.ordinal_benefDetaiInfo
								LEFT JOIN jsonlib.benefitDetails_CopayCompo AS benefitDetails_CopayCompo ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CopayCompo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_BenUnlCom AS benefitDetails_BenUnlCom ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_BenUnlCom.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_CoinsCompo AS benefitDetails_CoinsCompo ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CoinsCompo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_MaPlComDeCom AS benefitDetails_MaPlComDeCom ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_MaPlComDeCom.ordinal_benefitDetails ) main
	GROUP BY
		qid) segment_6 ON
	segment_0.qid = segment_6.qid
LEFT JOIN (
	SELECT
		qid,
		MAX(PBP_B16B_MAXBENE_TYPE_42) AS PBP_B16B_MAXBENE_TYPE_42,
		MAX(PBP_B16B_MAXPLAN_PER_43) AS PBP_B16B_MAXPLAN_PER_43,
		MAX(PBP_B16B_COPAY_EHC_44) AS PBP_B16B_COPAY_EHC_44,
		MAX(PBP_B16B_COINS_EHC_45) AS PBP_B16B_COINS_EHC_45,
		MAX(PBP_B16B_COPAY_EHC_46) AS PBP_B16B_COPAY_EHC_46,
		MAX(PBP_B16B_BENDESC_NUMV_RS_47) AS PBP_B16B_BENDESC_NUMV_RS_47
	FROM
		(
		SELECT
			put(cat(contractId,
			planId,
			put(segmentId,
			z3.)),
			$11.) AS qid,
			CASE
				WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b')
					AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_MaPlComDeCom.bdMaxPlanCompDentRadiOpts)
					ELSE ''
				END AS PBP_B16B_MAXBENE_TYPE_42,
				CASE
					WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b')
						AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_MaPlComDeCom.bdMaxPlanComprDentaPerio)
						ELSE ''
					END AS PBP_B16B_MAXPLAN_PER_43,
					CASE
						WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b1')
							AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentAmountYesNoMinMax)
							ELSE ''
						END AS PBP_B16B_COPAY_EHC_44,
						CASE
							WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b2')
								AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceAmountYesNoMinMax)
								ELSE ''
							END AS PBP_B16B_COINS_EHC_45,
							CASE
								WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b2')
									AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentAmountYesNoMinMax)
									ELSE ''
								END AS PBP_B16B_COPAY_EHC_46,
								CASE
									WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b3')
										AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_BenUnlCom.bdIndicateNumOfVisit)
										ELSE ''
									END AS PBP_B16B_BENDESC_NUMV_RS_47
								FROM
									jsonlib.root
								LEFT JOIN jsonlib.pbp AS pbp ON
									root.ordinal_root = pbp.ordinal_root
								LEFT JOIN jsonlib.pbp_benefitDetails AS pbp_benefitDetails ON
									pbp.ordinal_pbp = pbp_benefitDetails.ordinal_pbp
								LEFT JOIN jsonlib.benefitDetails_benefDetaiInfo AS benefitDetails_benefDetaiInfo ON
									pbp_benefitDetails.ordinal_benefitDetails = benefitDetails_benefDetaiInfo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefDetaiInfo_benefitDetails AS benefDetaiInfo_benefitDetails ON
									benefitDetails_benefDetaiInfo.ordinal_benefDetaiInfo = benefDetaiInfo_benefitDetails.ordinal_benefDetaiInfo
								LEFT JOIN jsonlib.benefitDetails_MaPlComDeCom AS benefitDetails_MaPlComDeCom ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_MaPlComDeCom.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_CopayCompo AS benefitDetails_CopayCompo ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CopayCompo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_CoinsCompo AS benefitDetails_CoinsCompo ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CoinsCompo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_BenUnlCom AS benefitDetails_BenUnlCom ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_BenUnlCom.ordinal_benefitDetails ) main
	GROUP BY
		qid) segment_7 ON
	segment_0.qid = segment_7.qid
LEFT JOIN (
	SELECT
		qid,
		MAX(PBP_B16B_COINS_PCT_RS_MIN_48) AS PBP_B16B_COINS_PCT_RS_MIN_48,
		MAX(PBP_B16B_COPAY_AMT_RS_MIN_49) AS PBP_B16B_COPAY_AMT_RS_MIN_49,
		MAX(PBP_B16B_BENDESC_PER_RS_50) AS PBP_B16B_BENDESC_PER_RS_50,
		MAX(PBP_B16B_COPAY_EHC_51) AS PBP_B16B_COPAY_EHC_51,
		MAX(PBP_B16B_COINS_EHC_52) AS PBP_B16B_COINS_EHC_52,
		MAX(PBP_B16B_BENDESC_PER_END_53) AS PBP_B16B_BENDESC_PER_END_53
	FROM
		(
		SELECT
			put(cat(contractId,
			planId,
			put(segmentId,
			z3.)),
			$11.) AS qid,
			CASE
				WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b3')
					AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceMinAmount)
					ELSE ''
				END AS PBP_B16B_COINS_PCT_RS_MIN_48,
				CASE
					WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b3')
						AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentMinAmount)
						ELSE ''
					END AS PBP_B16B_COPAY_AMT_RS_MIN_49,
					CASE
						WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b3')
							AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_BenUnlCom.bdBenefitUnlimitedPeriodicity)
							ELSE ''
						END AS PBP_B16B_BENDESC_PER_RS_50,
						CASE
							WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b3')
								AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentAmountYesNoMinMax)
								ELSE ''
							END AS PBP_B16B_COPAY_EHC_51,
							CASE
								WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b3')
									AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceAmountYesNoMinMax)
									ELSE ''
								END AS PBP_B16B_COINS_EHC_52,
								CASE
									WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b4')
										AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_BenUnlCom.bdBenefitUnlimitedPeriodicity)
										ELSE ''
									END AS PBP_B16B_BENDESC_PER_END_53
								FROM
									jsonlib.root
								LEFT JOIN jsonlib.pbp AS pbp ON
									root.ordinal_root = pbp.ordinal_root
								LEFT JOIN jsonlib.pbp_benefitDetails AS pbp_benefitDetails ON
									pbp.ordinal_pbp = pbp_benefitDetails.ordinal_pbp
								LEFT JOIN jsonlib.benefitDetails_benefDetaiInfo AS benefitDetails_benefDetaiInfo ON
									pbp_benefitDetails.ordinal_benefitDetails = benefitDetails_benefDetaiInfo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefDetaiInfo_benefitDetails AS benefDetaiInfo_benefitDetails ON
									benefitDetails_benefDetaiInfo.ordinal_benefDetaiInfo = benefDetaiInfo_benefitDetails.ordinal_benefDetaiInfo
								LEFT JOIN jsonlib.benefitDetails_CoinsCompo AS benefitDetails_CoinsCompo ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CoinsCompo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_CopayCompo AS benefitDetails_CopayCompo ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CopayCompo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_BenUnlCom AS benefitDetails_BenUnlCom ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_BenUnlCom.ordinal_benefitDetails ) main
	GROUP BY
		qid) segment_8 ON
	segment_0.qid = segment_8.qid
LEFT JOIN (
	SELECT
		qid,
		MAX(PBP_B16B_COINS_PCT_END_MIN_54) AS PBP_B16B_COINS_PCT_END_MIN_54,
		MAX(PBP_B16B_BENDESC_NUM_END_55) AS PBP_B16B_BENDESC_NUM_END_55,
		MAX(PBP_B16B_COINS_EHC_56) AS PBP_B16B_COINS_EHC_56,
		MAX(PBP_B16B_COPAY_AMT_END_MIN_57) AS PBP_B16B_COPAY_AMT_END_MIN_57,
		MAX(PBP_B16B_COPAY_EHC_58) AS PBP_B16B_COPAY_EHC_58,
		MAX(PBP_B16B_BENDESC_PER_PERI_59) AS PBP_B16B_BENDESC_PER_PERI_59
	FROM
		(
		SELECT
			put(cat(contractId,
			planId,
			put(segmentId,
			z3.)),
			$11.) AS qid,
			CASE
				WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b4')
					AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceMinAmount)
					ELSE ''
				END AS PBP_B16B_COINS_PCT_END_MIN_54,
				CASE
					WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b4')
						AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_BenUnlCom.bdIndicateNumOfVisit)
						ELSE ''
					END AS PBP_B16B_BENDESC_NUM_END_55,
					CASE
						WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b4')
							AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceAmountYesNoMinMax)
							ELSE ''
						END AS PBP_B16B_COINS_EHC_56,
						CASE
							WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b4')
								AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentMinAmount)
								ELSE ''
							END AS PBP_B16B_COPAY_AMT_END_MIN_57,
							CASE
								WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b4')
									AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentAmountYesNoMinMax)
									ELSE ''
								END AS PBP_B16B_COPAY_EHC_58,
								CASE
									WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b5')
										AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_BenUnlCom.bdBenefitUnlimitedPeriodicity)
										ELSE ''
									END AS PBP_B16B_BENDESC_PER_PERI_59
								FROM
									jsonlib.root
								LEFT JOIN jsonlib.pbp AS pbp ON
									root.ordinal_root = pbp.ordinal_root
								LEFT JOIN jsonlib.pbp_benefitDetails AS pbp_benefitDetails ON
									pbp.ordinal_pbp = pbp_benefitDetails.ordinal_pbp
								LEFT JOIN jsonlib.benefitDetails_benefDetaiInfo AS benefitDetails_benefDetaiInfo ON
									pbp_benefitDetails.ordinal_benefitDetails = benefitDetails_benefDetaiInfo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefDetaiInfo_benefitDetails AS benefDetaiInfo_benefitDetails ON
									benefitDetails_benefDetaiInfo.ordinal_benefDetaiInfo = benefDetaiInfo_benefitDetails.ordinal_benefDetaiInfo
								LEFT JOIN jsonlib.benefitDetails_CoinsCompo AS benefitDetails_CoinsCompo ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CoinsCompo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_BenUnlCom AS benefitDetails_BenUnlCom ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_BenUnlCom.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_CopayCompo AS benefitDetails_CopayCompo ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CopayCompo.ordinal_benefitDetails ) main
	GROUP BY
		qid) segment_9 ON
	segment_0.qid = segment_9.qid
LEFT JOIN (
	SELECT
		qid,
		MAX(PBP_B16B_COINS_EHC_60) AS PBP_B16B_COINS_EHC_60,
		MAX(PBP_B16B_COPAY_EHC_61) AS PBP_B16B_COPAY_EHC_61,
		MAX(PBP_B16B_COINS_PCT_PERI_MIN_62) AS PBP_B16B_COINS_PCT_PERI_MIN_62,
		MAX(PBP_B16B_COPAY_AMT_PERI_MIN_63) AS PBP_B16B_COPAY_AMT_PERI_MIN_63,
		MAX(PBP_B16B_BENDESC_NUM_PERI_64) AS PBP_B16B_BENDESC_NUM_PERI_64,
		MAX(PBP_B16B_COINS_EHC_65) AS PBP_B16B_COINS_EHC_65
	FROM
		(
		SELECT
			put(cat(contractId,
			planId,
			put(segmentId,
			z3.)),
			$11.) AS qid,
			CASE
				WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b5')
					AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceAmountYesNoMinMax)
					ELSE ''
				END AS PBP_B16B_COINS_EHC_60,
				CASE
					WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b5')
						AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentAmountYesNoMinMax)
						ELSE ''
					END AS PBP_B16B_COPAY_EHC_61,
					CASE
						WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b5')
							AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceMinAmount)
							ELSE ''
						END AS PBP_B16B_COINS_PCT_PERI_MIN_62,
						CASE
							WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b5')
								AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentMinAmount)
								ELSE ''
							END AS PBP_B16B_COPAY_AMT_PERI_MIN_63,
							CASE
								WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b5')
									AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_BenUnlCom.bdIndicateNumOfVisit)
									ELSE ''
								END AS PBP_B16B_BENDESC_NUM_PERI_64,
								CASE
									WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b6')
										AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceAmountYesNoMinMax)
										ELSE ''
									END AS PBP_B16B_COINS_EHC_65
								FROM
									jsonlib.root
								LEFT JOIN jsonlib.pbp AS pbp ON
									root.ordinal_root = pbp.ordinal_root
								LEFT JOIN jsonlib.pbp_benefitDetails AS pbp_benefitDetails ON
									pbp.ordinal_pbp = pbp_benefitDetails.ordinal_pbp
								LEFT JOIN jsonlib.benefitDetails_benefDetaiInfo AS benefitDetails_benefDetaiInfo ON
									pbp_benefitDetails.ordinal_benefitDetails = benefitDetails_benefDetaiInfo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefDetaiInfo_benefitDetails AS benefDetaiInfo_benefitDetails ON
									benefitDetails_benefDetaiInfo.ordinal_benefDetaiInfo = benefDetaiInfo_benefitDetails.ordinal_benefDetaiInfo
								LEFT JOIN jsonlib.benefitDetails_CoinsCompo AS benefitDetails_CoinsCompo ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CoinsCompo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_CopayCompo AS benefitDetails_CopayCompo ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CopayCompo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_BenUnlCom AS benefitDetails_BenUnlCom ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_BenUnlCom.ordinal_benefitDetails ) main
	GROUP BY
		qid) segment_10 ON
	segment_0.qid = segment_10.qid
LEFT JOIN (
	SELECT
		qid,
		MAX(PBP_B16B_BENDESC_PER_EXT_66) AS PBP_B16B_BENDESC_PER_EXT_66,
		MAX(PBP_B16B_COPAY_AMT_EXT_MIN_67) AS PBP_B16B_COPAY_AMT_EXT_MIN_67,
		MAX(PBP_B16B_COPAY_EHC_68) AS PBP_B16B_COPAY_EHC_68,
		MAX(PBP_B16B_BENDESC_NUM_EXT_69) AS PBP_B16B_BENDESC_NUM_EXT_69,
		MAX(PBP_B16B_COINS_PCT_EXT_MIN_70) AS PBP_B16B_COINS_PCT_EXT_MIN_70,
		MAX(PBP_B16B_BENDESC_NUMV_POO_71) AS PBP_B16B_BENDESC_NUMV_POO_71
	FROM
		(
		SELECT
			put(cat(contractId,
			planId,
			put(segmentId,
			z3.)),
			$11.) AS qid,
			CASE
				WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b6')
					AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_BenUnlCom.bdBenefitUnlimitedPeriodicity)
					ELSE ''
				END AS PBP_B16B_BENDESC_PER_EXT_66,
				CASE
					WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b6')
						AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentMinAmount)
						ELSE ''
					END AS PBP_B16B_COPAY_AMT_EXT_MIN_67,
					CASE
						WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b6')
							AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentAmountYesNoMinMax)
							ELSE ''
						END AS PBP_B16B_COPAY_EHC_68,
						CASE
							WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b6')
								AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_BenUnlCom.bdIndicateNumOfVisit)
								ELSE ''
							END AS PBP_B16B_BENDESC_NUM_EXT_69,
							CASE
								WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b6')
									AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceMinAmount)
									ELSE ''
								END AS PBP_B16B_COINS_PCT_EXT_MIN_70,
								CASE
									WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b7')
										AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_BenUnlCom.bdIndicateNumOfVisit)
										ELSE ''
									END AS PBP_B16B_BENDESC_NUMV_POO_71
								FROM
									jsonlib.root
								LEFT JOIN jsonlib.pbp AS pbp ON
									root.ordinal_root = pbp.ordinal_root
								LEFT JOIN jsonlib.pbp_benefitDetails AS pbp_benefitDetails ON
									pbp.ordinal_pbp = pbp_benefitDetails.ordinal_pbp
								LEFT JOIN jsonlib.benefitDetails_benefDetaiInfo AS benefitDetails_benefDetaiInfo ON
									pbp_benefitDetails.ordinal_benefitDetails = benefitDetails_benefDetaiInfo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefDetaiInfo_benefitDetails AS benefDetaiInfo_benefitDetails ON
									benefitDetails_benefDetaiInfo.ordinal_benefDetaiInfo = benefDetaiInfo_benefitDetails.ordinal_benefDetaiInfo
								LEFT JOIN jsonlib.benefitDetails_BenUnlCom AS benefitDetails_BenUnlCom ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_BenUnlCom.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_CopayCompo AS benefitDetails_CopayCompo ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CopayCompo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_CoinsCompo AS benefitDetails_CoinsCompo ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CoinsCompo.ordinal_benefitDetails ) main
	GROUP BY
		qid) segment_11 ON
	segment_0.qid = segment_11.qid
LEFT JOIN (
	SELECT
		qid,
		MAX(PBP_B16B_COPAY_AMT_POO_MIN_72) AS PBP_B16B_COPAY_AMT_POO_MIN_72,
		MAX(PBP_B16B_COINS_PCT_POO_MIN_73) AS PBP_B16B_COINS_PCT_POO_MIN_73,
		MAX(PBP_B16B_BENDESC_PER_POO_74) AS PBP_B16B_BENDESC_PER_POO_74,
		MAX(PBP_B16B_COPAY_EHC_75) AS PBP_B16B_COPAY_EHC_75,
		MAX(PBP_B16B_COINS_EHC_76) AS PBP_B16B_COINS_EHC_76
	FROM
		(
		SELECT
			put(cat(contractId,
			planId,
			put(segmentId,
			z3.)),
			$11.) AS qid,
			CASE
				WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b7')
					AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentMinAmount)
					ELSE ''
				END AS PBP_B16B_COPAY_AMT_POO_MIN_72,
				CASE
					WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b7')
						AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceMinAmount)
						ELSE ''
					END AS PBP_B16B_COINS_PCT_POO_MIN_73,
					CASE
						WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b7')
							AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_BenUnlCom.bdBenefitUnlimitedPeriodicity)
							ELSE ''
						END AS PBP_B16B_BENDESC_PER_POO_74,
						CASE
							WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b7')
								AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentAmountYesNoMinMax)
								ELSE ''
							END AS PBP_B16B_COPAY_EHC_75,
							CASE
								WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b7')
									AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceAmountYesNoMinMax)
									ELSE ''
								END AS PBP_B16B_COINS_EHC_76
								FROM
									jsonlib.root
								LEFT JOIN jsonlib.pbp AS pbp ON
									root.ordinal_root = pbp.ordinal_root
								LEFT JOIN jsonlib.pbp_benefitDetails AS pbp_benefitDetails ON
									pbp.ordinal_pbp = pbp_benefitDetails.ordinal_pbp
								LEFT JOIN jsonlib.benefitDetails_benefDetaiInfo AS benefitDetails_benefDetaiInfo ON
									pbp_benefitDetails.ordinal_benefitDetails = benefitDetails_benefDetaiInfo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefDetaiInfo_benefitDetails AS benefDetaiInfo_benefitDetails ON
									benefitDetails_benefDetaiInfo.ordinal_benefDetaiInfo = benefDetaiInfo_benefitDetails.ordinal_benefDetaiInfo
								LEFT JOIN jsonlib.benefitDetails_CopayCompo AS benefitDetails_CopayCompo ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CopayCompo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_CoinsCompo AS benefitDetails_CoinsCompo ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CoinsCompo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_BenUnlCom AS benefitDetails_BenUnlCom ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_BenUnlCom.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_DenCopCom AS benefitDetails_DenCopCom ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_DenCopCom.ordinal_benefitDetails
								LEFT JOIN jsonlib.DenCopCom_bdDenCopSerOpt2 AS DenCopCom_bdDenCopSerOpt2 ON
									benefitDetails_DenCopCom.ordinal_DenCopCom = DenCopCom_bdDenCopSerOpt2.ordinal_DenCopCom ) main
	GROUP BY
		qid) segment_12 ON
	segment_0.qid = segment_12.qid
LEFT JOIN (
	SELECT
		qid,
		MAX(PBP_B16A_COINS_EHC_78) AS PBP_B16A_COINS_EHC_78,
		MAX(PBP_B16A_COPAY_EHC_79) AS PBP_B16A_COPAY_EHC_79,
		MAX(PBP_B16A_COINS_EHC_80) AS PBP_B16A_COINS_EHC_80,
		MAX(PBP_B16A_COPAY_EHC_81) AS PBP_B16A_COPAY_EHC_81,
		MAX(PBP_B16A_COINS_EHC_82) AS PBP_B16A_COINS_EHC_82,
		MAX(PBP_B16A_COPAY_EHC_83) AS PBP_B16A_COPAY_EHC_83
	FROM
		(
		SELECT
			put(cat(contractId,
			planId,
			put(segmentId,
			z3.)),
			$11.) AS qid,
			CASE
				WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a1')
					AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceAmountYesNoMinMax)
					ELSE ''
				END AS PBP_B16A_COINS_EHC_78,
				CASE
					WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a1')
						AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentAmountYesNoMinMax)
						ELSE ''
					END AS PBP_B16A_COPAY_EHC_79,
					CASE
						WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a3')
							AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceAmountYesNoMinMax)
							ELSE ''
						END AS PBP_B16A_COINS_EHC_80,
						CASE
							WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a3')
								AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentAmountYesNoMinMax)
								ELSE ''
							END AS PBP_B16A_COPAY_EHC_81,
							CASE
								WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a4')
									AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceAmountYesNoMinMax)
									ELSE ''
								END AS PBP_B16A_COINS_EHC_82,
								CASE
									WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a4')
										AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentAmountYesNoMinMax)
										ELSE ''
									END AS PBP_B16A_COPAY_EHC_83
								FROM
									jsonlib.root
								LEFT JOIN jsonlib.pbp AS pbp ON
									root.ordinal_root = pbp.ordinal_root
								LEFT JOIN jsonlib.pbp_benefitDetails AS pbp_benefitDetails ON
									pbp.ordinal_pbp = pbp_benefitDetails.ordinal_pbp
								LEFT JOIN jsonlib.benefitDetails_benefDetaiInfo AS benefitDetails_benefDetaiInfo ON
									pbp_benefitDetails.ordinal_benefitDetails = benefitDetails_benefDetaiInfo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefDetaiInfo_benefitDetails AS benefDetaiInfo_benefitDetails ON
									benefitDetails_benefDetaiInfo.ordinal_benefDetaiInfo = benefDetaiInfo_benefitDetails.ordinal_benefDetaiInfo
								LEFT JOIN jsonlib.benefitDetails_CoinsCompo AS benefitDetails_CoinsCompo ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CoinsCompo.ordinal_benefitDetails
								LEFT JOIN jsonlib.benefitDetails_CopayCompo AS benefitDetails_CopayCompo ON
									benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CopayCompo.ordinal_benefitDetails ) main
	GROUP BY
		qid) segment_13 ON
	segment_0.qid = segment_13.qid
LEFT JOIN (
	SELECT
		qid,
		MAX(PBP_B16B_COINS_PCT_MC_MIN_84) AS PBP_B16B_COINS_PCT_MC_MIN_84,
		MAX(PBP_B16A_COINS_PCT_OE_85) AS PBP_B16A_COINS_PCT_OE_85,
		MAX(PBP_B16A_COINS_PCT_PC_86) AS PBP_B16A_COINS_PCT_PC_86,
		MAX(PBP_B16A_COINS_PCT_DX_87) AS PBP_B16A_COINS_PCT_DX_87,
		MAX(PBP_B16B_COINS_PCT_RS_MIN_88) AS PBP_B16B_COINS_PCT_RS_MIN_88
	FROM
		(
		SELECT
			put(cat(contractId,
			planId,
			put(segmentId,
			z3.)),
			$11.) AS qid,
			CASE
				WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b')
					AND benefitDetails_benefDetaiInfo.categoryTypeId = 1 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceAmount)
					ELSE ''
				END AS PBP_B16B_COINS_PCT_MC_MIN_84,
				CASE
					WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a1')
						AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceAmount)
						ELSE ''
					END AS PBP_B16A_COINS_PCT_OE_85,
					CASE
						WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a2')
							AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceAmount)
							ELSE ''
						END AS PBP_B16A_COINS_PCT_PC_86,
						CASE
							WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a4')
								AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceAmount)
								ELSE ''
							END AS PBP_B16A_COINS_PCT_DX_87,
							CASE
								WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b3')
									AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceAmount)
									ELSE ''
								END AS PBP_B16B_COINS_PCT_RS_MIN_88
							FROM
								jsonlib.root
							LEFT JOIN jsonlib.pbp AS pbp ON
								root.ordinal_root = pbp.ordinal_root
							LEFT JOIN jsonlib.pbp_benefitDetails AS pbp_benefitDetails ON
								pbp.ordinal_pbp = pbp_benefitDetails.ordinal_pbp
							LEFT JOIN jsonlib.benefitDetails_benefDetaiInfo AS benefitDetails_benefDetaiInfo ON
								pbp_benefitDetails.ordinal_benefitDetails = benefitDetails_benefDetaiInfo.ordinal_benefitDetails
							LEFT JOIN jsonlib.benefDetaiInfo_benefitDetails AS benefDetaiInfo_benefitDetails ON
								benefitDetails_benefDetaiInfo.ordinal_benefDetaiInfo = benefDetaiInfo_benefitDetails.ordinal_benefDetaiInfo
							LEFT JOIN jsonlib.benefitDetails_CoinsCompo AS benefitDetails_CoinsCompo ON
								benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CoinsCompo.ordinal_benefitDetails ) main
	GROUP BY
		qid) segment_14 ON
	segment_0.qid = segment_14.qid
LEFT JOIN (
	SELECT
		qid,
		MAX(PBP_B16B_COINS_PCT_END_MIN_89) AS PBP_B16B_COINS_PCT_END_MIN_89,
		MAX(PBP_B16B_COINS_PCT_PERI_MIN_90) AS PBP_B16B_COINS_PCT_PERI_MIN_90,
		MAX(PBP_B16B_COINS_PCT_EXT_MIN_91) AS PBP_B16B_COINS_PCT_EXT_MIN_91,
		MAX(PBP_B16B_COINS_PCT_POO_MIN_92) AS PBP_B16B_COINS_PCT_POO_MIN_92,
		MAX(PBP_B16B_COPAY_AMT_MC_MIN_93) AS PBP_B16B_COPAY_AMT_MC_MIN_93
	FROM
		(
		SELECT
			put(cat(contractId,
			planId,
			put(segmentId,
			z3.)),
			$11.) AS qid,
			CASE
				WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b4')
					AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceAmount)
					ELSE ''
				END AS PBP_B16B_COINS_PCT_END_MIN_89,
				CASE
					WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b5')
						AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceAmount)
						ELSE ''
					END AS PBP_B16B_COINS_PCT_PERI_MIN_90,
					CASE
						WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b6')
							AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceAmount)
							ELSE ''
						END AS PBP_B16B_COINS_PCT_EXT_MIN_91,
						CASE
							WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b7')
								AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CoinsCompo.bdCoinsuranceAmount)
								ELSE ''
							END AS PBP_B16B_COINS_PCT_POO_MIN_92,
							CASE
								WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b')
									AND benefitDetails_benefDetaiInfo.categoryTypeId = 1 THEN CATS(benefitDetails_CopayCompo.bdCopaymentAmount)
									ELSE ''
								END AS PBP_B16B_COPAY_AMT_MC_MIN_93
							FROM
								jsonlib.root
							LEFT JOIN jsonlib.pbp AS pbp ON
								root.ordinal_root = pbp.ordinal_root
							LEFT JOIN jsonlib.pbp_benefitDetails AS pbp_benefitDetails ON
								pbp.ordinal_pbp = pbp_benefitDetails.ordinal_pbp
							LEFT JOIN jsonlib.benefitDetails_benefDetaiInfo AS benefitDetails_benefDetaiInfo ON
								pbp_benefitDetails.ordinal_benefitDetails = benefitDetails_benefDetaiInfo.ordinal_benefitDetails
							LEFT JOIN jsonlib.benefDetaiInfo_benefitDetails AS benefDetaiInfo_benefitDetails ON
								benefitDetails_benefDetaiInfo.ordinal_benefDetaiInfo = benefDetaiInfo_benefitDetails.ordinal_benefDetaiInfo
							LEFT JOIN jsonlib.benefitDetails_CoinsCompo AS benefitDetails_CoinsCompo ON
								benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CoinsCompo.ordinal_benefitDetails
							LEFT JOIN jsonlib.benefitDetails_CopayCompo AS benefitDetails_CopayCompo ON
								benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CopayCompo.ordinal_benefitDetails ) main
	GROUP BY
		qid) segment_15 ON
	segment_0.qid = segment_15.qid
LEFT JOIN (
	SELECT
		qid,
		MAX(PBP_B16A_COPAY_AMT_OEMIN_94) AS PBP_B16A_COPAY_AMT_OEMIN_94,
		MAX(PBP_B16A_COPAY_AMT_PCMIN_95) AS PBP_B16A_COPAY_AMT_PCMIN_95,
		MAX(PBP_B16A_COPAY_AMT_DXMIN_96) AS PBP_B16A_COPAY_AMT_DXMIN_96,
		MAX(PBP_B16B_COPAY_AMT_RS_MIN_97) AS PBP_B16B_COPAY_AMT_RS_MIN_97,
		MAX(PBP_B16B_COPAY_AMT_END_MIN_98) AS PBP_B16B_COPAY_AMT_END_MIN_98
	FROM
		(
		SELECT
			put(cat(contractId,
			planId,
			put(segmentId,
			z3.)),
			$11.) AS qid,
			CASE
				WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a1')
					AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentAmount)
					ELSE ''
				END AS PBP_B16A_COPAY_AMT_OEMIN_94,
				CASE
					WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a2')
						AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentAmount)
						ELSE ''
					END AS PBP_B16A_COPAY_AMT_PCMIN_95,
					CASE
						WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a4')
							AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentAmount)
							ELSE ''
						END AS PBP_B16A_COPAY_AMT_DXMIN_96,
						CASE
							WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b3')
								AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentAmount)
								ELSE ''
							END AS PBP_B16B_COPAY_AMT_RS_MIN_97,
							CASE
								WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b4')
									AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentAmount)
									ELSE ''
								END AS PBP_B16B_COPAY_AMT_END_MIN_98
							FROM
								jsonlib.root
							LEFT JOIN jsonlib.pbp AS pbp ON
								root.ordinal_root = pbp.ordinal_root
							LEFT JOIN jsonlib.pbp_benefitDetails AS pbp_benefitDetails ON
								pbp.ordinal_pbp = pbp_benefitDetails.ordinal_pbp
							LEFT JOIN jsonlib.benefitDetails_benefDetaiInfo AS benefitDetails_benefDetaiInfo ON
								pbp_benefitDetails.ordinal_benefitDetails = benefitDetails_benefDetaiInfo.ordinal_benefitDetails
							LEFT JOIN jsonlib.benefDetaiInfo_benefitDetails AS benefDetaiInfo_benefitDetails ON
								benefitDetails_benefDetaiInfo.ordinal_benefDetaiInfo = benefDetaiInfo_benefitDetails.ordinal_benefDetaiInfo
							LEFT JOIN jsonlib.benefitDetails_CopayCompo AS benefitDetails_CopayCompo ON
								benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CopayCompo.ordinal_benefitDetails ) main
	GROUP BY
		qid) segment_16 ON
	segment_0.qid = segment_16.qid
LEFT JOIN (
	SELECT
		qid,
		MAX(PBP_B16B_COPAY_AMT_PERI_MIN_99) AS PBP_B16B_COPAY_AMT_PERI_MIN_99,
		MAX(PBP_B16B_COPAY_AMT_EXT_MIN_100) AS PBP_B16B_COPAY_AMT_EXT_MIN_100,
		MAX(PBP_B16B_COPAY_AMT_POO_MIN_101) AS PBP_B16B_COPAY_AMT_POO_MIN_101,
		MAX(PBP_B16A_COPAY_AMT_OVMAX_102) AS PBP_B16A_COPAY_AMT_OVMAX_102,
		MAX(PBP_B16A_COPAY_AMT_OVMIN_103) AS PBP_B16A_COPAY_AMT_OVMIN_103
	FROM
		(
		SELECT
			put(cat(contractId,
			planId,
			put(segmentId,
			z3.)),
			$11.) AS qid,
			CASE
				WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b5')
					AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentAmount)
					ELSE ''
				END AS PBP_B16B_COPAY_AMT_PERI_MIN_99,
				CASE
					WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b6')
						AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentAmount)
						ELSE ''
					END AS PBP_B16B_COPAY_AMT_EXT_MIN_100,
					CASE
						WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16b7')
							AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_CopayCompo.bdCopaymentAmount)
							ELSE ''
						END AS PBP_B16B_COPAY_AMT_POO_MIN_101,
						CASE
							WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a')
								AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_DenCopCom.bdDentalCopaymentAmount)
								ELSE ''
							END AS PBP_B16A_COPAY_AMT_OVMAX_102,
							CASE
								WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a')
									AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_DenCopCom.bdDentalCopaymentAmount)
									ELSE ''
								END AS PBP_B16A_COPAY_AMT_OVMIN_103
							FROM
								jsonlib.root
							LEFT JOIN jsonlib.pbp AS pbp ON
								root.ordinal_root = pbp.ordinal_root
							LEFT JOIN jsonlib.pbp_benefitDetails AS pbp_benefitDetails ON
								pbp.ordinal_pbp = pbp_benefitDetails.ordinal_pbp
							LEFT JOIN jsonlib.benefitDetails_benefDetaiInfo AS benefitDetails_benefDetaiInfo ON
								pbp_benefitDetails.ordinal_benefitDetails = benefitDetails_benefDetaiInfo.ordinal_benefitDetails
							LEFT JOIN jsonlib.benefDetaiInfo_benefitDetails AS benefDetaiInfo_benefitDetails ON
								benefitDetails_benefDetaiInfo.ordinal_benefDetaiInfo = benefDetaiInfo_benefitDetails.ordinal_benefDetaiInfo
							LEFT JOIN jsonlib.benefitDetails_CopayCompo AS benefitDetails_CopayCompo ON
								benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_CopayCompo.ordinal_benefitDetails
							LEFT JOIN jsonlib.benefitDetails_DenCopCom AS benefitDetails_DenCopCom ON
								benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_DenCopCom.ordinal_benefitDetails ) main
	GROUP BY
		qid) segment_17 ON
	segment_0.qid = segment_17.qid
LEFT JOIN (
	SELECT
		qid,
		MAX(PBP_B16A_COINS_PCT_MAXOV_104) AS PBP_B16A_COINS_PCT_MAXOV_104,
		MAX(PBP_B16A_COINS_PCT_MINOV_105) AS PBP_B16A_COINS_PCT_MINOV_105,
		MAX(PBP_B16A_COINS_CSERV_SC_106) AS PBP_B16A_COINS_CSERV_SC_106,
		MAX(PBP_B16A_COINS_CSERV_SC_107) AS PBP_B16A_COINS_CSERV_SC_107,
		MAX(PBP_B16A_COINS_CSERV_SC_108) AS PBP_B16A_COINS_CSERV_SC_108
	FROM
		(
		SELECT
			put(cat(contractId,
			planId,
			put(segmentId,
			z3.)),
			$11.) AS qid,
			CASE
				WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a')
					AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_DenCoiCom.bdDentalCoinsurancePer)
					ELSE ''
				END AS PBP_B16A_COINS_PCT_MAXOV_104,
				CASE
					WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a')
						AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(benefitDetails_DenCoiCom.bdDentalCoinsurancePer)
						ELSE ''
					END AS PBP_B16A_COINS_PCT_MINOV_105,
					CASE
						WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a')
							AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(DenCoiCom_bdDenCoiSerOpt2.dentalXRays)
							ELSE ''
						END AS PBP_B16A_COINS_CSERV_SC_106,
						CASE
							WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a')
								AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(DenCoiCom_bdDenCoiSerOpt2.oralExams)
								ELSE ''
							END AS PBP_B16A_COINS_CSERV_SC_107,
							CASE
								WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a')
									AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(DenCoiCom_bdDenCoiSerOpt2.prophylaxisCleaning)
									ELSE ''
								END AS PBP_B16A_COINS_CSERV_SC_108
							FROM
								jsonlib.root
							LEFT JOIN jsonlib.pbp AS pbp ON
								root.ordinal_root = pbp.ordinal_root
							LEFT JOIN jsonlib.pbp_benefitDetails AS pbp_benefitDetails ON
								pbp.ordinal_pbp = pbp_benefitDetails.ordinal_pbp
							LEFT JOIN jsonlib.benefitDetails_benefDetaiInfo AS benefitDetails_benefDetaiInfo ON
								pbp_benefitDetails.ordinal_benefitDetails = benefitDetails_benefDetaiInfo.ordinal_benefitDetails
							LEFT JOIN jsonlib.benefDetaiInfo_benefitDetails AS benefDetaiInfo_benefitDetails ON
								benefitDetails_benefDetaiInfo.ordinal_benefDetaiInfo = benefDetaiInfo_benefitDetails.ordinal_benefDetaiInfo
							LEFT JOIN jsonlib.benefitDetails_DenCoiCom AS benefitDetails_DenCoiCom ON
								benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_DenCoiCom.ordinal_benefitDetails
							LEFT JOIN jsonlib.DenCoiCom_bdDenCoiSerOpt2 AS DenCoiCom_bdDenCoiSerOpt2 ON
								benefitDetails_DenCoiCom.ordinal_DenCoiCom = DenCoiCom_bdDenCoiSerOpt2.ordinal_DenCoiCom ) main
	GROUP BY
		qid) segment_18 ON
	segment_0.qid = segment_18.qid
LEFT JOIN (
	SELECT
		qid,
		MAX(PBP_B16A_COINS_CSERV_SC_109) AS PBP_B16A_COINS_CSERV_SC_109,
		MAX(PBP_B16A_COPAY_CSERV_SC_110) AS PBP_B16A_COPAY_CSERV_SC_110,
		MAX(PBP_B16A_COPAY_CSERV_SC_111) AS PBP_B16A_COPAY_CSERV_SC_111,
		MAX(PBP_B16A_COPAY_CSERV_SC_112) AS PBP_B16A_COPAY_CSERV_SC_112,
		MAX(PBP_B16A_COPAY_CSERV_SC_113) AS PBP_B16A_COPAY_CSERV_SC_113
	FROM
		(
		SELECT
			put(cat(contractId,
			planId,
			put(segmentId,
			z3.)),
			$11.) AS qid,
			CASE
				WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a')
					AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(DenCoiCom_bdDenCoiSerOpt2.fluorideTreatment)
					ELSE ''
				END AS PBP_B16A_COINS_CSERV_SC_109,
				CASE
					WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a')
						AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(DenCopCom_bdDenCopSerOpt2.dentalXRays)
						ELSE ''
					END AS PBP_B16A_COPAY_CSERV_SC_110,
					CASE
						WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a')
							AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(DenCopCom_bdDenCopSerOpt2.oralExams)
							ELSE ''
						END AS PBP_B16A_COPAY_CSERV_SC_111,
						CASE
							WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a')
								AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(DenCopCom_bdDenCopSerOpt2.prophylaxisCleaning)
								ELSE ''
							END AS PBP_B16A_COPAY_CSERV_SC_112,
							CASE
								WHEN benefitDetails_benefDetaiInfo.categoryCode IN('16a')
									AND benefitDetails_benefDetaiInfo.categoryTypeId = 2 THEN CATS(DenCopCom_bdDenCopSerOpt2.fluorideTreatment)
									ELSE ''
								END AS PBP_B16A_COPAY_CSERV_SC_113
							FROM
								jsonlib.root
							LEFT JOIN jsonlib.pbp AS pbp ON
								root.ordinal_root = pbp.ordinal_root
							LEFT JOIN jsonlib.pbp_benefitDetails AS pbp_benefitDetails ON
								pbp.ordinal_pbp = pbp_benefitDetails.ordinal_pbp
							LEFT JOIN jsonlib.benefitDetails_benefDetaiInfo AS benefitDetails_benefDetaiInfo ON
								pbp_benefitDetails.ordinal_benefitDetails = benefitDetails_benefDetaiInfo.ordinal_benefitDetails
							LEFT JOIN jsonlib.benefDetaiInfo_benefitDetails AS benefDetaiInfo_benefitDetails ON
								benefitDetails_benefDetaiInfo.ordinal_benefDetaiInfo = benefDetaiInfo_benefitDetails.ordinal_benefDetaiInfo
							LEFT JOIN jsonlib.benefitDetails_DenCoiCom AS benefitDetails_DenCoiCom ON
								benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_DenCoiCom.ordinal_benefitDetails
							LEFT JOIN jsonlib.DenCoiCom_bdDenCoiSerOpt2 AS DenCoiCom_bdDenCoiSerOpt2 ON
								benefitDetails_DenCoiCom.ordinal_DenCoiCom = DenCoiCom_bdDenCoiSerOpt2.ordinal_DenCoiCom
							LEFT JOIN jsonlib.benefitDetails_DenCopCom AS benefitDetails_DenCopCom ON
								benefDetaiInfo_benefitDetails.ordinal_benefitDetails = benefitDetails_DenCopCom.ordinal_benefitDetails
							LEFT JOIN jsonlib.DenCopCom_bdDenCopSerOpt2 AS DenCopCom_bdDenCopSerOpt2 ON
								benefitDetails_DenCopCom.ordinal_DenCopCom = DenCopCom_bdDenCopSerOpt2.ordinal_DenCopCom ) main
	GROUP BY
		qid) segment_19 ON
	segment_0.qid = segment_19.qid;
QUIT;	
RUN;
%MEND;


