* PROGRAM NAME: BASEID_DRUGS.SAS;
* DESCRIPTION: BASEID_PLAN_CATEGORY.SAS;

%MACRO GETCOUNT(TYP);

  DATA &TYP._HPLAN;
    SET &TYP._COST_CALCS(KEEP=HPLAN);
    BY HPLAN;
    IF LAST.HPLAN;
  RUN;

  PROC SORT DATA=&TYP._COST_CALCS(KEEP=BASEID) NODUPKEY
            OUT=&TYP._BASEID;
    BY BASEID;
  RUN;

%MEND;

%MACRO NOCOST(TYP);
  DATA &TYP._BASEID_NOCOST;
   MERGE &TYP._BASEID(IN=A)
         &INP(IN=B KEEP=BASEID);
  BY BASEID;
  IF NOT A AND B THEN OUTPUT;
  RUN;

  DATA _NULL_;
    NAME = "&TYP._HCNT";
    PUT NAME=;
    CALL SYMPUT(NAME,TRIM(LEFT(PUT(NUMOBS,4.))));
    STOP;
    SET &TYP._HPLAN NOBS=NUMOBS;
    STOP;
  RUN;

  DATA &TYP._NOCOST;
    SET &TYP._BASEID_NOCOST;
    DO I = 1 TO &&&TYP._HCNT;
      SET &TYP._HPLAN POINT=I;
      OUTPUT;
    END;
  RUN;

  DATA &TYP._COST_CALCS_ALL;
    SET &TYP._COST_CALCS(IN=A)
        &TYP._NOCOST(IN=B);
    IF B THEN DO;
      TOTAL_OOPC=0;
    END;
  RUN;

  PROC SORT DATA=&TYP._COST_CALCS_ALL;
    BY HPLAN BASEID;
  RUN;
%MEND;

%MACRO GTNC();

%IF &DSPLAN > 0 %THEN %DO;
  %GETCOUNT(DS);
   RUN;
  %NOCOST(DS);
  RUN;
%END; 
%ELSE %DO;
   DATA DS_COST_CALCS_ALL;
   RUN;
%END;

%IF &DSFORM_FLAG. = 1 %THEN %DO;
  %GETCOUNT(DSFORM);
   RUN;
  %NOCOST(DSFORM);
  RUN;
%END; 
%ELSE %DO;
   DATA DSFORM_COST_CALCS_ALL;
   RUN;
%END;

%IF &AEPLAN > 0 %THEN %DO;
  %GETCOUNT(AE);
  RUN;
  %NOCOST(AE);
  RUN;
%END;
%ELSE %DO;
  DATA AE_COST_CALCS_ALL;
  RUN;
%END;

%IF &BAPLAN > 0 %THEN %DO;
  %GETCOUNT(BA);
  RUN;
  %NOCOST(BA);
  RUN;
%END;  
%ELSE %DO;
  DATA BA_COST_CALCS_ALL;
  RUN;
%END;

%IF &EAPLAN > 0 %THEN %DO;
  %GETCOUNT(EA);
  RUN;
  %NOCOST(EA);
  RUN;
%END;
%ELSE %DO;
  DATA EA_COST_CALCS_ALL;
  RUN;
%END;

%MEND;

%GTNC();

DATA COST_CALCS_ALL;
  LENGTH MRX_TYPE $ 3 CATEGORY $4;
  SET
  %IF &DSPLAN > 0 %THEN %DO;
    DS_COST_CALCS_ALL(IN=A)
  %END;
  %IF &BAPLAN > 0 %THEN %DO;
    BA_COST_CALCS_ALL(IN=B)
   %END;
  %IF &AEPLAN > 0 %THEN %DO;
    AE_COST_CALCS_ALL(IN=C)
  %END;
  %IF &EAPLAN > 0 %THEN %DO;
    EA_COST_CALCS_ALL(IN=D)
  %END;
  %IF &DSFORM_FLAG. = 1 %THEN %DO;
    DSFORM_COST_CALCS_ALL(IN=E)
  %END;    
  ;
  BY HPLAN BASEID;
  %IF &DSPLAN > 0 %THEN %DO;
    IF A THEN MRX_TYPE='DS';
  %END;
  %IF &BAPLAN > 0 %THEN %DO;
    IF B THEN MRX_TYPE='BA';
  %END;
  %IF &AEPLAN > 0 %THEN %DO;
    IF C THEN MRX_TYPE='AE';
  %END;
  %IF &EAPLAN > 0 %THEN %DO;
    IF D THEN MRX_TYPE='EA';
  %END;
  %IF &DSFORM_FLAG. = 1 %THEN %DO;
    IF E THEN MRX_TYPE='DSF';
  %END;  
  CATEGORY='PTD';
  RENAME TOTAL_OOPC = AMTTOT;
  KEEP BASEID HPLAN CATEGORY TOTAL_OOPC MRX_TYPE;
RUN;

PROC SORT DATA=COST_CALCS_ALL;
  BY BASEID HPLAN;
RUN;

DATA BASEID_PLAN_CATEGORY_ALL;
  MERGE COST_CALCS_ALL(IN = A)
        &INP(IN = B KEEP = BASEID INDMON);
  BY BASEID;
  IF A;
  MONTHLY_COST = AMTTOT / INDMON;
  DROP INDMON;
  KEEP BASEID HPLAN CATEGORY AMTTOT MONTHLY_COST;
RUN;

PROC SORT DATA = BASEID_PLAN_CATEGORY_ALL OUT=BASEID_PLAN_CATEGORY_PARTD;
  BY HPLAN CATEGORY;
RUN;

PROC DATASETS;
  DELETE BASEID_PLAN_CATEGORY_ALL;
RUN;
