* PROGRAM NAME: JSON_IMPORT_PBP.SAS;
* DESCRIPTION: IMPORT JSON TABLES;

%MACRO PBP();
PROC SQL;
  CREATE TABLE PBP_JSON AS
  SELECT PBP.CONTRACTID AS PBP_A_CONTRACT_NUMBER, PBP.PLANID AS PBP_A_PLAN_IDENTIFIER, PBP.SEGMENTID AS PBP_A_SEGMENT_ID,
    PBP_PLANCHARACT.HPMSPLANTYPE as PBP_A_PLAN_TYPE,    
    PUT(CAT(PBP.CONTRACTID,PBP.PLANID,PUT(PBP.SEGMENTID,Z3.)),$11.) AS QID,
    (CASE
      WHEN UPCASE(PBP_PLANCHARACT.ISOFFERRX) = 'YES' THEN '1'
      ELSE '2'
    END) AS MRX_DRUG_BEN_YN,
    (CASE
      WHEN UPCASE(PBP_PLANCHARACT.ISNETWORKPLAN) = 'YES' THEN '1'
      ELSE '2'
    END) AS PBP_A_NETWORK_FLAG,    
    (CASE
      WHEN UPCASE(PBP_PLANCHARACT.ORGANIZATIONTYPE) = 'LOCAL CCP' THEN '01'
      WHEN UPCASE(PBP_PLANCHARACT.ORGANIZATIONTYPE) = 'MSA' THEN '02'
      WHEN UPCASE(PBP_PLANCHARACT.ORGANIZATIONTYPE) = 'RFB' THEN '03'
      WHEN UPCASE(PBP_PLANCHARACT.ORGANIZATIONTYPE) = 'PFFS' THEN '04'
      WHEN UPCASE(PBP_PLANCHARACT.ORGANIZATIONTYPE) = 'DEMO' THEN '05'
      WHEN UPCASE(PBP_PLANCHARACT.ORGANIZATIONTYPE) = '1876 COST' THEN '06'
      WHEN UPCASE(PBP_PLANCHARACT.ORGANIZATIONTYPE) = 'HCPP - 1833 COST' THEN '07'
      WHEN UPCASE(PBP_PLANCHARACT.ORGANIZATIONTYPE) = 'NATIONAL PACE' THEN '08'
      WHEN UPCASE(PBP_PLANCHARACT.ORGANIZATIONTYPE) = 'PDP' THEN '10'
      WHEN UPCASE(PBP_PLANCHARACT.ORGANIZATIONTYPE) = 'REGIONAL CCP' THEN '11'
      WHEN UPCASE(PBP_PLANCHARACT.ORGANIZATIONTYPE) = 'FALLBACK' THEN '12'
      WHEN UPCASE(PBP_PLANCHARACT.ORGANIZATIONTYPE) = 'EMPLOYER/UNION ONLY DIRECT CONTRACT PDP' THEN '13'
      WHEN UPCASE(PBP_PLANCHARACT.ORGANIZATIONTYPE) = 'EMPLOYER/UNION ONLY DIRECT CONTRACT PFFS' THEN '14'
      WHEN UPCASE(PBP_PLANCHARACT.ORGANIZATIONTYPE) = 'RFB LOCAL CCP' THEN '15'
      WHEN UPCASE(PBP_PLANCHARACT.ORGANIZATIONTYPE) = 'EMPLOYER/UNION ONLY DIRECT CONTRACT LOCAL CCP' THEN '17'
      ELSE ' '
    END) AS PBP_A_ORG_TYPE     
  FROM JSONLIB.PBP AS PBP,
    JSONLIB.PBP_PLANCHARACT AS PBP_PLANCHARACT
  WHERE (PBP.ORDINAL_PBP = PBP_PLANCHARACT.ORDINAL_PBP)
  AND UPCASE(PBP_PLANCHARACT.ISEMPLOYERONLYPLAN) ^= 'YES'
;
QUIT;
RUN;

%MEND;