
* PROGRAM: COST_SHARING_COMPREHENSIVE_DENTAL.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR COMPREHENSIVE DENTAL CLAIMS;

%MACRO DENTAL_COMP_COST_SHARE(SERV_CAT);

  DATA DENTAL_BASEID;
    RETAIN JOIN_ID '1';
    SET &INC(WHERE=(CATEGORY IN('16')));
    CATEGORY='16c';
  RUN;
  
  DATA DENTAL_FILE;
    SET PBP_FILE (KEEP =
                   CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
                   PBP_B16C_MAXENR_CMP_TYPE
                   PBP_B16C_MAXPLAN_CMP_TYPE 
                   PBP_B16C_MAXENR_CMP_AMT
                   PBP_B16C_MAXENR_CMP_PER
                   PBP_B16C_MAXPLAN_CMP_AMT
                   PBP_B16C_MAXPLAN_CMP_PER
                   PBP_B16C_DED_CMP_AMT                   
                   
                   PBP_B16C_BENDESC_RS_AMO
                   PBP_B16C_BENDESC_END_AMO
                   PBP_B16C_BENDESC_OMSG_AMO
                   PBP_B16C_BENDESC_PERI_AMO
                   PBP_B16C_BENDESC_PRF_AMO
                   PBP_B16C_BENDESC_ORTH_AMO 

                   PBP_B16C_COPAY_RS_AMT
                   PBP_B16C_COPAY_END_AMT
		   PBP_B16C_COPAY_OMSG_AMT
                   PBP_B16C_COPAY_PERI_AMT
                   PBP_B16C_COPAY_PRF_AMT
                   PBP_B16C_COPAY_ORTH_AMT

                   PBP_B16C_COPAY_RS_AMT_MIN
                   PBP_B16C_COPAY_END_AMT_MIN
                   PBP_B16C_COPAY_OMSG_AMT_MIN
                   PBP_B16C_COPAY_PERI_AMT_MIN
                   PBP_B16C_COPAY_PRF_AMT_MIN
                   PBP_B16C_COPAY_ORTH_AMT_MIN

                   PBP_B16C_COINS_RS_PCT
                   PBP_B16C_COINS_END_PCT
		   PBP_B16C_COINS_OMSG_PCT
                   PBP_B16C_COINS_PERI_PCT
                   PBP_B16C_COINS_PRF_PCT
                   PBP_B16C_COINS_ORTH_PCT
                   
                   PBP_B16C_COINS_RS_PCT_MIN
                   PBP_B16C_COINS_END_PCT_MIN
                   PBP_B16C_COINS_OMSG_PCT_MIN
                   PBP_B16C_COINS_PERI_PCT_MIN
                   PBP_B16C_COINS_PRF_PCT_MIN
                   PBP_B16C_COINS_ORTH_PCT_MIN

                   PBP_B16C_BENDESC_RS_NUM
                   PBP_B16C_BENDESC_END_NUM
                   PBP_B16C_BENDESC_OMSG_NUM
                   PBP_B16C_BENDESC_PERI_NUM
                   PBP_B16C_BENDESC_PRF_NUM
                   PBP_B16C_BENDESC_ORTH_NUM

                   PBP_B16C_BENDESC_RS_PER
                   PBP_B16C_BENDESC_END_PER
                   PBP_B16C_BENDESC_OMSG_PER
                   PBP_B16C_BENDESC_PERI_PER
                   PBP_B16C_BENDESC_PRF_PER
                   PBP_B16C_BENDESC_ORTH_PER

                   PBP_A_PLAN_TYPE
                   PBP_D_DIFF_DEDUCT_16C1_N_AMT
                   PBP_D_DIFF_DEDUCT_16C2_N_AMT
                   PBP_D_DIFF_DEDUCT_16C3_N_AMT
                   PBP_D_DIFF_DEDUCT_16C7_N_AMT
                   PBP_D_DIFF_DEDUCT_16C8_N_AMT
                   PBP_D_DIFF_DEDUCT_16C9_N_AMT

                   PBP_D_MAND_DEDUCT_16C1_N_AMT
                   PBP_D_MAND_DEDUCT_16C2_N_AMT
                   PBP_D_MAND_DEDUCT_16C3_N_AMT
                   PBP_D_MAND_DEDUCT_16C7_N_AMT
                   PBP_D_MAND_DEDUCT_16C8_N_AMT
                   PBP_D_MAND_DEDUCT_16C9_N_AMT
                   
                   PBP_B16B_MAXENR_PV_AMT
                   PBP_B16B_MAXENR_PV_PER
	           PBP_B16B_MAXPLAN_PV_AMT 
	           PBP_B16B_MAXPLAN_PV_PER
                   );
    JOIN_ID = '1';

    ARRAY MX PBP_B16C_BENDESC_RS_NUM PBP_B16C_BENDESC_END_NUM PBP_B16C_BENDESC_PRF_NUM 
             PBP_B16C_BENDESC_PERI_NUM PBP_B16C_BENDESC_OMSG_NUM PBP_B16C_BENDESC_ORTH_NUM 
             PBP_B16C_MAXPLAN_CMP_AMT PBP_B16B_MAXENR_PV_AMT PBP_B16B_MAXPLAN_PV_AMT
             PBP_B16C_MAXENR_CMP_AMT;
             
    ARRAY PX PBP_B16C_BENDESC_RS_PER PBP_B16C_BENDESC_END_PER PBP_B16C_BENDESC_PRF_PER 
             PBP_B16C_BENDESC_PERI_PER PBP_B16C_BENDESC_OMSG_PER PBP_B16C_BENDESC_ORTH_PER 
             PBP_B16C_MAXPLAN_CMP_PER PBP_B16B_MAXENR_PV_PER PBP_B16B_MAXPLAN_PV_PER
             PBP_B16C_MAXENR_CMP_PER;

    DO I = 1 TO 10;
      IF MX(I) NE . THEN DO;
        IF PX(I)  = '1' THEN MX(I) = MX(I)  / 3;       * EVERY THREE YEARS;
        ELSE IF PX(I)  = '2' THEN MX(I) = MX(I)  / 2;  * EVERY TWO YEARS;
        ELSE IF PX(I)  = '3' THEN MX(I) = MX(I) / 1;   * EVERY YEAR;
        ELSE IF PX(I)  = '4' THEN MX(I) = MX(I)  * 2;  * EVERY SIX MONTHS;
        ELSE IF PX(I)  = '5' THEN MX(I) = MX(I)  * 4;  * EVERY THREE MONTHS;
        ELSE IF PX(I)  = '6' THEN MX(I) = MX(I) ;      * OTHER;
        ELSE IF PX(I)  = '7' THEN MX(I) = MX(I)  * 12; * EVERY MONTH;
      END;
    END;
  RUN;

  PROC SQL;
    CREATE TABLE CAT_JOIN AS
      (SELECT B.CATEGORY, B.BASEID, B.YEAR, B.VISITS, B.AMTTOT, B.DVFILLNG,
      B.DVPERIOD, B.DVEXTRAC, B.DVRTCNAL, B.DVCROWN, B.DVBRIDGE, B.DVORTHO, B.PREVENT_DENTAL_SHARE, P.*
      FROM DENTAL_BASEID B, DENTAL_FILE P
      WHERE B.JOIN_ID = P.JOIN_ID)
      ORDER BY HPLAN, BASEID, YEAR, CATEGORY;
    QUIT;
  RUN;

  DATA CAT_JOIN;
    MERGE CAT_JOIN (IN = A) 
          PBPCATS_MCCOST_DED (IN = B WHERE=(CATEGORY IN ('16c')));
    BY HPLAN BASEID YEAR CATEGORY;
    IF A;
    LENGTH PLAN_DED_CAT $1;
    IF B THEN PLAN_DED_CAT='1';
    ELSE PLAN_DED_CAT='0';
  RUN;

  DATA &SERV_CAT; 
    ARRAY MX PBP_B16C_BENDESC_RS_NUM 
             PBP_B16C_BENDESC_END_NUM 
             PBP_B16C_BENDESC_PRF_NUM 
             PBP_B16C_BENDESC_PERI_NUM 
             PBP_B16C_BENDESC_OMSG_NUM 
             PBP_B16C_BENDESC_ORTH_NUM
             PBP_B16C_MAXENR_CMP_AMT
             PBP_B16C_MAXPLAN_CMP_AMT
	     PBP_B16B_MAXENR_PV_AMT
	     PBP_B16B_MAXPLAN_PV_AMT; 
             
    ARRAY SX SERVICE_MAX_RS 
             SERVICE_MAX_END 
             SERVICE_MAX_PRF 
             SERVICE_MAX_PERI 
             SERVICE_MAX_OMSG 
             SERVICE_MAX_ORTH
             BENE_MAXIMUM_C
             PLAN_MAXIMUM_C
	     BENE_MAXIMUM_P
	     PLAN_MAXIMUM_P;
             
    SET CAT_JOIN (DROP = JOIN_ID);

    COMP_SERVICE_CNT = SUM(DVFILLNG, DVPERIOD, DVEXTRAC, DVRTCNAL, DVCROWN, DVBRIDGE, DVORTHO);
    IF COMP_SERVICE_CNT>0;

    IF DVFILLNG > 0 THEN DO;
      MAND_DEDUCT_DVFILLNG = PBP_D_MAND_DEDUCT_16C1_N_AMT;
      DIFF_DEDUCT_DVFILLNG = PBP_D_DIFF_DEDUCT_16C1_N_AMT;
    END;
    ELSE DO;
      MAND_DEDUCT_DVFILLNG = 0;
      DIFF_DEDUCT_DVFILLNG = 0;
    END;
    IF DVPERIOD > 0 THEN DO;
      MAND_DEDUCT_DVPERIOD = PBP_D_MAND_DEDUCT_16C3_N_AMT;
      DIFF_DEDUCT_DVPERIOD = PBP_D_DIFF_DEDUCT_16C3_N_AMT; 
    END;
    ELSE DO;
      MAND_DEDUCT_DVPERIOD = 0;
      DIFF_DEDUCT_DVPERIOD = 0; 
    END;
    IF DVEXTRAC > 0 THEN DO;
      MAND_DEDUCT_DVEXTRAC = PBP_D_MAND_DEDUCT_16C8_N_AMT;
      DIFF_DEDUCT_DVEXTRAC = PBP_D_DIFF_DEDUCT_16C8_N_AMT;
    END;
    ELSE DO;
      MAND_DEDUCT_DVEXTRAC = 0;
      DIFF_DEDUCT_DVEXTRAC = 0;    
    END;
    IF DVRTCNAL > 0 THEN DO;
      MAND_DEDUCT_DVRTCNAL = PBP_D_MAND_DEDUCT_16C2_N_AMT;
      DIFF_DEDUCT_DVRTCNAL = PBP_D_DIFF_DEDUCT_16C2_N_AMT;
    END;
    ELSE DO;
      MAND_DEDUCT_DVRTCNAL = 0;
      DIFF_DEDUCT_DVRTCNAL = 0;   
    END;
    IF DVCROWN > 0 | DVBRIDGE > 0 THEN DO;
      MAND_DEDUCT_DVCROWN_DVBRIDGE = PBP_D_MAND_DEDUCT_16C7_N_AMT;
      DIFF_DEDUCT_DVCROWN_DVBRIDGE = PBP_D_DIFF_DEDUCT_16C7_N_AMT;
    END;
    ELSE DO;
      MAND_DEDUCT_DVCROWN_DVBRIDGE = 0;
      DIFF_DEDUCT_DVCROWN_DVBRIDGE = 0;    
    END;
    IF DVORTHO > 0 THEN DO;
      MAND_DEDUCT_DVORTHO = PBP_D_MAND_DEDUCT_16C9_N_AMT;
      DIFF_DEDUCT_DVORTHO = PBP_D_DIFF_DEDUCT_16C9_N_AMT;
    END;
    ELSE DO;
      MAND_DEDUCT_DVORTHO = 0;
      DIFF_DEDUCT_DVORTHO = 0;
    END;
      
    PBP_D_DEDUCT_COMPDENTAL_AMT=SUM(MAND_DEDUCT_DVFILLNG,MAND_DEDUCT_DVPERIOD,MAND_DEDUCT_DVEXTRAC,
      MAND_DEDUCT_DVRTCNAL,MAND_DEDUCT_DVCROWN_DVBRIDGE,MAND_DEDUCT_DVORTHO);

    PBP_D_DIFF_COMPDENTAL_AMT=SUM(DIFF_DEDUCT_DVFILLNG,DIFF_DEDUCT_DVPERIOD,DIFF_DEDUCT_DVEXTRAC,
      DIFF_DEDUCT_DVRTCNAL,DIFF_DEDUCT_DVCROWN_DVBRIDGE,DIFF_DEDUCT_DVORTHO);
    
    IF PLAN_DED_CAT='1' THEN DO;
      IF PLAN_DEDUCT_PTB>0 THEN CAT_DEDUCTIBLE=PLAN_DEDUCT_PTB;
      ELSE CAT_DEDUCTIBLE=PLAN_DED_AMTTOT;
    END;
    ELSE IF PBP_A_PLAN_TYPE IN('04','31','44','47') THEN 
      CAT_DEDUCTIBLE=PBP_D_DIFF_COMPDENTAL_AMT;
    ELSE CAT_DEDUCTIBLE=PBP_B16C_DED_CMP_AMT;

    COST=0;
    CAT_DEDUCTIBLE_SUP=0;
    IF PBP_D_DEDUCT_COMPDENTAL_AMT>0 THEN CAT_DEDUCTIBLE_SUP=PBP_D_DEDUCT_COMPDENTAL_AMT;

    DO I = 1 TO 10;
      IF MX(I) NE . THEN DO;
       SX(I) = MX(I);
      END;
    END;

    NONCOV_COST = 0;

    COMP_SERVICE_CNT = SUM(DVFILLNG,DVPERIOD,DVEXTRAC,DVRTCNAL,DVCROWN,DVBRIDGE,DVORTHO);
     
    AMTTOT_PREV = PREVENT_DENTAL_SHARE * AMTTOT; 
    AMTTOT_COMP = (1-PREVENT_DENTAL_SHARE) * AMTTOT;

    PER_SERVICE_AMT = AMTTOT_COMP / COMP_SERVICE_CNT;

    IF SUM(AMTTOT_PREV,AMTTOT_COMP)>0 THEN 
      COMPREHENSIVE_SHARE=(1-PREVENT_DENTAL_SHARE);
    ELSE COMPREHENSIVE_SHARE=0;
      
    IF PBP_B16C_MAXPLAN_CMP_TYPE = '1' THEN PLAN_MAXIMUM_C=PLAN_MAXIMUM_P*COMPREHENSIVE_SHARE;

    ARRAY DC DVPERIOD DVEXTRAC DVRTCNAL DVCROWN DVBRIDGE DVORTHO DVFILLNG;
        
    IF AMTTOT_COMP <= SUM(CAT_DEDUCTIBLE,CAT_DEDUCTIBLE_SUP) THEN DO;
      NONCOV_COST = SUM(NONCOV_COST,AMTTOT_COMP);
      DO OVER DC;
        DC = 0;
      END;
    END;
    ELSE IF CAT_DEDUCTIBLE > 0 THEN DO;
      NONCOV_COST = SUM(NONCOV_COST,SUM(CAT_DEDUCTIBLE,CAT_DEDUCTIBLE_SUP));
      DED_SHARE = SUM(CAT_DEDUCTIBLE,CAT_DEDUCTIBLE_SUP) / AMTTOT_COMP;
      AMTTOT_COMP = SUM(AMTTOT_COMP,-(SUM(CAT_DEDUCTIBLE,CAT_DEDUCTIBLE_SUP)));
      DO OVER DC;
        DC = DC * (1 - DED_SHARE);
      END;
    END;
      
    * APPLY SERVICE COUNT MAX FIRST;
    IF SERVICE_MAX_RS > 0 AND SERVICE_MAX_RS < DVFILLNG THEN DO;
      NONCOV_COST = SUM(NONCOV_COST,SUM(DVFILLNG,-SERVICE_MAX_RS) * PER_SERVICE_AMT);
      DVFILLNG = SERVICE_MAX_RS;
    END;
    IF SERVICE_MAX_END > 0 AND SERVICE_MAX_END < DVRTCNAL THEN DO;
      NONCOV_COST = SUM(NONCOV_COST,SUM(DVRTCNAL,-SERVICE_MAX_END) * PER_SERVICE_AMT);
      DVRTCNAL_OLD = DVRTCNAL;
      DVRTCNAL = SERVICE_MAX_END * (DVRTCNAL/DVRTCNAL_OLD);
    END;
    IF SERVICE_MAX_OMSG > 0 AND SERVICE_MAX_OMSG < DVEXTRAC THEN DO;
      NONCOV_COST = SUM(NONCOV_COST,SUM(DVEXTRAC,-SERVICE_MAX_OMSG) * PER_SERVICE_AMT);
      DVEXTRAC_OLD = DVEXTRAC;
      DVEXTRAC = SERVICE_MAX_OMSG * (DVEXTRAC/DVEXTRAC_OLD);
    END;
    IF SERVICE_MAX_PERI > 0 AND SERVICE_MAX_PERI < DVPERIOD THEN DO;
      NONCOV_COST = SUM(NONCOV_COST,SUM(DVPERIOD,-SERVICE_MAX_PERI) * PER_SERVICE_AMT);
      DVPERIOD_OLD = DVPERIOD;
      DVPERIOD = SERVICE_MAX_PERI * (DVPERIOD/DVPERIOD_OLD);
    END;      
    IF SERVICE_MAX_PRF > 0 AND SERVICE_MAX_PRF < SUM(DVCROWN,DVBRIDGE) THEN DO;
      NONCOV_COST = SUM(NONCOV_COST,SUM(DVCROWN,DVBRIDGE, -SERVICE_MAX_PRF) * PER_SERVICE_AMT);
      DVCROWN_OLD = DVCROWN;
      DVBRIDGE_OLD = DVBRIDGE;
      DVCROWN = SERVICE_MAX_PRF * (DVCROWN/SUM(DVCROWN_OLD,DVBRIDGE_OLD));
      DVBRIDGE = SERVICE_MAX_PRF * (DVBRIDGE/SUM(DVCROWN_OLD,DVBRIDGE_OLD));
    END;
     
    IF SERVICE_MAX_ORTH > 0 AND SERVICE_MAX_ORTH < DVORTHO THEN DO;
      NONCOV_COST = SUM(NONCOV_COST,SUM(DVORTHO,-SERVICE_MAX_ORTH) * PER_SERVICE_AMT);
      DVORTHO_OLD = DVORTHO;
      DVORTHO = SERVICE_MAX_ORTH * (DVORTHO/DVORTHO_OLD);
    END;

    COMP_SERVICE_CNT = SUM(DVFILLNG, DVPERIOD, DVEXTRAC, DVRTCNAL, DVCROWN, DVBRIDGE, DVORTHO);
    AMTTOT_COMP = COMP_SERVICE_CNT * PER_SERVICE_AMT;

    NONCOV_COST_MAXDOL = 0;
    NONCOV_COST_MAXDOL_C = 0;

    * APPLY PLAN MAXIMUM;
    IF PBP_B16C_MAXPLAN_CMP_TYPE = '1' THEN DO;
      NONCOV_COST_MAXDOL = SUM(NONCOV_COST_MAXDOL,MAX(0,SUM(AMTTOT_COMP,-PLAN_MAXIMUM_C)));
        
      IF AMTTOT_COMP>0 THEN 
        COVERED_SHARE_C = SUM(AMTTOT_COMP,-NONCOV_COST_MAXDOL)/AMTTOT_COMP;

      DO OVER DC;
        DC = DC * COVERED_SHARE_C;
      END;
    END;
    ELSE DO;
      IF PLAN_MAXIMUM_C > 0 THEN NONCOV_COST_MAXDOL_C = MAX(0,SUM(AMTTOT_COMP,-PLAN_MAXIMUM_C));

      NONCOV_COST_MAXDOL = NONCOV_COST_MAXDOL_C;

      IF AMTTOT_COMP > 0 THEN
        COVERED_SHARE_C = SUM(AMTTOT_COMP,-NONCOV_COST_MAXDOL_C) / AMTTOT_COMP;
      
      DO OVER DC;
        DC = DC * COVERED_SHARE_C;
      END;
    END;
     
    *APPLY INDIVIDUAL COSTS FOR COMP BENEFITS;
   
    ENDO_COST_SHARE = 0;
    
    IF DVEXTRAC > 0 THEN DO;
      IF PBP_B16C_COINS_OMSG_PCT > 0 THEN COINS_OMSG_PCT = PBP_B16C_COINS_OMSG_PCT;
      ELSE IF PBP_B16C_COINS_OMSG_PCT_MIN > 0 THEN COINS_OMSG_PCT = PBP_B16C_COINS_OMSG_PCT_MIN;
      ELSE COINS_OMSG_PCT = 0;
        
      IF PBP_B16C_COPAY_OMSG_AMT > 0 THEN COPAY_OMSG_AMT = PBP_B16C_COPAY_OMSG_AMT;
      ELSE IF PBP_B16C_COPAY_OMSG_AMT_MIN > 0 THEN COPAY_OMSG_AMT = PBP_B16C_COPAY_OMSG_AMT_MIN;
      ELSE COPAY_OMSG_AMT = 0;
        
      IF PBP_B16C_BENDESC_OMSG_AMO IN('2','4') THEN DO;
        ENDO_COST_SHARE = SUM(ENDO_COST_SHARE,PER_SERVICE_AMT*DVEXTRAC*COINS_OMSG_PCT);
        ENDO_COST_SHARE = SUM(ENDO_COST_SHARE,COPAY_OMSG_AMT*DVEXTRAC);
      END;
      ELSE DO;
        ENDO_OTHER_COST = PER_SERVICE_AMT * DVEXTRAC;
      END;
    END;

    IF DVRTCNAL > 0 THEN DO;
      IF PBP_B16C_COINS_END_PCT > 0 THEN COINS_END_PCT = PBP_B16C_COINS_END_PCT;
      ELSE IF PBP_B16C_COINS_END_PCT_MIN > 0 THEN COINS_END_PCT = PBP_B16C_COINS_END_PCT_MIN;
      ELSE COINS_END_PCT = 0;
        
      IF PBP_B16C_COPAY_END_AMT > 0 THEN COPAY_END_AMT = PBP_B16C_COPAY_END_AMT;
      ELSE IF PBP_B16C_COPAY_END_AMT_MIN > 0 THEN COPAY_END_AMT = PBP_B16C_COPAY_END_AMT_MIN;
      ELSE COPAY_END_AMT = 0;
      
      IF PBP_B16C_BENDESC_END_AMO IN('2','4') THEN DO;
        ENDO_COST_SHARE = SUM(ENDO_COST_SHARE,PER_SERVICE_AMT*DVRTCNAL*COINS_END_PCT);
        ENDO_COST_SHARE = SUM(ENDO_COST_SHARE,COPAY_END_AMT*DVRTCNAL);
      END;
      ELSE DO;
        ENDO_OTHER_COST = SUM(ENDO_OTHER_COST,PER_SERVICE_AMT * DVRTCNAL);
      END;
    END;

    IF DVPERIOD > 0 THEN DO;
      IF PBP_B16C_COINS_PERI_PCT > 0 THEN COINS_PERI_PCT = PBP_B16C_COINS_PERI_PCT;
      ELSE IF PBP_B16C_COINS_PERI_PCT_MIN > 0 THEN COINS_PERI_PCT = PBP_B16C_COINS_PERI_PCT_MIN;
      ELSE COINS_PERI_PCT = 0;
        
      IF PBP_B16C_COPAY_PERI_AMT > 0 THEN COPAY_PERI_AMT = PBP_B16C_COPAY_PERI_AMT;
      ELSE IF PBP_B16C_COPAY_PERI_AMT_MIN > 0 THEN COPAY_PERI_AMT = PBP_B16C_COPAY_PERI_AMT_MIN;
      ELSE COPAY_PERI_AMT = 0;
        
      IF PBP_B16C_BENDESC_PERI_AMO IN('2','4') THEN DO;
        ENDO_COST_SHARE = SUM(ENDO_COST_SHARE,PER_SERVICE_AMT*DVPERIOD*COINS_PERI_PCT);
        ENDO_COST_SHARE = SUM(ENDO_COST_SHARE,COPAY_PERI_AMT*DVPERIOD);
      END;
      ELSE DO;
        ENDO_OTHER_COST = SUM(ENDO_OTHER_COST,PER_SERVICE_AMT * DVPERIOD);
      END;
    END;      
  
    FILL_COST_SHARE = 0;
      
    IF DVFILLNG > 0 THEN DO;
      IF PBP_B16C_COINS_RS_PCT > 0 THEN COINS_RS_PCT = PBP_B16C_COINS_RS_PCT;
      ELSE IF PBP_B16C_COINS_RS_PCT_MIN > 0 THEN COINS_RS_PCT = PBP_B16C_COINS_RS_PCT_MIN;
      ELSE COINS_RS_PCT = 0;
        
      IF PBP_B16C_COPAY_RS_AMT > 0 THEN COPAY_RS_AMT = PBP_B16C_COPAY_RS_AMT;
      ELSE IF PBP_B16C_COPAY_RS_AMT_MIN > 0 THEN COPAY_RS_AMT = PBP_B16C_COPAY_RS_AMT_MIN;
      ELSE COPAY_RS_AMT = 0;
        
      IF PBP_B16C_BENDESC_RS_AMO IN('2','4') THEN DO;
        FILL_COST_SHARE = SUM(FILL_COST_SHARE,PER_SERVICE_AMT*DVFILLNG*COINS_RS_PCT);
        FILL_COST_SHARE = SUM(FILL_COST_SHARE,COPAY_RS_AMT*DVFILLNG);
      END;
      ELSE DO;
        FILL_OTHER_COST = PER_SERVICE_AMT * DVFILLNG;
      END;
    END;

    PROS_COST_SHARE = 0;
      
    IF DVCROWN > 0 THEN DO;
      IF PBP_B16C_COINS_PRF_PCT > 0 THEN COINS_PRF_PCT = PBP_B16C_COINS_PRF_PCT;
      ELSE IF PBP_B16C_COINS_PRF_PCT_MIN > 0 THEN COINS_PRF_PCT = PBP_B16C_COINS_PRF_PCT_MIN;
      ELSE COINS_PRF_PCT = 0;
        
      IF PBP_B16C_COPAY_PRF_AMT > 0 THEN COPAY_PRF_AMT = PBP_B16C_COPAY_PRF_AMT;
      ELSE IF PBP_B16C_COPAY_PRF_AMT_MIN > 0 THEN COPAY_PRF_AMT = PBP_B16C_COPAY_PRF_AMT_MIN;
      ELSE COPAY_PRF_AMT = 0;
        
      IF PBP_B16C_BENDESC_PRF_AMO IN('2','4') THEN DO;
        PROS_COST_SHARE = SUM(PROS_COST_SHARE,PER_SERVICE_AMT*DVCROWN*COINS_PRF_PCT);
        PROS_COST_SHARE = SUM(PROS_COST_SHARE,COPAY_PRF_AMT*DVCROWN);
      END;
      ELSE DO;
        PROS_OTHER_COST = PER_SERVICE_AMT * DVCROWN;
      END;
    END;

    IF DVBRIDGE > 0 THEN DO;
      IF PBP_B16C_COINS_PRF_PCT > 0 THEN COINS_PRF_PCT = PBP_B16C_COINS_PRF_PCT;
      ELSE IF PBP_B16C_COINS_PRF_PCT_MIN > 0 THEN COINS_PRF_PCT = PBP_B16C_COINS_PRF_PCT_MIN;
      ELSE COINS_PRF_PCT = 0;
              
      IF PBP_B16C_COPAY_PRF_AMT > 0 THEN COPAY_PRF_AMT = PBP_B16C_COPAY_PRF_AMT;
      ELSE IF PBP_B16C_COPAY_PRF_AMT_MIN > 0 THEN COPAY_PRF_AMT = PBP_B16C_COPAY_PRF_AMT_MIN;
      ELSE COPAY_PRF_AMT = 0;
        
      IF PBP_B16C_BENDESC_PRF_AMO IN('2','4') THEN DO;
        PROS_COST_SHARE = SUM(PROS_COST_SHARE,PER_SERVICE_AMT*DVBRIDGE*COINS_PRF_PCT);
        PROS_COST_SHARE = SUM(PROS_COST_SHARE,COPAY_PRF_AMT*DVBRIDGE);
      END;
      ELSE DO;
        PROS_OTHER_COST = SUM(PROS_OTHER_COST,PER_SERVICE_AMT * DVBRIDGE);
      END;
    END;

    IF DVORTHO > 0 THEN DO;
      IF PBP_B16C_COINS_ORTH_PCT > 0 THEN COINS_ORTH_PCT = PBP_B16C_COINS_ORTH_PCT;
      ELSE IF PBP_B16C_COINS_ORTH_PCT_MIN > 0 THEN COINS_ORTH_PCT = PBP_B16C_COINS_ORTH_PCT_MIN;
      ELSE COINS_ORTH_PCT = 0;
        
      IF PBP_B16C_COPAY_ORTH_AMT > 0 THEN COPAY_ORTH_AMT = PBP_B16C_COPAY_ORTH_AMT;
      ELSE IF PBP_B16C_COPAY_ORTH_AMT_MIN > 0 THEN COPAY_ORTH_AMT = PBP_B16C_COPAY_ORTH_AMT_MIN;
      ELSE COPAY_ORTH_AMT = 0;
        
      IF PBP_B16C_BENDESC_ORTH_AMO IN('2','4') THEN DO;
        PROS_COST_SHARE = SUM(PROS_COST_SHARE,PER_SERVICE_AMT*DVORTHO*COINS_ORTH_PCT);
        PROS_COST_SHARE = SUM(PROS_COST_SHARE,COPAY_ORTH_AMT*DVORTHO);
      END;
      ELSE DO;
        PROS_OTHER_COST = SUM(PROS_OTHER_COST,PER_SERVICE_AMT * DVORTHO);
      END;
    END;

    COST_SHARE_COST_C = SUM(ENDO_COST_SHARE,FILL_COST_SHARE,PROS_COST_SHARE);

    OTHER_COST = SUM(ENDO_OTHER_COST, FILL_OTHER_COST, PROS_OTHER_COST, NONCOV_COST, NONCOV_COST_MAXDOL);
      
    COST_SHARE_COST_AMO = COST_SHARE_COST_C;
   
    IF BENE_MAXIMUM_C > 0 & COST_SHARE_COST_AMO >0 THEN DO;
      COST_SHARE_COST_AMO = MIN(COST_SHARE_COST_AMO,BENE_MAXIMUM_C);
    END;
   
    COST_SHARE_COST = COST_SHARE_COST_AMO;
    COST = 0;
    COST_SHARE_COST_MC = 0;
        
    CATEGORY = "16c";

  RUN;
  
  PROC APPEND DATA=DENTAL(KEEP=HPLAN YEAR BASEID COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
     OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
  RUN;

  PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
    DELETE DENTAL DENTAL_BASEID DENTAL_FILE CAT_JOIN;
    QUIT;
  RUN;

%MEND;



