* PROGRAM: OOPCV1M.SAS;
* DESCRIPTION: MAIN MACRO THAT CALLS OTHER PROGRAMS;

%INCLUDE IN0(CLEANUP.SAS);
RUN;

%INCLUDE IN0(ANNUALIZATION.SAS);
RUN;

%MACRO OOPCV1M(RUNYEAR=, INP=, INC=, CATEG=, PBP=, FORMULARY=, PLANFILE=, OOPC=);

  %IF &INPUT = INPUTPLAN %THEN %DO;
    %INCLUDE IN0(JSON_IMPORT.SAS)/SOURCE2;
  %END;

  %IF &INPUT = INPUTPLAN %THEN %DO;
    %INCLUDE IN0(PBP_IMPORT.SAS)/SOURCE2;

  %END;

  %ELSE %IF &INPUT = INPUTCMS %THEN %DO;
    %INCLUDE IN0(PBP_IMPORT_CMS.SAS)/SOURCE2;
    RUN;
  %END;
 
  %IF &MAPD > 0 OR &MAON > 0 OR &MSA > 0 OR &FFS > 0 OR &MGAP > 0 %THEN %DO;

    DATA COSTDATA;
      LENGTH HPLAN $11 YEAR $4 BASEID $8 CATEGORY $6 COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
        OTHER_COST COST AMTTOT 8;
      RETAIN HPLAN YEAR BASEID CATEGORY ' ' COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
        OTHER_COST COST AMTTOT .;
      OUTPUT;
    RUN;
  
    DATA PBP_FILE_COMPLETE;
      SET PBP_FILE;
    RUN;

    DATA PBP_FILE;
      SET PBP_FILE;
      IF PUT(HPLAN,$TYPEF.)='PDP' THEN DELETE;
    RUN;
  
    %INCLUDE IN0(PLAN_DEDUCTIBLE.SAS);
    RUN;
  
    %INCLUDE IN0(COST_SHARING_AMBULANCE.SAS);
    %AMBULANCE_COST_SHARE(AMBULANCE);
    RUN;

    %INCLUDE IN0(COST_SHARING_ASC.SAS);
    %ASC_COST_SHARE(ASC);
    RUN;

    %INCLUDE IN0(COST_SHARING_CARDIAC_REHAB.SAS);
    %CARD_COST_SHARE(CARD);
    RUN;

    %INCLUDE IN0(COST_SHARING_CHIROPRACTIC.SAS);
    %CHIRO_COST_SHARE(CHIRO);
    RUN;

    %INCLUDE IN0(COST_SHARING_COMP_XRAY.SAS);
    %COMPXRAY_COST_SHARE(COMPXRAY);
    RUN;
  
    %INCLUDE IN0(COST_SHARING_PREVENTIVE_DENTAL.SAS);
    %DENTAL_PREV_COST_SHARE(DENTAL);
    RUN;
 
    %INCLUDE IN0(COST_SHARING_EDUCATION_DIABETES.SAS);
    %DIAB_COST_SHARE(DIAB);
    RUN;

    %INCLUDE IN0(COST_SHARING_DIAG.SAS);
    %DIAG_COST_SHARE(DIAG);
    RUN;

    %INCLUDE IN0(COST_SHARING_DIALYSIS.SAS);
    %DIALYSIS_COST_SHARE(DIALYSIS);
    RUN;

    %INCLUDE IN0(COST_SHARING_DME.SAS);
    %DME_COST_SHARE(DME);
    RUN;

    %INCLUDE IN0(COST_SHARING_ER.SAS);
    %ER_COST_SHARE(ER);
    RUN;

    %INCLUDE IN0(COST_SHARING_EYEEXAMS.SAS);
    %EYEEXAMS_COST_SHARE(EYEEXAMS);
    RUN;

    %INCLUDE IN0(COST_SHARING_HEARINGEXAMS.SAS);
    %HEARINGEXAMS_COST_SHARE(HEARINGEXAMS);
    RUN;

    %INCLUDE IN0(COST_SHARING_HHA.SAS);
    %HHA_COST_SHARE(HHA);
    RUN;

    %INCLUDE IN0(COST_SHARING_INPATIENT_ACUTE.SAS);
    %INPAT_ACUTE(INPATIENT_ACUTE);
    RUN;

    %INCLUDE IN0(COST_SHARING_INPATIENT_PSYCH.SAS);
    %INPAT_PSYCH(INPATIENT_PSYCH);
    RUN;

    %INCLUDE IN0(COST_SHARING_LAB.SAS);
    %LAB_COST_SHARE(LAB);
    RUN;

    %INCLUDE IN0(COST_SHARING_COMPREHENSIVE_DENTAL.SAS);
    %DENTAL_COMP_COST_SHARE(DENTAL);
    RUN;
    
    %INCLUDE IN0(COST_SHARING_MEDICARE_DENTAL.SAS);
    %DENTAL_MED_COST_SHARE(DENTAL);
    RUN;    

    %INCLUDE IN0(COST_SHARING_MEDICARE_DRUGS.SAS);
    %MDRUGS_COST_SHARE(MDRUGS);
    RUN;
  
    %INCLUDE IN0(COST_SHARING_MEDICARE_DRUGS_CHEMO.SAS);
    %CHEMO_COST_SHARE(CHEMO);
    RUN;
    
    %INCLUDE IN0(COST_SHARING_MEDICARE_BDRUGS_INSULIN.SAS);
    %IDRUGS_COST_SHARE(IDRUGS);
    RUN;    
  
    %INCLUDE IN0(COST_SHARING_MNTLHLTH.SAS);
    %MNTLHLTH_COST_SHARE(MNTLHLTH);
    RUN;
   
    %INCLUDE IN0(COST_SHARING_ORTHOTICS.SAS);
    %ORTHOTICS_COST_SHARE(ORTHOTICS);
    RUN;

    %INCLUDE IN0(COST_SHARING_OT.SAS);
    %OT_COST_SHARE(OT);
    RUN;

    %INCLUDE IN0(COST_SHARING_OTHER.SAS);
    %OTHER_COST_SHARE(OTHER);
    RUN;

    %INCLUDE IN0(COST_SHARING_OUTPAT.SAS);
    %OUTPAT_COST_SHARE(OUTPAT);
    RUN;

    %INCLUDE IN0(COST_SHARING_PCP.SAS);
    %PCP_COST_SHARE(PCP);
    RUN;

    %INCLUDE IN0(COST_SHARING_PODIATRY.SAS);
    %PODIATRY_COST_SHARE(PODIATRY);
    RUN;

    %INCLUDE IN0(COST_SHARING_PSYCH.SAS);
    %PSYCH_COST_SHARE(PSYCH);
    RUN;

    %INCLUDE IN0(COST_SHARING_PT.SAS);
    %PT_COST_SHARE(PT);
    RUN;

    %INCLUDE IN0(COST_SHARING_PULMONARY_REHAB.SAS);
    %PULM_COST_SHARE(PULM);
    RUN;

    %INCLUDE IN0(COST_SHARING_RADIATION.SAS);
    %RADIATION_COST_SHARE(RADIATION);
    RUN;
    
    %INCLUDE IN0(COST_SHARING_SET_PAD.SAS);
    %SETPAD_COST_SHARE(SETPAD);
    RUN;    

    %INCLUDE IN0(COST_SHARING_SNF.SAS);
    %SNF_COST_SHARE(SNF);
    RUN;
 
    %INCLUDE IN0(COST_SHARING_SPECIALIST.SAS);
    %SPECIALIST_COST_SHARE(SPECIALIST);
    RUN;

    %INCLUDE IN0(COST_SHARING_SUPPLIES.SAS);
    %SUPPLIES_COST_SHARE(SUPPLIES);
    RUN;

    %INCLUDE IN0(COST_SHARING_URGENT_CARE.SAS);
    %URGENT_COST_SHARE(URGENT);
    RUN;

    %INCLUDE IN0(COST_SHARING_XRAY.SAS);
    %XRAY_COST_SHARE(XRAY);
    RUN;

    %INCLUDE IN0(COST_SHARING_OPIOID.SAS);
    %OPIOID_COST_SHARE(OPIOID);
    RUN;   
  
    DATA PBP_FILE;
      SET PBP_FILE_COMPLETE;
    RUN;
  
    %INCLUDE IN0(PBPCATS.SAS)/SOURCE2;
    RUN;

    %INCLUDE IN0(MISSING_CELLS_YEAR.SAS)/SOURCE2;
    RUN;
  
    %INCLUDE IN0(BASEID_PLAN_YEAR.SAS)/SOURCE2;
    RUN;

    %INCLUDE IN0(PLAN_CATNAME_NEW.SAS)/SOURCE2;
    RUN; 
  
  %END;

%MEND;

