* PROGRAM: PBP_IMPORT.SAS;
* DESCRIPTION: IMPORT THE INDIVIDUAL PBP TABLES AND MERGE TOGETHER;

LIBNAME LIBRARY "&INPUTDIR";

%MACRO PLANS;
  %IF "&PLANFILE" NE "" %THEN %DO;
    DATA PLANFILE;
      INFILE "&PLANFILE";
      INPUT @1 HPLAN $CHAR11.;
    RUN;
  %END;
  %ELSE %DO;
    DATA PLANFILE;
      STOP;
    RUN;
  %END;
%MEND;

%PLANS;
RUN;

DATA _NULL_;
  CALL SYMPUT('NUM',TRIM(LEFT(PUT(NUMOBS,4.))));
  STOP;
  SET PLANFILE NOBS=NUMOBS;
  STOP;
RUN;

%MACRO FMT;
  %IF &NUM > 0 %THEN %DO;
    DATA HPLAN_FMT (KEEP=START LABEL HLO FMTNAME);
      SET PLANFILE (RENAME=HPLAN=START) END=LAST;
      LENGTH FMTNAME $8 LABEL $3 HLO $1;
      FMTNAME='$HPLANF';
      LABEL='YES';
      HLO=' ';
      OUTPUT;
      IF LAST THEN DO;
        START='OTHER';
        LABEL='NO';
        HLO='O';
        OUTPUT;
      END;
    RUN;
  %END;
  %ELSE %DO;
    DATA HPLAN_FMT (KEEP=START LABEL HLO FMTNAME);
      LENGTH FMTNAME $8 LABEL $3 HLO $1;
      FMTNAME='$HPLANF';
      START='OTHER';
      LABEL='YES';
      HLO='O';
      OUTPUT;
    RUN;
  %END;
  RUN;
%MEND;

%FMT;
RUN;

PROC FORMAT CNTLIN=HPLAN_FMT LIB=LIBRARY;
RUN;

DATA PBPPLANS;
  SET PBP_JSON;
  IF PUT(QID,$HPLANF.) = 'YES';
RUN;

PROC SORT DATA=PBPPLANS;
  BY QID;
RUN;

DATA PBPPLANS MAPD MAON PDP MSA FFS MGAP;
  SET PBPPLANS; 
  LENGTH TYPE $4;
  IF PBP_A_PLAN_TYPE IN('29','30','32') THEN TYPE = 'PDP';
  ELSE TYPE = 'MAPD';
  IF TYPE = 'MAPD' THEN DO;
    IF MRX_DRUG_BEN_YN = '2' THEN TYPE = 'MAON';
  END;
  IF PBP_A_ORG_TYPE='02' AND PBP_A_PLAN_TYPE='07' THEN TYPE = 'MSA';
  IF TYPE = 'PDP' THEN OUTPUT PDP;
  ELSE IF TYPE = 'MAPD' THEN OUTPUT MAPD;
  ELSE IF TYPE = 'MAON' THEN OUTPUT MAON;
  ELSE IF TYPE = 'MSA' THEN OUTPUT MSA;
  ELSE IF TYPE = 'FFS' THEN OUTPUT FFS;
  ELSE IF TYPE = 'MGAP' THEN OUTPUT MGAP;
  OUTPUT PBPPLANS;
RUN;

%GLOBAL MAON PDP MAPD MSA;
RUN;

DATA _NULL_;
  CALL SYMPUT('MAON',TRIM(LEFT(PUT(NUMOBS,4.))));
  PUT NUMOBS=;
  STOP;
  SET MAON NOBS=NUMOBS;
  STOP;
RUN;

DATA _NULL_;
  CALL SYMPUT('PDP',TRIM(LEFT(PUT(NUMOBS,4.))));
  PUT NUMOBS=;
  STOP;
  SET PDP NOBS=NUMOBS;
  STOP;
RUN;

DATA _NULL_;
  CALL SYMPUT('MAPD',TRIM(LEFT(PUT(NUMOBS,4.))));
  PUT NUMOBS=;
  STOP;
  SET MAPD NOBS=NUMOBS;
  STOP;
RUN;

DATA _NULL_;
  CALL SYMPUT('MSA',TRIM(LEFT(PUT(NUMOBS,4.))));
  PUT NUMOBS=;
  STOP;
  SET MSA NOBS=NUMOBS;
  STOP;
RUN;

DATA _NULL_;
  CALL SYMPUT('FFS',TRIM(LEFT(PUT(NUMOBS,4.))));
  PUT NUMOBS=;
  STOP;
  SET FFS NOBS=NUMOBS;
  STOP;
RUN;

DATA _NULL_;
  CALL SYMPUT('MGAP',TRIM(LEFT(PUT(NUMOBS,4.))));
  PUT NUMOBS=;
  STOP;
  SET MGAP NOBS=NUMOBS;
  STOP;
RUN;

%PUT _USER_;

DATA _NULL_;
  CALL SYMPUT('NUM',TRIM(LEFT(PUT(NUMOBS,4.))));
  STOP;
  SET PBPPLANS NOBS=NUMOBS;
  STOP;
RUN;

%MACRO FMT;
  %IF &NUM > 0 %THEN %DO;
    DATA PLAN_FMT (KEEP=START LABEL HLO FMTNAME);
      SET PBPPLANS (RENAME=QID=START) END=LAST;
      LENGTH FMTNAME $8 LABEL $4 HLO $1;
      FMTNAME='$TYPEF';
      LABEL=TYPE;
      HLO=' ';
      OUTPUT;
      IF LAST THEN DO;
        START='OTHER';
        LABEL='NO';
        HLO='O';
        OUTPUT;
      END;
    RUN;
  %END;
  %ELSE %DO;
    DATA PLAN_FMT (KEEP=START LABEL HLO FMTNAME);
      LENGTH FMTNAME $8 LABEL $4 HLO $1;
      FMTNAME='$TYPEF';
      START='OTHER';
      LABEL='NO';
      HLO='O';
      OUTPUT;
    RUN;
  %END;
  RUN;
%MEND;

%FMT;
RUN;

PROC FORMAT CNTLIN=PLAN_FMT LIB=LIBRARY;
RUN;

DATA CONTPLAN;
  LENGTH START $8;
  RETAIN FMTNAME '$CONTPLNF';
  SET PLAN_FMT(RENAME=START=HPLAN DROP=FMTNAME);
  START = SUBSTR(HPLAN,1,8);
RUN;

PROC SORT DATA = CONTPLAN NODUPKEY;
  BY START;
RUN;

PROC FORMAT CNTLIN=CONTPLAN LIB=LIBRARY;
RUN;

PROC SORT DATA=PBPPLANS;
  BY QID;
RUN;

DATA PBP;
  SET PBP_JSON;
  IF PUT(QID,$HPLANF.) = 'YES';
RUN;

PROC SORT DATA=PBP;
  BY QID;
RUN;

%INCLUDE IN0(CONVERT.SAS);
RUN;

%PBPIMPCONV(PBPB1_JSON);
RUN;

%PBPIMPCONV(PBPB1_2_JSON);
RUN;

%PBPIMPCONV(PBPB2_JSON);
RUN;

%PBPIMPCONV(PBPB3_JSON);
RUN;

%PBPIMPCONV(PBPB4_JSON);
RUN;

%PBPIMPCONV(PBPB6_JSON);
RUN;

%PBPIMPCONV(PBPB7_JSON);
RUN;

%PBPIMPCONV(PBPB7_2_JSON);
RUN;

%PBPIMPCONV(PBPB8_JSON);
RUN;

%PBPIMPCONV(PBPB9_JSON);
RUN;

%PBPIMPCONV(PBPB10_JSON);
RUN;

%PBPIMPCONV(PBPB11_JSON);
RUN;

%PBPIMPCONV(PBPB12_JSON);
RUN;

%PBPIMPCONV(PBPB14_2_JSON);
RUN;

%PBPIMPCONV(PBPB15_JSON);
RUN;

%PBPIMPCONV(PBPB16_JSON);
RUN;

%PBPIMPCONV(PBPB17_JSON);
RUN;

%PBPIMPCONV(PBPB18_JSON);
RUN;

%PBPIMPCONV(PBPB20_JSON);
RUN;

DATA _NULL_;
  CALL SYMPUT('B20OBS',TRIM(LEFT(PUT(NUMOBS,4.))));
  STOP;
  SET PBPB20_JSON NOBS=NUMOBS;
  STOP;
RUN;

%PBPIMPCONV(PBPD_JSON);
RUN;

%PBPIMPCONV(PBPD_1_JSON);
RUN;

%MACRO BUILDFILE;

DATA PBP_FILE(RENAME=QID=HPLAN);
  MERGE PBPPLANS(IN=INPLAN
    RENAME=(PBP_A_CONTRACT_NUMBER=CONTRACT_ID PBP_A_PLAN_IDENTIFIER=PLAN_ID PBP_A_SEGMENT_ID=SEGMENT_ID))
  PBP(DROP=PBP_A_CONTRACT_NUMBER PBP_A_PLAN_IDENTIFIER PBP_A_SEGMENT_ID PBP_A_PLAN_TYPE
    PBP_A_ORG_TYPE PBP_A_NETWORK_FLAG MRX_DRUG_BEN_YN)
  PBPB1_JSON
  PBPB1_2_JSON
  PBPB2_JSON
  PBPB3_JSON 
  PBPB4_JSON
  PBPB6_JSON 
  PBPB7_JSON
  PBPB7_2_JSON
  PBPB8_JSON 
  PBPB9_JSON
  PBPB10_JSON 
  PBPB11_JSON 
  PBPB12_JSON
  PBPB14_2_JSON   
  PBPB15_JSON
  PBPB16_JSON
  PBPB17_JSON 
  PBPB18_JSON 
  PBPB20_JSON
  PBPD_JSON
  PBPD_1_JSON
;
  
  BY QID;
  IF INPLAN;

  ARRAY DIV100 _NUMERIC_;

  DO I = 1 TO DIM(DIV100);
    IF INDEX(UPCASE(VNAME(DIV100(I))),"COINS") > 0 & INDEX(UPCASE(VNAME(DIV100(I))),"PCT") > 0 & DIV100(I) NE . THEN
      DIV100(I) = DIV100(I) / 100.0;
  END;
RUN;

%MEND;

%BUILDFILE;
RUN;

PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
DELETE PBPPLANS PBP PBP_JSON PBPB1_JSON PBPB1_2_JSON
PBPB2_JSON PBPB3_JSON PBPB4_JSON PBPB6_JSON PBPB7_JSON
PBPB7_2_JSON PBPB8_JSON PBPB9_JSON PBPB10_JSON PBPB11_JSON 
PBPB12_JSON PBPB14_2_JSON PBPB15_JSON PBPB16_JSON PBPB17_JSON
PBPB18_JSON PBPB20_JSON PBPD_JSON PBPD_1_JSON
NEWPBPB1_JSON NEWPBPB1_2_JSON
NEWPBPB2_JSON NEWPBPB3_JSON NEWPBPB4_JSON NEWPBPB6_JSON NEWPBPB7_JSON
NEWPBPB7_2_JSON NEWPBPB8_JSON NEWPBPB9_JSON NEWPBPB10_JSON NEWPBPB11_JSON 
NEWPBPB12_JSON NEWPBPB14_2_JSON NEWPBPB15_JSON NEWPBPB16_JSON NEWPBPB17_JSON
NEWPBPB18_JSON NEWPBPB20_JSON NEWPBPD_JSON NEWPBPD_1_JSON
;
QUIT;
RUN;
