/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.api.v2;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithFourFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import lombok.Generated;

@Schema(description="The additional pricing data related to the processed claim.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-DATA-ALL", value="<structure>")})})
public class AdditionalPricingData {
    @BigDecimalScale(scale=4)
    @Schema(description="The adjusted base wage amount for the bundle.", example="5431.3928", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BUN-ADJUSTED-BASE-WAGE-AMT", value="PIC 9(07)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal bundledAdjustedBaseWageAmount;
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="9999.99")
    @Digits(integer=4, fraction=2)
    @Schema(description="The bundle base payment rate.", example="1238.45", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-BUN-BASE-PMT-RATE", value="PIC 9(04)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9999.99") @Digits(integer=4, fraction=2) @FixedValue BigDecimal bundledBasePaymentRate;
    @BigDecimalScale(scale=4)
    @Schema(description="The wage-adjustment training amount for the bundle.", example="138768.8498", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-BUN-WAGE-ADJ-TRAIN-AMT", value="PIC 9(07)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal bundledWageAdjustmentTrainingAmount;
    @BigDecimalScale(scale=3)
    @DecimalMin(value="0")
    @DecimalMax(value="9.999")
    @Digits(integer=1, fraction=3)
    @Schema(description="The case-mix adjustment for body-mass index (BMI) when the value is less than than 18.5.", example="1.017", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-CM-BMI-LT-18-5", value="PIC 9(01)V9(03)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.999") @Digits(integer=1, fraction=3) @FixedValue BigDecimal caseMixBmiUnderEighteenPointFiveMultiplier;
    @BigDecimalScale(scale=3)
    @DecimalMin(value="0")
    @DecimalMax(value="9.999")
    @Digits(integer=1, fraction=3)
    @Schema(description="The case-mix body-surface area (BSA) multiplier.", example="1.032", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-CM-BSA", value="PIC 9(01)V9(03)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.999") @Digits(integer=1, fraction=3) @FixedValue BigDecimal caseMixBsaMultiplier;
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="9999.99")
    @Digits(integer=4, fraction=2)
    @Schema(example="1238.45", description="The compensation payment rate.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="COM-PAYMENT-RATE", value="PIC 9(04)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9999.99") @Digits(integer=4, fraction=2) @FixedValue BigDecimal compositePaymentRate;
    @BigDecimalScale(scale=3)
    @DecimalMin(value="0")
    @DecimalMax(value="9.999")
    @Digits(integer=1, fraction=3)
    @Schema(description="The composite-rate multiplier for body-mass index (BMI).", example="1.112", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="CR-BMI-MULTIPLIER", value="PIC 9(01)V9(03)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.999") @Digits(integer=1, fraction=3) @FixedValue BigDecimal compositeRateBmiMultiplier;
    @BigDecimalScale(scale=3)
    @DecimalMin(value="0")
    @DecimalMax(value="9.999")
    @Digits(integer=1, fraction=3)
    @Schema(description="The composite-rate multiplier for body-surface area (BSA).", example="0.856", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="CR-BSA-MULTIPLIER", value="PIC 9(01)V9(03)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.999") @Digits(integer=1, fraction=3) @FixedValue BigDecimal compositeRateBsaMultiplier;
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="9.99")
    @Digits(integer=1, fraction=2)
    @Schema(description="The adjustment amount for ESRD drugs and biologicals currently paid under Part-D.", example="0.49", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="A-49-CENT-DRUG-ADJ", value="PIC 9(01)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.99") @Digits(integer=1, fraction=2) @FixedValue BigDecimal drugAndBiologicalAdjustmentAmount;
    @BigDecimalScale(scale=4)
    @Schema(description="The outlier case-mix predicted Medicare-allowable payment (MAP) amount.", example="4839.1253", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OUT-CASE-MIX-PREDICTED-MAP", value="PIC 9(04)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal outlierCaseMixPredictedMapAmount;
    @BigDecimalScale(scale=4)
    @Schema(description="The outlier amount for hemo-equivalent dialysis sessions.", example="12.3845", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OUT-HEMO-EQUIV-DIAL-SESSIONS", value="PIC 9(02)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal outlierHemoEquivalentDialysisSessionsAmount;
    @BigDecimalScale(scale=3)
    @DecimalMin(value="0")
    @DecimalMax(value="9.999")
    @Digits(integer=1, fraction=3)
    @Schema(description="The outlier amount for separately-billable body-surface area (BSA).", example="1.123", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="OUT-SB-BSA", value="PIC 9(01)V9(03)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="9.999") @Digits(integer=1, fraction=3) @FixedValue BigDecimal outlierSeparatelyBillableBsaAmount;
    @BigDecimalScale
    @DecimalMin(value="0")
    @DecimalMax(value="99.99")
    @Digits(integer=2, fraction=2)
    @Schema(description="The training add-on payment amount.", example="18.45", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-TRAINING-ADD-ON-PMT-AMT", value="PIC 9(02)V9(02)")})})
    @FixedValue
    private @DecimalMin(value="0") @DecimalMax(value="99.99") @Digits(integer=2, fraction=2) @FixedValue BigDecimal trainingAddOnPaymentAmount;

    @Generated
    public BigDecimal getBundledAdjustedBaseWageAmount() {
        return this.bundledAdjustedBaseWageAmount;
    }

    @Generated
    public BigDecimal getBundledBasePaymentRate() {
        return this.bundledBasePaymentRate;
    }

    @Generated
    public BigDecimal getBundledWageAdjustmentTrainingAmount() {
        return this.bundledWageAdjustmentTrainingAmount;
    }

    @Generated
    public BigDecimal getCaseMixBmiUnderEighteenPointFiveMultiplier() {
        return this.caseMixBmiUnderEighteenPointFiveMultiplier;
    }

    @Generated
    public BigDecimal getCaseMixBsaMultiplier() {
        return this.caseMixBsaMultiplier;
    }

    @Generated
    public BigDecimal getCompositePaymentRate() {
        return this.compositePaymentRate;
    }

    @Generated
    public BigDecimal getCompositeRateBmiMultiplier() {
        return this.compositeRateBmiMultiplier;
    }

    @Generated
    public BigDecimal getCompositeRateBsaMultiplier() {
        return this.compositeRateBsaMultiplier;
    }

    @Generated
    public BigDecimal getDrugAndBiologicalAdjustmentAmount() {
        return this.drugAndBiologicalAdjustmentAmount;
    }

    @Generated
    public BigDecimal getOutlierCaseMixPredictedMapAmount() {
        return this.outlierCaseMixPredictedMapAmount;
    }

    @Generated
    public BigDecimal getOutlierHemoEquivalentDialysisSessionsAmount() {
        return this.outlierHemoEquivalentDialysisSessionsAmount;
    }

    @Generated
    public BigDecimal getOutlierSeparatelyBillableBsaAmount() {
        return this.outlierSeparatelyBillableBsaAmount;
    }

    @Generated
    public BigDecimal getTrainingAddOnPaymentAmount() {
        return this.trainingAddOnPaymentAmount;
    }

    @Generated
    public void setBundledAdjustedBaseWageAmount(BigDecimal bundledAdjustedBaseWageAmount) {
        this.bundledAdjustedBaseWageAmount = bundledAdjustedBaseWageAmount;
    }

    @Generated
    public void setBundledBasePaymentRate(BigDecimal bundledBasePaymentRate) {
        this.bundledBasePaymentRate = bundledBasePaymentRate;
    }

    @Generated
    public void setBundledWageAdjustmentTrainingAmount(BigDecimal bundledWageAdjustmentTrainingAmount) {
        this.bundledWageAdjustmentTrainingAmount = bundledWageAdjustmentTrainingAmount;
    }

    @Generated
    public void setCaseMixBmiUnderEighteenPointFiveMultiplier(BigDecimal caseMixBmiUnderEighteenPointFiveMultiplier) {
        this.caseMixBmiUnderEighteenPointFiveMultiplier = caseMixBmiUnderEighteenPointFiveMultiplier;
    }

    @Generated
    public void setCaseMixBsaMultiplier(BigDecimal caseMixBsaMultiplier) {
        this.caseMixBsaMultiplier = caseMixBsaMultiplier;
    }

    @Generated
    public void setCompositePaymentRate(BigDecimal compositePaymentRate) {
        this.compositePaymentRate = compositePaymentRate;
    }

    @Generated
    public void setCompositeRateBmiMultiplier(BigDecimal compositeRateBmiMultiplier) {
        this.compositeRateBmiMultiplier = compositeRateBmiMultiplier;
    }

    @Generated
    public void setCompositeRateBsaMultiplier(BigDecimal compositeRateBsaMultiplier) {
        this.compositeRateBsaMultiplier = compositeRateBsaMultiplier;
    }

    @Generated
    public void setDrugAndBiologicalAdjustmentAmount(BigDecimal drugAndBiologicalAdjustmentAmount) {
        this.drugAndBiologicalAdjustmentAmount = drugAndBiologicalAdjustmentAmount;
    }

    @Generated
    public void setOutlierCaseMixPredictedMapAmount(BigDecimal outlierCaseMixPredictedMapAmount) {
        this.outlierCaseMixPredictedMapAmount = outlierCaseMixPredictedMapAmount;
    }

    @Generated
    public void setOutlierHemoEquivalentDialysisSessionsAmount(BigDecimal outlierHemoEquivalentDialysisSessionsAmount) {
        this.outlierHemoEquivalentDialysisSessionsAmount = outlierHemoEquivalentDialysisSessionsAmount;
    }

    @Generated
    public void setOutlierSeparatelyBillableBsaAmount(BigDecimal outlierSeparatelyBillableBsaAmount) {
        this.outlierSeparatelyBillableBsaAmount = outlierSeparatelyBillableBsaAmount;
    }

    @Generated
    public void setTrainingAddOnPaymentAmount(BigDecimal trainingAddOnPaymentAmount) {
        this.trainingAddOnPaymentAmount = trainingAddOnPaymentAmount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdditionalPricingData)) {
            return false;
        }
        AdditionalPricingData other = (AdditionalPricingData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$bundledAdjustedBaseWageAmount = this.getBundledAdjustedBaseWageAmount();
        BigDecimal other$bundledAdjustedBaseWageAmount = other.getBundledAdjustedBaseWageAmount();
        if (this$bundledAdjustedBaseWageAmount == null ? other$bundledAdjustedBaseWageAmount != null : !((Object)this$bundledAdjustedBaseWageAmount).equals(other$bundledAdjustedBaseWageAmount)) {
            return false;
        }
        BigDecimal this$bundledBasePaymentRate = this.getBundledBasePaymentRate();
        BigDecimal other$bundledBasePaymentRate = other.getBundledBasePaymentRate();
        if (this$bundledBasePaymentRate == null ? other$bundledBasePaymentRate != null : !((Object)this$bundledBasePaymentRate).equals(other$bundledBasePaymentRate)) {
            return false;
        }
        BigDecimal this$bundledWageAdjustmentTrainingAmount = this.getBundledWageAdjustmentTrainingAmount();
        BigDecimal other$bundledWageAdjustmentTrainingAmount = other.getBundledWageAdjustmentTrainingAmount();
        if (this$bundledWageAdjustmentTrainingAmount == null ? other$bundledWageAdjustmentTrainingAmount != null : !((Object)this$bundledWageAdjustmentTrainingAmount).equals(other$bundledWageAdjustmentTrainingAmount)) {
            return false;
        }
        BigDecimal this$caseMixBmiUnderEighteenPointFiveMultiplier = this.getCaseMixBmiUnderEighteenPointFiveMultiplier();
        BigDecimal other$caseMixBmiUnderEighteenPointFiveMultiplier = other.getCaseMixBmiUnderEighteenPointFiveMultiplier();
        if (this$caseMixBmiUnderEighteenPointFiveMultiplier == null ? other$caseMixBmiUnderEighteenPointFiveMultiplier != null : !((Object)this$caseMixBmiUnderEighteenPointFiveMultiplier).equals(other$caseMixBmiUnderEighteenPointFiveMultiplier)) {
            return false;
        }
        BigDecimal this$caseMixBsaMultiplier = this.getCaseMixBsaMultiplier();
        BigDecimal other$caseMixBsaMultiplier = other.getCaseMixBsaMultiplier();
        if (this$caseMixBsaMultiplier == null ? other$caseMixBsaMultiplier != null : !((Object)this$caseMixBsaMultiplier).equals(other$caseMixBsaMultiplier)) {
            return false;
        }
        BigDecimal this$compositePaymentRate = this.getCompositePaymentRate();
        BigDecimal other$compositePaymentRate = other.getCompositePaymentRate();
        if (this$compositePaymentRate == null ? other$compositePaymentRate != null : !((Object)this$compositePaymentRate).equals(other$compositePaymentRate)) {
            return false;
        }
        BigDecimal this$compositeRateBmiMultiplier = this.getCompositeRateBmiMultiplier();
        BigDecimal other$compositeRateBmiMultiplier = other.getCompositeRateBmiMultiplier();
        if (this$compositeRateBmiMultiplier == null ? other$compositeRateBmiMultiplier != null : !((Object)this$compositeRateBmiMultiplier).equals(other$compositeRateBmiMultiplier)) {
            return false;
        }
        BigDecimal this$compositeRateBsaMultiplier = this.getCompositeRateBsaMultiplier();
        BigDecimal other$compositeRateBsaMultiplier = other.getCompositeRateBsaMultiplier();
        if (this$compositeRateBsaMultiplier == null ? other$compositeRateBsaMultiplier != null : !((Object)this$compositeRateBsaMultiplier).equals(other$compositeRateBsaMultiplier)) {
            return false;
        }
        BigDecimal this$drugAndBiologicalAdjustmentAmount = this.getDrugAndBiologicalAdjustmentAmount();
        BigDecimal other$drugAndBiologicalAdjustmentAmount = other.getDrugAndBiologicalAdjustmentAmount();
        if (this$drugAndBiologicalAdjustmentAmount == null ? other$drugAndBiologicalAdjustmentAmount != null : !((Object)this$drugAndBiologicalAdjustmentAmount).equals(other$drugAndBiologicalAdjustmentAmount)) {
            return false;
        }
        BigDecimal this$outlierCaseMixPredictedMapAmount = this.getOutlierCaseMixPredictedMapAmount();
        BigDecimal other$outlierCaseMixPredictedMapAmount = other.getOutlierCaseMixPredictedMapAmount();
        if (this$outlierCaseMixPredictedMapAmount == null ? other$outlierCaseMixPredictedMapAmount != null : !((Object)this$outlierCaseMixPredictedMapAmount).equals(other$outlierCaseMixPredictedMapAmount)) {
            return false;
        }
        BigDecimal this$outlierHemoEquivalentDialysisSessionsAmount = this.getOutlierHemoEquivalentDialysisSessionsAmount();
        BigDecimal other$outlierHemoEquivalentDialysisSessionsAmount = other.getOutlierHemoEquivalentDialysisSessionsAmount();
        if (this$outlierHemoEquivalentDialysisSessionsAmount == null ? other$outlierHemoEquivalentDialysisSessionsAmount != null : !((Object)this$outlierHemoEquivalentDialysisSessionsAmount).equals(other$outlierHemoEquivalentDialysisSessionsAmount)) {
            return false;
        }
        BigDecimal this$outlierSeparatelyBillableBsaAmount = this.getOutlierSeparatelyBillableBsaAmount();
        BigDecimal other$outlierSeparatelyBillableBsaAmount = other.getOutlierSeparatelyBillableBsaAmount();
        if (this$outlierSeparatelyBillableBsaAmount == null ? other$outlierSeparatelyBillableBsaAmount != null : !((Object)this$outlierSeparatelyBillableBsaAmount).equals(other$outlierSeparatelyBillableBsaAmount)) {
            return false;
        }
        BigDecimal this$trainingAddOnPaymentAmount = this.getTrainingAddOnPaymentAmount();
        BigDecimal other$trainingAddOnPaymentAmount = other.getTrainingAddOnPaymentAmount();
        return !(this$trainingAddOnPaymentAmount == null ? other$trainingAddOnPaymentAmount != null : !((Object)this$trainingAddOnPaymentAmount).equals(other$trainingAddOnPaymentAmount));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AdditionalPricingData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $bundledAdjustedBaseWageAmount = this.getBundledAdjustedBaseWageAmount();
        result = result * 59 + ($bundledAdjustedBaseWageAmount == null ? 43 : ((Object)$bundledAdjustedBaseWageAmount).hashCode());
        BigDecimal $bundledBasePaymentRate = this.getBundledBasePaymentRate();
        result = result * 59 + ($bundledBasePaymentRate == null ? 43 : ((Object)$bundledBasePaymentRate).hashCode());
        BigDecimal $bundledWageAdjustmentTrainingAmount = this.getBundledWageAdjustmentTrainingAmount();
        result = result * 59 + ($bundledWageAdjustmentTrainingAmount == null ? 43 : ((Object)$bundledWageAdjustmentTrainingAmount).hashCode());
        BigDecimal $caseMixBmiUnderEighteenPointFiveMultiplier = this.getCaseMixBmiUnderEighteenPointFiveMultiplier();
        result = result * 59 + ($caseMixBmiUnderEighteenPointFiveMultiplier == null ? 43 : ((Object)$caseMixBmiUnderEighteenPointFiveMultiplier).hashCode());
        BigDecimal $caseMixBsaMultiplier = this.getCaseMixBsaMultiplier();
        result = result * 59 + ($caseMixBsaMultiplier == null ? 43 : ((Object)$caseMixBsaMultiplier).hashCode());
        BigDecimal $compositePaymentRate = this.getCompositePaymentRate();
        result = result * 59 + ($compositePaymentRate == null ? 43 : ((Object)$compositePaymentRate).hashCode());
        BigDecimal $compositeRateBmiMultiplier = this.getCompositeRateBmiMultiplier();
        result = result * 59 + ($compositeRateBmiMultiplier == null ? 43 : ((Object)$compositeRateBmiMultiplier).hashCode());
        BigDecimal $compositeRateBsaMultiplier = this.getCompositeRateBsaMultiplier();
        result = result * 59 + ($compositeRateBsaMultiplier == null ? 43 : ((Object)$compositeRateBsaMultiplier).hashCode());
        BigDecimal $drugAndBiologicalAdjustmentAmount = this.getDrugAndBiologicalAdjustmentAmount();
        result = result * 59 + ($drugAndBiologicalAdjustmentAmount == null ? 43 : ((Object)$drugAndBiologicalAdjustmentAmount).hashCode());
        BigDecimal $outlierCaseMixPredictedMapAmount = this.getOutlierCaseMixPredictedMapAmount();
        result = result * 59 + ($outlierCaseMixPredictedMapAmount == null ? 43 : ((Object)$outlierCaseMixPredictedMapAmount).hashCode());
        BigDecimal $outlierHemoEquivalentDialysisSessionsAmount = this.getOutlierHemoEquivalentDialysisSessionsAmount();
        result = result * 59 + ($outlierHemoEquivalentDialysisSessionsAmount == null ? 43 : ((Object)$outlierHemoEquivalentDialysisSessionsAmount).hashCode());
        BigDecimal $outlierSeparatelyBillableBsaAmount = this.getOutlierSeparatelyBillableBsaAmount();
        result = result * 59 + ($outlierSeparatelyBillableBsaAmount == null ? 43 : ((Object)$outlierSeparatelyBillableBsaAmount).hashCode());
        BigDecimal $trainingAddOnPaymentAmount = this.getTrainingAddOnPaymentAmount();
        result = result * 59 + ($trainingAddOnPaymentAmount == null ? 43 : ((Object)$trainingAddOnPaymentAmount).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AdditionalPricingData(bundledAdjustedBaseWageAmount=" + this.getBundledAdjustedBaseWageAmount() + ", bundledBasePaymentRate=" + this.getBundledBasePaymentRate() + ", bundledWageAdjustmentTrainingAmount=" + this.getBundledWageAdjustmentTrainingAmount() + ", caseMixBmiUnderEighteenPointFiveMultiplier=" + this.getCaseMixBmiUnderEighteenPointFiveMultiplier() + ", caseMixBsaMultiplier=" + this.getCaseMixBsaMultiplier() + ", compositePaymentRate=" + this.getCompositePaymentRate() + ", compositeRateBmiMultiplier=" + this.getCompositeRateBmiMultiplier() + ", compositeRateBsaMultiplier=" + this.getCompositeRateBsaMultiplier() + ", drugAndBiologicalAdjustmentAmount=" + this.getDrugAndBiologicalAdjustmentAmount() + ", outlierCaseMixPredictedMapAmount=" + this.getOutlierCaseMixPredictedMapAmount() + ", outlierHemoEquivalentDialysisSessionsAmount=" + this.getOutlierHemoEquivalentDialysisSessionsAmount() + ", outlierSeparatelyBillableBsaAmount=" + this.getOutlierSeparatelyBillableBsaAmount() + ", trainingAddOnPaymentAmount=" + this.getTrainingAddOnPaymentAmount() + ")";
    }

    @Generated
    public AdditionalPricingData() {
    }
}

