/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.api.v2;

import gov.cms.fiss.pricers.esrd.api.v2.ValidCommonWorkingFileReturnCode;
import gov.cms.fiss.pricers.esrd.api.v2.ValidComorbidityCode;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.validation.constraints.Size;
import lombok.Generated;

@Schema(description="The comorbidity reference information for the claim.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="COMORBIDITIES-PORTION", value="<structure>")})})
public class ComorbidityData {
    @ArraySchema(arraySchema=@Schema(description="The comorbidity data; used when no return code is provided. It is expected that the values 'MA' and 'MC' will only be used for the first two positions, and the values 'MD' and 'ME' will only be used for the last two positions.", allowableValues={"MA", "MC", "MD", "ME"}, example="[ \"MA\", \"MC\" ]"), uniqueItems=true, extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="COMORBID-DATA", value="OCCURS 6 TIMES\n INDEXED BY COMORBID-INDEX\n PIC X(02)", parseValue=true)})})
    @Size(max=6, min=1)
    private @Size(max=6, min=1) List<@ValidComorbidityCode String> comorbidityCodes;
    @Schema(description="Common working file return code for the specified comorbidities.", allowableValues={"10", "20", "30", "40", "50", "60", "70"}, example="40", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="COMORBID-CWF-RETURN-CODE", value="PIC X(02)")})})
    @ValidCommonWorkingFileReturnCode
    private String cwfReturnCode;

    @Generated
    public List<@ValidComorbidityCode String> getComorbidityCodes() {
        return this.comorbidityCodes;
    }

    @Generated
    public String getCwfReturnCode() {
        return this.cwfReturnCode;
    }

    @Generated
    public void setComorbidityCodes(List<@ValidComorbidityCode String> comorbidityCodes) {
        this.comorbidityCodes = comorbidityCodes;
    }

    @Generated
    public void setCwfReturnCode(String cwfReturnCode) {
        this.cwfReturnCode = cwfReturnCode;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComorbidityData)) {
            return false;
        }
        ComorbidityData other = (ComorbidityData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$comorbidityCodes = this.getComorbidityCodes();
        List<String> other$comorbidityCodes = other.getComorbidityCodes();
        if (this$comorbidityCodes == null ? other$comorbidityCodes != null : !((Object)this$comorbidityCodes).equals(other$comorbidityCodes)) {
            return false;
        }
        String this$cwfReturnCode = this.getCwfReturnCode();
        String other$cwfReturnCode = other.getCwfReturnCode();
        return !(this$cwfReturnCode == null ? other$cwfReturnCode != null : !this$cwfReturnCode.equals(other$cwfReturnCode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ComorbidityData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $comorbidityCodes = this.getComorbidityCodes();
        result = result * 59 + ($comorbidityCodes == null ? 43 : ((Object)$comorbidityCodes).hashCode());
        String $cwfReturnCode = this.getCwfReturnCode();
        result = result * 59 + ($cwfReturnCode == null ? 43 : $cwfReturnCode.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ComorbidityData(comorbidityCodes=" + this.getComorbidityCodes() + ", cwfReturnCode=" + this.getCwfReturnCode() + ")";
    }

    @Generated
    public ComorbidityData() {
    }
}

