/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gov.cms.fiss.pricers.common.api.OutpatientProviderData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.esrd.api.v2.AdditionalPricingData;
import gov.cms.fiss.pricers.esrd.api.v2.BundledBillingData;
import gov.cms.fiss.pricers.esrd.api.v2.BundledPaymentData;
import gov.cms.fiss.pricers.esrd.api.v2.ComorbidityData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdPaymentData;
import gov.cms.fiss.pricers.esrd.api.v2.OutlierBillingData;
import gov.cms.fiss.pricers.esrd.api.v2.PaymentBillingData;
import gov.cms.fiss.pricers.esrd.core.codes.ReturnCode;
import gov.cms.fiss.pricers.esrd.core.tables.DataTables;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class EsrdPricerContext
extends CalculationContext<EsrdClaimPricingRequest, EsrdClaimPricingResponse> {
    public static final String CONDITION_CODE_SELF_CARE_TRAINING_73 = "73";
    public static final String CONDITION_CODE_HOME_SERVICES_74 = "74";
    public static final String CONDITION_CODE_IN_FACILITY_BACK_UP_76 = "76";
    public static final String CONDITION_CODE_AKI_MONTHLY_84 = "84";
    public static final String CONDITION_CODE_SELF_CARE_RETRAINING_87 = "87";
    public static final String COMORBIDITY_RETURN_CODE_DEFAULT_10 = "10";
    public static final String COMORBIDITY_RETURN_CODE_GASTROENTERITIS_20 = "20";
    public static final String COMORBIDITY_RETURN_CODE_PNEUMONIA_30 = "30";
    public static final String COMORBIDITY_RETURN_CODE_PERICARDITIS_40 = "40";
    public static final String COMORBIDITY_RETURN_CODE_MYELODYDISPLASTIC_SYNDROME_50 = "50";
    public static final String COMORBIDITY_RETURN_CODE_HEMOLYTIC_SICKLE_CELL_60 = "60";
    public static final String COMORBIDITY_RETURN_CODE_MONOCLONAL_GAMMOPATHY_70 = "70";
    public static final String DEMO_CODE_ETC_PARTICIPANT = "94";
    public static final BigDecimal QIP_REDUCTION_NONE = new BigDecimal("1.000");
    public static final BigDecimal QIP_REDUCTION_HALF_PCT = new BigDecimal("0.995");
    public static final BigDecimal QIP_REDUCTION_ONE_PCT = new BigDecimal("0.990");
    public static final BigDecimal QIP_REDUCTION_ONE_AND_HALF_PCT = new BigDecimal("0.985");
    public static final BigDecimal QIP_REDUCTION_TWO_PCT = new BigDecimal("0.980");
    public static final BigDecimal BMI_CUTOFF_18_POINT_5 = new BigDecimal("18.5");
    public static final String REVENUE_CODE_HEMODIALYSIS_0821 = "0821";
    public static final String REVENUE_CODE_PERITONEAL_DIALYSIS_0831 = "0831";
    public static final String REVENUE_CODE_CONTINUOUS_AMBULATORY_PERITONEAL_DIALYSIS_0841 = "0841";
    public static final String REVENUE_CODE_CONTINUOUS_CYCLING_PERITONEAL_DIALYSIS_0851 = "0851";
    public static final String REVENUE_CODE_MISCELLANEOUS_DIALYSIS_0881 = "0881";
    public static final BigDecimal DEFAULT_FACTOR = new BigDecimal("1.0000");
    public static final BigDecimal DEFAULT_MULTIPLIER = new BigDecimal("1.000");
    public static final BigDecimal CASE_MIX_BUDGET_NEUTRAL_FACTOR = new BigDecimal("0.9116");
    public static final BigDecimal COMPOSITE_RATE_BSA_MULTIPLIER = new BigDecimal("1.037");
    public static final BigDecimal COMPOSITE_RATE_BMI_UNDER_CUTOFF_MULTIPLIER = new BigDecimal("1.112");
    public static final BigDecimal TRANSITION_BUDGET_NEUTRAL_FACTOR = new BigDecimal("1.0000");
    public static final BigDecimal MAX_BMI_AMOUNT = new BigDecimal("999.9999");
    public static final String ETC_INDICATOR_HDPA = "H";
    public static final String ETC_INDICATOR_HDPA_NOTHING = " ";
    public static final String ETC_INDICATOR_PPA = "P";
    public static final String ETC_INDICATOR_BOTH_HDPA_AND_PPA = "B";
    private static final String[] VALID_CONDITION_CODES = new String[]{"73", "74", "76", "84", "87"};
    private static final String[] VALID_COMORBIDITY_RETURN_CODES = new String[]{"10", "20", "40", "50", "60"};
    private static final String[] VALID_PROVIDER_TYPES = new String[]{"05", "40", "41"};
    private static final String[] VALID_QIP_REDUCTION_CODES = new String[]{"1", "2", "3", "4"};
    private static final String[] VALID_SPECIAL_LOCALITY_INDICATOR_CODES = new String[]{"1", "2"};
    private static final String[] VALID_REVENUE_CODES = new String[]{"0821", "0831", "0841", "0851", "0881"};
    @JsonIgnore
    private final DataTables dataTables;
    private boolean blendedPaymentWaived;
    private List<String> comorbidityCodes = new ArrayList<String>();
    @FixedValue
    private BigDecimal comorbidityMultiplier = DEFAULT_MULTIPLIER;
    private BigDecimal conditionCode74PerDiemAmount = BigDecimal.ZERO;
    private BigDecimal craTpniesPayment = BigDecimal.ZERO;
    private BigDecimal tpeapaPayment = BigDecimal.ZERO;
    private BigDecimal postTdapaPayment = BigDecimal.ZERO;
    private BigDecimal caseMixAdjuster = BigDecimal.ZERO;
    private BigDecimal patientLevelCaseMixAdjusterForPostTdapa = BigDecimal.ZERO;
    private String cwfReturnCode;
    private BigDecimal finalAmountWithoutHdpa = BigDecimal.ZERO;
    private BigDecimal finalAmountWithHdpa = BigDecimal.ZERO;
    private BigDecimal finalAmountWithoutPpa = BigDecimal.ZERO;
    private BigDecimal finalAmountWithPpa = BigDecimal.ZERO;
    private BigDecimal finalAmountWithoutEtc = BigDecimal.ZERO;
    private BigDecimal finalPaymentAmount = BigDecimal.ZERO;
    private BigDecimal fullClaimAmount = BigDecimal.ZERO;
    private BigDecimal hemoEquivalentDialysisSessions = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal networkReductionAmount = BigDecimal.ZERO;
    private int patientAge;
    private BigDecimal perDiemAmountWithoutHdpa = BigDecimal.ZERO;
    private BigDecimal perDiemAmountWithHdpa = BigDecimal.ZERO;
    private BigDecimal perDiemAmountWithoutEtc = BigDecimal.ZERO;
    private BigDecimal perDiemAmountWithoutPpa = BigDecimal.ZERO;
    private BigDecimal perDiemAmountWithPpa = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal qipReduction = QIP_REDUCTION_NONE;
    private BigDecimal tdapaPayment = BigDecimal.ZERO;
    private BigDecimal tpniesPayment = BigDecimal.ZERO;
    private BigDecimal bundledAdjustedBaseWageAmount = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal bundledAgeAdjustmentFactor = BigDecimal.ZERO;
    private BigDecimal bundledBmi = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal bundledBmiFactor = BigDecimal.ZERO;
    private BigDecimal bundledBsa = BigDecimal.ZERO;
    private BigDecimal bundledBsaFactor = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal bundledComorbidityMultiplier = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal bundledLowVolumeMultiplier = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal bundledLowVolumeTierOneMultiplier = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal bundledLowVolumeTierTwoMultiplier = BigDecimal.ZERO;
    private BigDecimal bundledNationalLaborAmount = BigDecimal.ZERO;
    private BigDecimal bundledNationalNonLaborAmount = BigDecimal.ZERO;
    private BigDecimal bundledBaseWageAmount = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal bundledOnsetFactor = BigDecimal.ZERO;
    private BigDecimal bundledRuralMultiplier = BigDecimal.ZERO;
    private BigDecimal bundledWageAdjustedTrainingAmount = BigDecimal.ZERO;
    private BigDecimal bundledWageIndex = BigDecimal.ZERO;
    private BigDecimal ppaAdjustmentPercent = BigDecimal.ZERO;
    private BigDecimal lowVolumeBundledAdjustedBaseWageAmount = BigDecimal.ZERO;
    private BigDecimal lowVolumeOutlierCaseMixAdjustedPredictedSvcsMapPerTrt = BigDecimal.ZERO;
    private BigDecimal lowVolumeFinalPaymentAmount = BigDecimal.ZERO;
    private BigDecimal lowVolumeOutlierPayment = BigDecimal.ZERO;
    private BigDecimal lowVolumeOutlierPredictedMap = BigDecimal.ZERO;
    private BigDecimal lowVolumeOutlierPredictedSvcsMap = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal outlierAdjustedAverageMapAmount = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal outlierAgeAdjustmentFactor = BigDecimal.ZERO;
    private BigDecimal outlierBmi = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal outlierBmiFactor = BigDecimal.ZERO;
    private BigDecimal outlierBsa = BigDecimal.ZERO;
    private BigDecimal outlierBsaFactor = BigDecimal.ZERO;
    private BigDecimal outlierCaseMixAdjPredictedMapTrt = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal outlierComorbidityMultiplier = BigDecimal.ZERO;
    private BigDecimal outlierHemoEquivalentPayment = BigDecimal.ZERO;
    private BigDecimal outlierImputedMapAmount = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal outlierFixedDollarLoss = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal outlierLossSharingPercentage = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal outlierLowVolumeMultiplier = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal outlierLowVolumeTierOneMultiplier = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal outlierLowVolumeTierTwoMultiplier = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal outlierOnsetFactor = BigDecimal.ZERO;
    private BigDecimal outlierRuralMultiplier = BigDecimal.ZERO;
    private BigDecimal outlierPayment = BigDecimal.ZERO;
    private BigDecimal outlierPredictedMapAmount = BigDecimal.ZERO;
    private BigDecimal outlierPredictedSvcsMapAmount = BigDecimal.ZERO;
    private boolean acuteComorbidityFound;
    private boolean chronicComorbidityFound;
    private boolean lowBmiClaim;
    private boolean lowVolumeClaim;
    private boolean outlierClaim;
    private boolean pediatricClaim;
    private boolean onsetRecent;
    private boolean trainingClaim;
    private boolean aki84;
    private boolean esrdFacility;
    private boolean akiTraining8473;
    private boolean akiHome8474;
    private boolean akiRetraining8487;
    private boolean esrdTraining73;
    private boolean esrdHome74;
    private boolean esrdBackup76;
    private boolean akiFacility84;
    private boolean esrdRetraining87;

    protected EsrdPricerContext(EsrdClaimPricingRequest input, EsrdClaimPricingResponse output, DataTables dataTables) {
        super(input, output);
        this.dataTables = dataTables;
        this.initializeOutput();
        this.postTdapaPayment = BigDecimal.ZERO;
    }

    protected void initializeOutput() {
    }

    public abstract String getCalculationVersion();

    @JsonIgnore
    public EsrdClaimData getClaimData() {
        return (EsrdClaimData)((EsrdClaimPricingRequest)this.getInput()).getClaimData();
    }

    @JsonIgnore
    public BundledPaymentData getBundledData() {
        if (this.getPaymentData().getBundledPaymentInformation() == null) {
            this.getPaymentData().setBundledPaymentInformation(new BundledPaymentData());
        }
        return this.getPaymentData().getBundledPaymentInformation();
    }

    @JsonIgnore
    public ComorbidityData getComorbidities() {
        return Optional.ofNullable(this.getClaimData().getComorbidities()).orElse(new ComorbidityData());
    }

    @JsonIgnore
    public EsrdPaymentData getPaymentData() {
        return (EsrdPaymentData)((EsrdClaimPricingResponse)this.getOutput()).getPaymentData();
    }

    @JsonIgnore
    public BundledBillingData getBundledBillingData() {
        return ((EsrdClaimPricingResponse)this.getOutput()).getBundledBillingInformation();
    }

    @JsonIgnore
    public PaymentBillingData getPaymentBillingData() {
        return ((EsrdClaimPricingResponse)this.getOutput()).getPaymentBillingInformation();
    }

    @JsonIgnore
    public OutlierBillingData getOutlierBillingData() {
        return ((EsrdClaimPricingResponse)this.getOutput()).getOutlierBillingInformation();
    }

    @JsonIgnore
    public AdditionalPricingData getAdditionalPricingData() {
        return ((EsrdClaimPricingResponse)this.getOutput()).getAdditionalPricingInformation();
    }

    @JsonIgnore
    public OutpatientProviderData getProviderData() {
        return (OutpatientProviderData)((EsrdClaimPricingRequest)this.getInput()).getProviderData();
    }

    public void applyReturnCode(ReturnCode returnCode) {
        ((EsrdClaimPricingResponse)this.getOutput()).setReturnCodeData(returnCode.toReturnCodeData());
    }

    public boolean matchesReturnCode(ReturnCode expectedCode) {
        return expectedCode.equals((Object)ReturnCode.fromCode(Integer.parseInt(((EsrdClaimPricingResponse)this.getOutput()).getReturnCodeData().getCode())));
    }

    public boolean isLowVolume() {
        return StringUtils.equalsAny(this.getProviderData().getSpecialLocalityIndicator(), "Y", "1", "2");
    }

    public boolean isLowVolumeClaimTierOne() {
        return StringUtils.equals(this.getProviderData().getSpecialLocalityIndicator(), "1");
    }

    public boolean isLowVolumeClaimTierTwo() {
        return StringUtils.equals(this.getProviderData().getSpecialLocalityIndicator(), "2");
    }

    public boolean hasDemoCode(String code) {
        return this.getClaimData().getDemoCodes() != null && this.getClaimData().getDemoCodes().stream().anyMatch(c -> StringUtils.equals(c, code));
    }

    public boolean hasConditionCode(String code) {
        return this.getClaimData().getConditionCodes() != null && this.getClaimData().getConditionCodes().stream().anyMatch(c -> StringUtils.equals(c, code));
    }

    public abstract @FixedValue BigDecimal getAdjustedAverageMapAmountOver17();

    public abstract @FixedValue BigDecimal getAdjustedAverageMapAmountUnder18();

    public abstract @FixedValue BigDecimal getBasePaymentRate();

    public abstract @FixedValue BigDecimal getBsaNationalAverage();

    public abstract @FixedValue BigDecimal getBundledBasePaymentRate();

    public abstract @FixedValue BigDecimal getBundledBasePaymentRateAki();

    public abstract @FixedValue BigDecimal getBundledNationalLaborPercentage();

    public abstract @FixedValue BigDecimal getBundledNationalNonLaborPercent();

    public abstract @FixedValue BigDecimal getCaseMixAge18To44Multiplier();

    public abstract @FixedValue BigDecimal getCaseMixAge45To59Multiplier();

    public abstract @FixedValue BigDecimal getCaseMixAge60To69Multiplier();

    public abstract @FixedValue BigDecimal getCaseMixAge70To79Multiplier();

    public abstract @FixedValue BigDecimal getCaseMixAge80PlusMultiplier();

    public abstract @FixedValue BigDecimal getCaseMixBmiUnderEighteenPointFiveMultiplier();

    public abstract @FixedValue BigDecimal getCaseMixBsaMultiplier();

    public abstract @FixedValue BigDecimal getCaseMixGastrointestinalBleedMultiplier();

    public abstract @FixedValue BigDecimal getCaseMixLowVolumeAdjustmentLessThan4000Multiplier();

    public abstract @FixedValue BigDecimal getCaseMixLowVolumeAdjustmentLessThan3000Multiplier();

    public abstract @FixedValue BigDecimal getCaseMixLowVolumeAdjustment3001To3999Multiplier();

    public abstract @FixedValue BigDecimal getCaseMixMyelodysplasticSyndromeMultiplier();

    public abstract @FixedValue BigDecimal getCaseMixOnsetLessThanOrEqualTo120Multiplier();

    public abstract @FixedValue BigDecimal getCaseMixPericarditisMultiplier();

    public abstract @FixedValue BigDecimal getCaseMixRuralMultiplier();

    public abstract @FixedValue BigDecimal getCaseMixSickleCellMultiplier();

    public abstract @FixedValue BigDecimal getDrugAddOn();

    public abstract @FixedValue BigDecimal getEtcHdpaPercent();

    public abstract BigDecimal getCraTpniesOffset();

    public abstract @FixedValue BigDecimal getExpandedBundle13To17HemodialysisModePaymentMultiplier();

    public abstract @FixedValue BigDecimal getExpandedBundle13To17PeritonealDialysisModePaymentMultiplier();

    public abstract @FixedValue BigDecimal getExpandedBundleUnder13HemodialysisModePaymentMultiplier();

    public abstract @FixedValue BigDecimal getExpandedBundleUnder13PeritonealDialysisModePaymentMultiplier();

    public abstract @FixedValue BigDecimal getFixedDollarLossOver17();

    public abstract @FixedValue BigDecimal getFixedDollarLossUnder18();

    public abstract @FixedValue BigDecimal getLossSharingPercentageOver17();

    public abstract @FixedValue BigDecimal getLossSharingPercentageUnder18();

    public abstract @FixedValue BigDecimal getNationalLaborPercent();

    public abstract @FixedValue BigDecimal getNetworkReductionPerDiemAmount();

    public abstract @FixedValue BigDecimal getNetworkReductionFullAmount();

    public abstract @FixedValue BigDecimal getNationalNonLaborPercent();

    public abstract @FixedValue BigDecimal getSeparatelyBillable13To17HemodialysisModePaymentMultiplier();

    public abstract @FixedValue BigDecimal getSeparatelyBillable13To17PeritonealDialysisModePaymentMultiplier();

    public abstract @FixedValue BigDecimal getSeparatelyBillableAge18To44Multiplier();

    public abstract @FixedValue BigDecimal getSeparatelyBillableAge45To59Multiplier();

    public abstract @FixedValue BigDecimal getSeparatelyBillableAge60To69Multiplier();

    public abstract @FixedValue BigDecimal getSeparatelyBillableAge70To79Multiplier();

    public abstract @FixedValue BigDecimal getSeparatelyBillableAge80PlusMultiplier();

    public abstract @FixedValue BigDecimal getSeparatelyBillableBmiUnderCutoffMultiplier();

    public abstract @FixedValue BigDecimal getSeparatelyBillableBsa();

    public abstract @FixedValue BigDecimal getSeparatelyBillableGastrointestinalBleedMultiplier();

    public abstract @FixedValue BigDecimal getSeparatelyBillableLowVolumeAdjustmentLessThan4000Multiplier();

    public abstract @FixedValue BigDecimal getSeparatelyBillableLowVolumeAdjustmentLessThan3000Multiplier();

    public abstract @FixedValue BigDecimal getSeparatelyBillableLowVolumeAdjustment3000To3999Multiplier();

    public abstract @FixedValue BigDecimal getSeparatelyBillableMyelodysplasticSyndromeMultiplier();

    public abstract @FixedValue BigDecimal getSeparatelyBillableOnsetLessThanOrEqualTo120Multiplier();

    public abstract @FixedValue BigDecimal getSeparatelyBillablePericarditisMultiplier();

    public abstract @FixedValue BigDecimal getSeparatelyBillableRuralMultiplier();

    public abstract @FixedValue BigDecimal getSeparatelyBillableSickleCellMultiplier();

    public abstract @FixedValue BigDecimal getSeparatelyBillableUnder13HemodialysisModePaymentMultiplier();

    public abstract @FixedValue BigDecimal getSeparatelyBillableUnder13PeritonealDialysisModePaymentMultiplier();

    public abstract @FixedValue BigDecimal getTrainingAddOnPaymentAmount();

    public boolean isComorbidityReturnCodeInvalid() {
        return !ArrayUtils.contains(VALID_COMORBIDITY_RETURN_CODES, this.getComorbidities().getCwfReturnCode());
    }

    public boolean areConditionCodesInvalid() {
        return !ArrayUtils.contains(VALID_CONDITION_CODES, this.getClaimData().getConditionCodes());
    }

    public boolean isQipReductionInvalid() {
        String providerQipReduction = this.getProviderData().getHospitalQualityIndicator();
        return StringUtils.isNotBlank(providerQipReduction) && !ArrayUtils.contains(VALID_QIP_REDUCTION_CODES, providerQipReduction);
    }

    public boolean isSpecialLocalityIndicatorInvalid() {
        String providerSpecialLocalityIndicator = this.getProviderData().getSpecialLocalityIndicator();
        return StringUtils.isNotBlank(providerSpecialLocalityIndicator) && !ArrayUtils.contains(VALID_SPECIAL_LOCALITY_INDICATOR_CODES, providerSpecialLocalityIndicator);
    }

    public boolean isProviderTypeInvalid() {
        return !ArrayUtils.contains(VALID_PROVIDER_TYPES, this.getProviderData().getProviderType());
    }

    public boolean isRevenueCodeInvalid() {
        return !ArrayUtils.contains(VALID_REVENUE_CODES, this.getClaimData().getRevenueCode());
    }

    public boolean isCbsaRural() {
        return 2 == this.getCbsa().length();
    }

    public boolean isCbsaUrban() {
        return 5 == this.getCbsa().length();
    }

    @JsonIgnore
    public String getCbsa() {
        return RegExUtils.replacePattern(this.getProviderData().getCbsaActualGeographicLocation(), "^[ 9]{3}", "");
    }

    public boolean isAdultPatient() {
        return this.getPatientAge() > 17;
    }

    public BigDecimal calculateBodyMassIndex() {
        EsrdClaimData claimData = this.getClaimData();
        return claimData.getPatientWeight().divide(BigDecimalUtils.pow(claimData.getPatientHeight(), new BigDecimal("2"), 9), 5, RoundingMode.DOWN).multiply(new BigDecimal("10000"));
    }

    public BigDecimal calculateBodySurfaceArea() {
        EsrdClaimData claimData = this.getClaimData();
        return new BigDecimal(".007184").multiply(BigDecimalUtils.pow(claimData.getPatientHeight(), new BigDecimal(".725"), 9)).multiply(BigDecimalUtils.pow(claimData.getPatientWeight(), new BigDecimal(".425"), 9)).setScale(4, RoundingMode.HALF_UP);
    }

    public boolean isPerDiemClaim() {
        return this.isEsrdHome74() && StringUtils.equalsAny(this.getClaimData().getRevenueCode(), REVENUE_CODE_CONTINUOUS_AMBULATORY_PERITONEAL_DIALYSIS_0841, REVENUE_CODE_CONTINUOUS_CYCLING_PERITONEAL_DIALYSIS_0851);
    }

    @Generated
    public DataTables getDataTables() {
        return this.dataTables;
    }

    @Generated
    public boolean isBlendedPaymentWaived() {
        return this.blendedPaymentWaived;
    }

    @Generated
    public void setBlendedPaymentWaived(boolean blendedPaymentWaived) {
        this.blendedPaymentWaived = blendedPaymentWaived;
    }

    @Generated
    public List<String> getComorbidityCodes() {
        return this.comorbidityCodes;
    }

    @Generated
    public void setComorbidityCodes(List<String> comorbidityCodes) {
        this.comorbidityCodes = comorbidityCodes;
    }

    @Generated
    public BigDecimal getComorbidityMultiplier() {
        return this.comorbidityMultiplier;
    }

    @Generated
    public void setComorbidityMultiplier(BigDecimal comorbidityMultiplier) {
        this.comorbidityMultiplier = comorbidityMultiplier;
    }

    @Generated
    public BigDecimal getConditionCode74PerDiemAmount() {
        return this.conditionCode74PerDiemAmount;
    }

    @Generated
    public void setConditionCode74PerDiemAmount(BigDecimal conditionCode74PerDiemAmount) {
        this.conditionCode74PerDiemAmount = conditionCode74PerDiemAmount;
    }

    @Generated
    public BigDecimal getCraTpniesPayment() {
        return this.craTpniesPayment;
    }

    @Generated
    public void setCraTpniesPayment(BigDecimal craTpniesPayment) {
        this.craTpniesPayment = craTpniesPayment;
    }

    @Generated
    public BigDecimal getTpeapaPayment() {
        return this.tpeapaPayment;
    }

    @Generated
    public void setTpeapaPayment(BigDecimal tpeapaPayment) {
        this.tpeapaPayment = tpeapaPayment;
    }

    @Generated
    public BigDecimal getPostTdapaPayment() {
        return this.postTdapaPayment;
    }

    @Generated
    public void setPostTdapaPayment(BigDecimal postTdapaPayment) {
        this.postTdapaPayment = postTdapaPayment;
    }

    @Generated
    public BigDecimal getCaseMixAdjuster() {
        return this.caseMixAdjuster;
    }

    @Generated
    public void setCaseMixAdjuster(BigDecimal caseMixAdjuster) {
        this.caseMixAdjuster = caseMixAdjuster;
    }

    @Generated
    public BigDecimal getPatientLevelCaseMixAdjusterForPostTdapa() {
        return this.patientLevelCaseMixAdjusterForPostTdapa;
    }

    @Generated
    public void setPatientLevelCaseMixAdjusterForPostTdapa(BigDecimal patientLevelCaseMixAdjusterForPostTdapa) {
        this.patientLevelCaseMixAdjusterForPostTdapa = patientLevelCaseMixAdjusterForPostTdapa;
    }

    @Generated
    public String getCwfReturnCode() {
        return this.cwfReturnCode;
    }

    @Generated
    public void setCwfReturnCode(String cwfReturnCode) {
        this.cwfReturnCode = cwfReturnCode;
    }

    @Generated
    public BigDecimal getFinalAmountWithoutHdpa() {
        return this.finalAmountWithoutHdpa;
    }

    @Generated
    public void setFinalAmountWithoutHdpa(BigDecimal finalAmountWithoutHdpa) {
        this.finalAmountWithoutHdpa = finalAmountWithoutHdpa;
    }

    @Generated
    public BigDecimal getFinalAmountWithHdpa() {
        return this.finalAmountWithHdpa;
    }

    @Generated
    public void setFinalAmountWithHdpa(BigDecimal finalAmountWithHdpa) {
        this.finalAmountWithHdpa = finalAmountWithHdpa;
    }

    @Generated
    public BigDecimal getFinalAmountWithoutPpa() {
        return this.finalAmountWithoutPpa;
    }

    @Generated
    public void setFinalAmountWithoutPpa(BigDecimal finalAmountWithoutPpa) {
        this.finalAmountWithoutPpa = finalAmountWithoutPpa;
    }

    @Generated
    public BigDecimal getFinalAmountWithPpa() {
        return this.finalAmountWithPpa;
    }

    @Generated
    public void setFinalAmountWithPpa(BigDecimal finalAmountWithPpa) {
        this.finalAmountWithPpa = finalAmountWithPpa;
    }

    @Generated
    public BigDecimal getFinalAmountWithoutEtc() {
        return this.finalAmountWithoutEtc;
    }

    @Generated
    public void setFinalAmountWithoutEtc(BigDecimal finalAmountWithoutEtc) {
        this.finalAmountWithoutEtc = finalAmountWithoutEtc;
    }

    @Generated
    public BigDecimal getFinalPaymentAmount() {
        return this.finalPaymentAmount;
    }

    @Generated
    public void setFinalPaymentAmount(BigDecimal finalPaymentAmount) {
        this.finalPaymentAmount = finalPaymentAmount;
    }

    @Generated
    public BigDecimal getFullClaimAmount() {
        return this.fullClaimAmount;
    }

    @Generated
    public void setFullClaimAmount(BigDecimal fullClaimAmount) {
        this.fullClaimAmount = fullClaimAmount;
    }

    @Generated
    public BigDecimal getHemoEquivalentDialysisSessions() {
        return this.hemoEquivalentDialysisSessions;
    }

    @Generated
    public void setHemoEquivalentDialysisSessions(BigDecimal hemoEquivalentDialysisSessions) {
        this.hemoEquivalentDialysisSessions = hemoEquivalentDialysisSessions;
    }

    @Generated
    public BigDecimal getNetworkReductionAmount() {
        return this.networkReductionAmount;
    }

    @Generated
    public void setNetworkReductionAmount(BigDecimal networkReductionAmount) {
        this.networkReductionAmount = networkReductionAmount;
    }

    @Generated
    public int getPatientAge() {
        return this.patientAge;
    }

    @Generated
    public void setPatientAge(int patientAge) {
        this.patientAge = patientAge;
    }

    @Generated
    public BigDecimal getPerDiemAmountWithoutHdpa() {
        return this.perDiemAmountWithoutHdpa;
    }

    @Generated
    public void setPerDiemAmountWithoutHdpa(BigDecimal perDiemAmountWithoutHdpa) {
        this.perDiemAmountWithoutHdpa = perDiemAmountWithoutHdpa;
    }

    @Generated
    public BigDecimal getPerDiemAmountWithHdpa() {
        return this.perDiemAmountWithHdpa;
    }

    @Generated
    public void setPerDiemAmountWithHdpa(BigDecimal perDiemAmountWithHdpa) {
        this.perDiemAmountWithHdpa = perDiemAmountWithHdpa;
    }

    @Generated
    public BigDecimal getPerDiemAmountWithoutEtc() {
        return this.perDiemAmountWithoutEtc;
    }

    @Generated
    public void setPerDiemAmountWithoutEtc(BigDecimal perDiemAmountWithoutEtc) {
        this.perDiemAmountWithoutEtc = perDiemAmountWithoutEtc;
    }

    @Generated
    public BigDecimal getPerDiemAmountWithoutPpa() {
        return this.perDiemAmountWithoutPpa;
    }

    @Generated
    public void setPerDiemAmountWithoutPpa(BigDecimal perDiemAmountWithoutPpa) {
        this.perDiemAmountWithoutPpa = perDiemAmountWithoutPpa;
    }

    @Generated
    public BigDecimal getPerDiemAmountWithPpa() {
        return this.perDiemAmountWithPpa;
    }

    @Generated
    public void setPerDiemAmountWithPpa(BigDecimal perDiemAmountWithPpa) {
        this.perDiemAmountWithPpa = perDiemAmountWithPpa;
    }

    @Generated
    public BigDecimal getQipReduction() {
        return this.qipReduction;
    }

    @Generated
    public void setQipReduction(BigDecimal qipReduction) {
        this.qipReduction = qipReduction;
    }

    @Generated
    public BigDecimal getTdapaPayment() {
        return this.tdapaPayment;
    }

    @Generated
    public void setTdapaPayment(BigDecimal tdapaPayment) {
        this.tdapaPayment = tdapaPayment;
    }

    @Generated
    public BigDecimal getTpniesPayment() {
        return this.tpniesPayment;
    }

    @Generated
    public void setTpniesPayment(BigDecimal tpniesPayment) {
        this.tpniesPayment = tpniesPayment;
    }

    @Generated
    public BigDecimal getBundledAdjustedBaseWageAmount() {
        return this.bundledAdjustedBaseWageAmount;
    }

    @Generated
    public void setBundledAdjustedBaseWageAmount(BigDecimal bundledAdjustedBaseWageAmount) {
        this.bundledAdjustedBaseWageAmount = bundledAdjustedBaseWageAmount;
    }

    @Generated
    public BigDecimal getBundledAgeAdjustmentFactor() {
        return this.bundledAgeAdjustmentFactor;
    }

    @Generated
    public void setBundledAgeAdjustmentFactor(BigDecimal bundledAgeAdjustmentFactor) {
        this.bundledAgeAdjustmentFactor = bundledAgeAdjustmentFactor;
    }

    @Generated
    public BigDecimal getBundledBmi() {
        return this.bundledBmi;
    }

    @Generated
    public void setBundledBmi(BigDecimal bundledBmi) {
        this.bundledBmi = bundledBmi;
    }

    @Generated
    public BigDecimal getBundledBmiFactor() {
        return this.bundledBmiFactor;
    }

    @Generated
    public void setBundledBmiFactor(BigDecimal bundledBmiFactor) {
        this.bundledBmiFactor = bundledBmiFactor;
    }

    @Generated
    public BigDecimal getBundledBsa() {
        return this.bundledBsa;
    }

    @Generated
    public void setBundledBsa(BigDecimal bundledBsa) {
        this.bundledBsa = bundledBsa;
    }

    @Generated
    public BigDecimal getBundledBsaFactor() {
        return this.bundledBsaFactor;
    }

    @Generated
    public void setBundledBsaFactor(BigDecimal bundledBsaFactor) {
        this.bundledBsaFactor = bundledBsaFactor;
    }

    @Generated
    public BigDecimal getBundledComorbidityMultiplier() {
        return this.bundledComorbidityMultiplier;
    }

    @Generated
    public void setBundledComorbidityMultiplier(BigDecimal bundledComorbidityMultiplier) {
        this.bundledComorbidityMultiplier = bundledComorbidityMultiplier;
    }

    @Generated
    public BigDecimal getBundledLowVolumeMultiplier() {
        return this.bundledLowVolumeMultiplier;
    }

    @Generated
    public void setBundledLowVolumeMultiplier(BigDecimal bundledLowVolumeMultiplier) {
        this.bundledLowVolumeMultiplier = bundledLowVolumeMultiplier;
    }

    @Generated
    public BigDecimal getBundledLowVolumeTierOneMultiplier() {
        return this.bundledLowVolumeTierOneMultiplier;
    }

    @Generated
    public void setBundledLowVolumeTierOneMultiplier(BigDecimal bundledLowVolumeTierOneMultiplier) {
        this.bundledLowVolumeTierOneMultiplier = bundledLowVolumeTierOneMultiplier;
    }

    @Generated
    public BigDecimal getBundledLowVolumeTierTwoMultiplier() {
        return this.bundledLowVolumeTierTwoMultiplier;
    }

    @Generated
    public void setBundledLowVolumeTierTwoMultiplier(BigDecimal bundledLowVolumeTierTwoMultiplier) {
        this.bundledLowVolumeTierTwoMultiplier = bundledLowVolumeTierTwoMultiplier;
    }

    @Generated
    public BigDecimal getBundledNationalLaborAmount() {
        return this.bundledNationalLaborAmount;
    }

    @Generated
    public void setBundledNationalLaborAmount(BigDecimal bundledNationalLaborAmount) {
        this.bundledNationalLaborAmount = bundledNationalLaborAmount;
    }

    @Generated
    public BigDecimal getBundledNationalNonLaborAmount() {
        return this.bundledNationalNonLaborAmount;
    }

    @Generated
    public void setBundledNationalNonLaborAmount(BigDecimal bundledNationalNonLaborAmount) {
        this.bundledNationalNonLaborAmount = bundledNationalNonLaborAmount;
    }

    @Generated
    public BigDecimal getBundledBaseWageAmount() {
        return this.bundledBaseWageAmount;
    }

    @Generated
    public void setBundledBaseWageAmount(BigDecimal bundledBaseWageAmount) {
        this.bundledBaseWageAmount = bundledBaseWageAmount;
    }

    @Generated
    public BigDecimal getBundledOnsetFactor() {
        return this.bundledOnsetFactor;
    }

    @Generated
    public void setBundledOnsetFactor(BigDecimal bundledOnsetFactor) {
        this.bundledOnsetFactor = bundledOnsetFactor;
    }

    @Generated
    public BigDecimal getBundledRuralMultiplier() {
        return this.bundledRuralMultiplier;
    }

    @Generated
    public void setBundledRuralMultiplier(BigDecimal bundledRuralMultiplier) {
        this.bundledRuralMultiplier = bundledRuralMultiplier;
    }

    @Generated
    public BigDecimal getBundledWageAdjustedTrainingAmount() {
        return this.bundledWageAdjustedTrainingAmount;
    }

    @Generated
    public void setBundledWageAdjustedTrainingAmount(BigDecimal bundledWageAdjustedTrainingAmount) {
        this.bundledWageAdjustedTrainingAmount = bundledWageAdjustedTrainingAmount;
    }

    @Generated
    public BigDecimal getBundledWageIndex() {
        return this.bundledWageIndex;
    }

    @Generated
    public void setBundledWageIndex(BigDecimal bundledWageIndex) {
        this.bundledWageIndex = bundledWageIndex;
    }

    @Generated
    public BigDecimal getPpaAdjustmentPercent() {
        return this.ppaAdjustmentPercent;
    }

    @Generated
    public void setPpaAdjustmentPercent(BigDecimal ppaAdjustmentPercent) {
        this.ppaAdjustmentPercent = ppaAdjustmentPercent;
    }

    @Generated
    public BigDecimal getLowVolumeBundledAdjustedBaseWageAmount() {
        return this.lowVolumeBundledAdjustedBaseWageAmount;
    }

    @Generated
    public void setLowVolumeBundledAdjustedBaseWageAmount(BigDecimal lowVolumeBundledAdjustedBaseWageAmount) {
        this.lowVolumeBundledAdjustedBaseWageAmount = lowVolumeBundledAdjustedBaseWageAmount;
    }

    @Generated
    public BigDecimal getLowVolumeOutlierCaseMixAdjustedPredictedSvcsMapPerTrt() {
        return this.lowVolumeOutlierCaseMixAdjustedPredictedSvcsMapPerTrt;
    }

    @Generated
    public void setLowVolumeOutlierCaseMixAdjustedPredictedSvcsMapPerTrt(BigDecimal lowVolumeOutlierCaseMixAdjustedPredictedSvcsMapPerTrt) {
        this.lowVolumeOutlierCaseMixAdjustedPredictedSvcsMapPerTrt = lowVolumeOutlierCaseMixAdjustedPredictedSvcsMapPerTrt;
    }

    @Generated
    public BigDecimal getLowVolumeFinalPaymentAmount() {
        return this.lowVolumeFinalPaymentAmount;
    }

    @Generated
    public void setLowVolumeFinalPaymentAmount(BigDecimal lowVolumeFinalPaymentAmount) {
        this.lowVolumeFinalPaymentAmount = lowVolumeFinalPaymentAmount;
    }

    @Generated
    public BigDecimal getLowVolumeOutlierPayment() {
        return this.lowVolumeOutlierPayment;
    }

    @Generated
    public void setLowVolumeOutlierPayment(BigDecimal lowVolumeOutlierPayment) {
        this.lowVolumeOutlierPayment = lowVolumeOutlierPayment;
    }

    @Generated
    public BigDecimal getLowVolumeOutlierPredictedMap() {
        return this.lowVolumeOutlierPredictedMap;
    }

    @Generated
    public void setLowVolumeOutlierPredictedMap(BigDecimal lowVolumeOutlierPredictedMap) {
        this.lowVolumeOutlierPredictedMap = lowVolumeOutlierPredictedMap;
    }

    @Generated
    public BigDecimal getLowVolumeOutlierPredictedSvcsMap() {
        return this.lowVolumeOutlierPredictedSvcsMap;
    }

    @Generated
    public void setLowVolumeOutlierPredictedSvcsMap(BigDecimal lowVolumeOutlierPredictedSvcsMap) {
        this.lowVolumeOutlierPredictedSvcsMap = lowVolumeOutlierPredictedSvcsMap;
    }

    @Generated
    public BigDecimal getOutlierAdjustedAverageMapAmount() {
        return this.outlierAdjustedAverageMapAmount;
    }

    @Generated
    public void setOutlierAdjustedAverageMapAmount(BigDecimal outlierAdjustedAverageMapAmount) {
        this.outlierAdjustedAverageMapAmount = outlierAdjustedAverageMapAmount;
    }

    @Generated
    public BigDecimal getOutlierAgeAdjustmentFactor() {
        return this.outlierAgeAdjustmentFactor;
    }

    @Generated
    public void setOutlierAgeAdjustmentFactor(BigDecimal outlierAgeAdjustmentFactor) {
        this.outlierAgeAdjustmentFactor = outlierAgeAdjustmentFactor;
    }

    @Generated
    public BigDecimal getOutlierBmi() {
        return this.outlierBmi;
    }

    @Generated
    public void setOutlierBmi(BigDecimal outlierBmi) {
        this.outlierBmi = outlierBmi;
    }

    @Generated
    public BigDecimal getOutlierBmiFactor() {
        return this.outlierBmiFactor;
    }

    @Generated
    public void setOutlierBmiFactor(BigDecimal outlierBmiFactor) {
        this.outlierBmiFactor = outlierBmiFactor;
    }

    @Generated
    public BigDecimal getOutlierBsa() {
        return this.outlierBsa;
    }

    @Generated
    public void setOutlierBsa(BigDecimal outlierBsa) {
        this.outlierBsa = outlierBsa;
    }

    @Generated
    public BigDecimal getOutlierBsaFactor() {
        return this.outlierBsaFactor;
    }

    @Generated
    public void setOutlierBsaFactor(BigDecimal outlierBsaFactor) {
        this.outlierBsaFactor = outlierBsaFactor;
    }

    @Generated
    public BigDecimal getOutlierCaseMixAdjPredictedMapTrt() {
        return this.outlierCaseMixAdjPredictedMapTrt;
    }

    @Generated
    public void setOutlierCaseMixAdjPredictedMapTrt(BigDecimal outlierCaseMixAdjPredictedMapTrt) {
        this.outlierCaseMixAdjPredictedMapTrt = outlierCaseMixAdjPredictedMapTrt;
    }

    @Generated
    public BigDecimal getOutlierComorbidityMultiplier() {
        return this.outlierComorbidityMultiplier;
    }

    @Generated
    public void setOutlierComorbidityMultiplier(BigDecimal outlierComorbidityMultiplier) {
        this.outlierComorbidityMultiplier = outlierComorbidityMultiplier;
    }

    @Generated
    public BigDecimal getOutlierHemoEquivalentPayment() {
        return this.outlierHemoEquivalentPayment;
    }

    @Generated
    public void setOutlierHemoEquivalentPayment(BigDecimal outlierHemoEquivalentPayment) {
        this.outlierHemoEquivalentPayment = outlierHemoEquivalentPayment;
    }

    @Generated
    public BigDecimal getOutlierImputedMapAmount() {
        return this.outlierImputedMapAmount;
    }

    @Generated
    public void setOutlierImputedMapAmount(BigDecimal outlierImputedMapAmount) {
        this.outlierImputedMapAmount = outlierImputedMapAmount;
    }

    @Generated
    public BigDecimal getOutlierFixedDollarLoss() {
        return this.outlierFixedDollarLoss;
    }

    @Generated
    public void setOutlierFixedDollarLoss(BigDecimal outlierFixedDollarLoss) {
        this.outlierFixedDollarLoss = outlierFixedDollarLoss;
    }

    @Generated
    public BigDecimal getOutlierLossSharingPercentage() {
        return this.outlierLossSharingPercentage;
    }

    @Generated
    public void setOutlierLossSharingPercentage(BigDecimal outlierLossSharingPercentage) {
        this.outlierLossSharingPercentage = outlierLossSharingPercentage;
    }

    @Generated
    public BigDecimal getOutlierLowVolumeMultiplier() {
        return this.outlierLowVolumeMultiplier;
    }

    @Generated
    public void setOutlierLowVolumeMultiplier(BigDecimal outlierLowVolumeMultiplier) {
        this.outlierLowVolumeMultiplier = outlierLowVolumeMultiplier;
    }

    @Generated
    public BigDecimal getOutlierLowVolumeTierOneMultiplier() {
        return this.outlierLowVolumeTierOneMultiplier;
    }

    @Generated
    public void setOutlierLowVolumeTierOneMultiplier(BigDecimal outlierLowVolumeTierOneMultiplier) {
        this.outlierLowVolumeTierOneMultiplier = outlierLowVolumeTierOneMultiplier;
    }

    @Generated
    public BigDecimal getOutlierLowVolumeTierTwoMultiplier() {
        return this.outlierLowVolumeTierTwoMultiplier;
    }

    @Generated
    public void setOutlierLowVolumeTierTwoMultiplier(BigDecimal outlierLowVolumeTierTwoMultiplier) {
        this.outlierLowVolumeTierTwoMultiplier = outlierLowVolumeTierTwoMultiplier;
    }

    @Generated
    public BigDecimal getOutlierOnsetFactor() {
        return this.outlierOnsetFactor;
    }

    @Generated
    public void setOutlierOnsetFactor(BigDecimal outlierOnsetFactor) {
        this.outlierOnsetFactor = outlierOnsetFactor;
    }

    @Generated
    public BigDecimal getOutlierRuralMultiplier() {
        return this.outlierRuralMultiplier;
    }

    @Generated
    public void setOutlierRuralMultiplier(BigDecimal outlierRuralMultiplier) {
        this.outlierRuralMultiplier = outlierRuralMultiplier;
    }

    @Generated
    public BigDecimal getOutlierPayment() {
        return this.outlierPayment;
    }

    @Generated
    public void setOutlierPayment(BigDecimal outlierPayment) {
        this.outlierPayment = outlierPayment;
    }

    @Generated
    public BigDecimal getOutlierPredictedMapAmount() {
        return this.outlierPredictedMapAmount;
    }

    @Generated
    public void setOutlierPredictedMapAmount(BigDecimal outlierPredictedMapAmount) {
        this.outlierPredictedMapAmount = outlierPredictedMapAmount;
    }

    @Generated
    public BigDecimal getOutlierPredictedSvcsMapAmount() {
        return this.outlierPredictedSvcsMapAmount;
    }

    @Generated
    public void setOutlierPredictedSvcsMapAmount(BigDecimal outlierPredictedSvcsMapAmount) {
        this.outlierPredictedSvcsMapAmount = outlierPredictedSvcsMapAmount;
    }

    @Generated
    public boolean isAcuteComorbidityFound() {
        return this.acuteComorbidityFound;
    }

    @Generated
    public void setAcuteComorbidityFound(boolean acuteComorbidityFound) {
        this.acuteComorbidityFound = acuteComorbidityFound;
    }

    @Generated
    public boolean isChronicComorbidityFound() {
        return this.chronicComorbidityFound;
    }

    @Generated
    public void setChronicComorbidityFound(boolean chronicComorbidityFound) {
        this.chronicComorbidityFound = chronicComorbidityFound;
    }

    @Generated
    public boolean isLowBmiClaim() {
        return this.lowBmiClaim;
    }

    @Generated
    public void setLowBmiClaim(boolean lowBmiClaim) {
        this.lowBmiClaim = lowBmiClaim;
    }

    @Generated
    public boolean isLowVolumeClaim() {
        return this.lowVolumeClaim;
    }

    @Generated
    public void setLowVolumeClaim(boolean lowVolumeClaim) {
        this.lowVolumeClaim = lowVolumeClaim;
    }

    @Generated
    public boolean isOutlierClaim() {
        return this.outlierClaim;
    }

    @Generated
    public void setOutlierClaim(boolean outlierClaim) {
        this.outlierClaim = outlierClaim;
    }

    @Generated
    public boolean isPediatricClaim() {
        return this.pediatricClaim;
    }

    @Generated
    public void setPediatricClaim(boolean pediatricClaim) {
        this.pediatricClaim = pediatricClaim;
    }

    @Generated
    public boolean isOnsetRecent() {
        return this.onsetRecent;
    }

    @Generated
    public void setOnsetRecent(boolean onsetRecent) {
        this.onsetRecent = onsetRecent;
    }

    @Generated
    public boolean isTrainingClaim() {
        return this.trainingClaim;
    }

    @Generated
    public void setTrainingClaim(boolean trainingClaim) {
        this.trainingClaim = trainingClaim;
    }

    @Generated
    public boolean isAki84() {
        return this.aki84;
    }

    @Generated
    public void setAki84(boolean aki84) {
        this.aki84 = aki84;
    }

    @Generated
    public boolean isEsrdFacility() {
        return this.esrdFacility;
    }

    @Generated
    public void setEsrdFacility(boolean esrdFacility) {
        this.esrdFacility = esrdFacility;
    }

    @Generated
    public boolean isAkiTraining8473() {
        return this.akiTraining8473;
    }

    @Generated
    public void setAkiTraining8473(boolean akiTraining8473) {
        this.akiTraining8473 = akiTraining8473;
    }

    @Generated
    public boolean isAkiHome8474() {
        return this.akiHome8474;
    }

    @Generated
    public void setAkiHome8474(boolean akiHome8474) {
        this.akiHome8474 = akiHome8474;
    }

    @Generated
    public boolean isAkiRetraining8487() {
        return this.akiRetraining8487;
    }

    @Generated
    public void setAkiRetraining8487(boolean akiRetraining8487) {
        this.akiRetraining8487 = akiRetraining8487;
    }

    @Generated
    public boolean isEsrdTraining73() {
        return this.esrdTraining73;
    }

    @Generated
    public void setEsrdTraining73(boolean esrdTraining73) {
        this.esrdTraining73 = esrdTraining73;
    }

    @Generated
    public boolean isEsrdHome74() {
        return this.esrdHome74;
    }

    @Generated
    public void setEsrdHome74(boolean esrdHome74) {
        this.esrdHome74 = esrdHome74;
    }

    @Generated
    public boolean isEsrdBackup76() {
        return this.esrdBackup76;
    }

    @Generated
    public void setEsrdBackup76(boolean esrdBackup76) {
        this.esrdBackup76 = esrdBackup76;
    }

    @Generated
    public boolean isAkiFacility84() {
        return this.akiFacility84;
    }

    @Generated
    public void setAkiFacility84(boolean akiFacility84) {
        this.akiFacility84 = akiFacility84;
    }

    @Generated
    public boolean isEsrdRetraining87() {
        return this.esrdRetraining87;
    }

    @Generated
    public void setEsrdRetraining87(boolean esrdRetraining87) {
        this.esrdRetraining87 = esrdRetraining87;
    }
}

