/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.bundled_factors.low_volume;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdPaymentData;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import java.math.RoundingMode;

public class CalculatePaymentAmounts
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        calculationContext.setLowVolumeFinalPaymentAmount(calculationContext.getLowVolumeFinalPaymentAmount().subtract(calculationContext.getFinalPaymentAmount()).setScale(4, RoundingMode.HALF_UP));
        calculationContext.setLowVolumeOutlierPayment(calculationContext.getLowVolumeOutlierPayment().subtract(calculationContext.getOutlierPayment()));
        calculationContext.setLowVolumeFinalPaymentAmount(calculationContext.getLowVolumeFinalPaymentAmount().add(calculationContext.getLowVolumeOutlierPayment()));
        EsrdPaymentData paymentData = calculationContext.getPaymentData();
        paymentData.setLowVolumeAmount(calculationContext.getLowVolumeFinalPaymentAmount().abs().setScale(2, RoundingMode.DOWN));
    }
}

