/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.move_results;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.esrd.api.v2.AdditionalPricingData;
import gov.cms.fiss.pricers.esrd.api.v2.BundledBillingData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdPaymentData;
import gov.cms.fiss.pricers.esrd.api.v2.OutlierBillingData;
import gov.cms.fiss.pricers.esrd.api.v2.PaymentBillingData;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import java.math.BigDecimal;

public class MoveAdditionalDataResults
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    private static final BigDecimal MAX_OUTLIER_IMPUTED_MAP_AMOUNT = new BigDecimal("9999.9999");

    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        EsrdPaymentData paymentData = calculationContext.getPaymentData();
        PaymentBillingData paymentBillingData = calculationContext.getPaymentBillingData();
        paymentBillingData.setDrugAddOnAmount(calculationContext.getDrugAddOn());
        paymentBillingData.setCbsaWagePaymentRate(calculationContext.getBasePaymentRate());
        paymentBillingData.setPatientAge(calculationContext.getPatientAge());
        paymentBillingData.setCbsaPercent(BigDecimal.ONE);
        paymentBillingData.setCompositeCbsaBlendPercent(BigDecimal.ZERO);
        paymentBillingData.setBundledCbsaBlendPercent(BigDecimal.ONE);
        BundledBillingData bundledBillingData = calculationContext.getBundledBillingData();
        bundledBillingData.setBundledBodySurfaceAreaFactor(calculationContext.getBundledBsa());
        bundledBillingData.setBundledBodyMassIndexFactor(calculationContext.getBundledBmi());
        bundledBillingData.setBundledOnsetFactor(calculationContext.getBundledOnsetFactor());
        bundledBillingData.setBundledComorbidityMultiplier(calculationContext.getBundledComorbidityMultiplier());
        bundledBillingData.setBundledLowVolumeFacilityAdjustmentPercent(calculationContext.getBundledLowVolumeMultiplier());
        OutlierBillingData outlierBillingData = calculationContext.getOutlierBillingData();
        AdditionalPricingData additionalPricingData = calculationContext.getAdditionalPricingData();
        outlierBillingData.setOutlierAgeAdjustmentFactor(calculationContext.getOutlierAgeAdjustmentFactor());
        outlierBillingData.setOutlierBodySurfaceArea(calculationContext.getOutlierBsa());
        additionalPricingData.setOutlierSeparatelyBillableBsaAmount(calculationContext.getSeparatelyBillableBsa());
        outlierBillingData.setOutlierBodySurfaceAreaFactor(calculationContext.getOutlierBsaFactor());
        outlierBillingData.setOutlierBodyMassIndex(calculationContext.getOutlierBmi());
        outlierBillingData.setOutlierBodyMassIndexFactor(calculationContext.getOutlierBmiFactor());
        outlierBillingData.setOutlierOnsetFactor(calculationContext.getOutlierOnsetFactor());
        outlierBillingData.setOutlierComorbidityMultiplier(calculationContext.getOutlierComorbidityMultiplier());
        outlierBillingData.setOutlierPredictedServicesMapAmount(calculationContext.getOutlierPredictedSvcsMapAmount());
        additionalPricingData.setOutlierCaseMixPredictedMapAmount(calculationContext.getOutlierCaseMixAdjPredictedMapTrt());
        additionalPricingData.setOutlierHemoEquivalentDialysisSessionsAmount(calculationContext.getHemoEquivalentDialysisSessions());
        outlierBillingData.setOutlierLowVolumeMultiplier(calculationContext.getOutlierLowVolumeMultiplier());
        outlierBillingData.setOutlierAverageAdjustedMapAmount(calculationContext.getOutlierAdjustedAverageMapAmount());
        BigDecimal outlierImputedMapAmount = calculationContext.getOutlierImputedMapAmount();
        if (BigDecimalUtils.isGreaterThan(outlierImputedMapAmount, MAX_OUTLIER_IMPUTED_MAP_AMOUNT)) {
            outlierImputedMapAmount = MAX_OUTLIER_IMPUTED_MAP_AMOUNT;
        }
        outlierBillingData.setOutlierImputedMapAmount(outlierImputedMapAmount);
        outlierBillingData.setOutlierFixedDollarLossAmount(calculationContext.getOutlierFixedDollarLoss());
        outlierBillingData.setOutlierLossSharingPercent(calculationContext.getOutlierLossSharingPercentage());
        outlierBillingData.setOutlierPredictedMapAmount(calculationContext.getOutlierPredictedMapAmount());
        additionalPricingData.setCompositeRateBsaMultiplier(EsrdPricerContext.COMPOSITE_RATE_BSA_MULTIPLIER);
        additionalPricingData.setCompositeRateBmiMultiplier(EsrdPricerContext.COMPOSITE_RATE_BMI_UNDER_CUTOFF_MULTIPLIER);
        additionalPricingData.setDrugAndBiologicalAdjustmentAmount(new BigDecimal("0.49"));
        additionalPricingData.setCaseMixBsaMultiplier(calculationContext.getCaseMixBsaMultiplier());
        additionalPricingData.setCaseMixBmiUnderEighteenPointFiveMultiplier(calculationContext.getCaseMixBmiUnderEighteenPointFiveMultiplier());
        additionalPricingData.setBundledBasePaymentRate(calculationContext.getBundledBasePaymentRate());
        paymentData.setFinalWageIndex(calculationContext.getBundledWageIndex());
        additionalPricingData.setBundledAdjustedBaseWageAmount(calculationContext.getBundledAdjustedBaseWageAmount());
        additionalPricingData.setBundledWageAdjustmentTrainingAmount(calculationContext.getBundledWageAdjustedTrainingAmount());
        additionalPricingData.setTrainingAddOnPaymentAmount(calculationContext.getTrainingAddOnPaymentAmount());
        additionalPricingData.setCompositePaymentRate(BigDecimal.ZERO);
    }
}

