/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.rules_2024;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import gov.cms.fiss.pricers.esrd.core.codes.ReturnCode;

public class SetCondition2025For2024AndEarlier
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public boolean shouldExecute(EsrdPricerContext calculationContext) {
        return calculationContext.matchesReturnCode(ReturnCode.CALCULATION_STARTED_00);
    }

    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        EsrdClaimData billingRecord = calculationContext.getClaimData();
        if (billingRecord.getConditionCodes() != null && billingRecord.getConditionCodes().size() > 1) {
            calculationContext.applyReturnCode(ReturnCode.INVALID_CONDITION_CODE_58);
        }
        if (billingRecord.getConditionCodes() == null) {
            calculationContext.setEsrdFacility(true);
        } else if (calculationContext.hasConditionCode("84")) {
            calculationContext.setAki84(true);
        } else if (calculationContext.hasConditionCode("73")) {
            calculationContext.setEsrdTraining73(true);
        } else if (calculationContext.hasConditionCode("74")) {
            calculationContext.setEsrdHome74(true);
        } else if (calculationContext.hasConditionCode("76")) {
            calculationContext.setEsrdBackup76(true);
        } else if (calculationContext.hasConditionCode("87")) {
            calculationContext.setEsrdRetraining87(true);
        } else {
            calculationContext.applyReturnCode(ReturnCode.INVALID_CONDITION_CODE_58);
        }
    }
}

