/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.rules_2024.bundled_factors.transitional_payments;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateTpeapaPayment
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        if (calculationContext.isPediatricClaim()) {
            calculationContext.setTpeapaPayment(calculationContext.getBundledAdjustedBaseWageAmount().multiply(new BigDecimal("0.30")));
            if (calculationContext.isPerDiemClaim()) {
                calculationContext.setTpeapaPayment(calculationContext.getTpeapaPayment().multiply(new BigDecimal(3)).divide(new BigDecimal(7), 4, RoundingMode.DOWN));
            }
        }
    }
}

