/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.rules_2025;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateBundledPpsFinalPaymentRate2025
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        if (calculationContext.isPerDiemClaim()) {
            calculationContext.setFinalAmountWithoutEtc(calculationContext.getPerDiemAmountWithoutEtc().setScale(4, RoundingMode.HALF_UP));
            calculationContext.setFullClaimAmount(calculationContext.getBundledAdjustedBaseWageAmount().multiply(new BigDecimal(claimData.getDialysisSessionCount()).multiply(new BigDecimal(3))).divide(new BigDecimal(7), 2, RoundingMode.HALF_UP));
        } else {
            calculationContext.setFinalAmountWithoutEtc(calculationContext.getBundledAdjustedBaseWageAmount().add(calculationContext.getBundledWageAdjustedTrainingAmount()).setScale(4, RoundingMode.HALF_UP));
        }
    }
}

