/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.rules_2025.bundled_factors.outliers;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdPaymentData;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateOutlierPerDiem2025
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        EsrdPaymentData paymentData = calculationContext.getPaymentData();
        EsrdClaimData claimData = calculationContext.getClaimData();
        paymentData.setOutlierNonPerDiemPaymentAmount(calculationContext.getOutlierPayment());
        if (calculationContext.isPerDiemClaim()) {
            calculationContext.setOutlierPayment(calculationContext.getOutlierPayment().multiply(new BigDecimal(claimData.getDialysisSessionCount()).multiply(new BigDecimal(3))).divide(new BigDecimal(7), 9, RoundingMode.DOWN));
        }
    }
}

