/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.rules_2025.bundled_factors.transitional_payments;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;

public class CalculatePostTdapaAddOn2025
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        if (LocalDateUtils.isAfterOrEqual(claimData.getServiceThroughDate(), LocalDate.of(2025, 1, 1)) && LocalDateUtils.isBeforeOrEqual(claimData.getServiceThroughDate(), LocalDate.of(2025, 12, 31))) {
            this.determinePostTdapaAmount(calculationContext);
        }
    }

    protected void determinePostTdapaAmount(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        if (LocalDateUtils.isBeforeOrEqual(claimData.getServiceThroughDate(), LocalDate.of(2025, 9, 30))) {
            calculationContext.setPostTdapaPayment(new BigDecimal("0.4601"));
        } else {
            calculationContext.setPostTdapaPayment(new BigDecimal("0.4697"));
        }
        calculationContext.setPostTdapaPayment(calculationContext.getPostTdapaPayment().multiply(calculationContext.getCaseMixAdjuster()));
        if (calculationContext.isPediatricClaim()) {
            calculationContext.setPostTdapaPayment(calculationContext.getPostTdapaPayment().multiply(BigDecimal.valueOf(1.3)));
        }
        if (calculationContext.isPerDiemClaim()) {
            calculationContext.setPostTdapaPayment(calculationContext.getPostTdapaPayment().multiply(new BigDecimal(3)).divide(new BigDecimal(7), 4, RoundingMode.HALF_UP));
        }
    }
}

