// Generated by delombok at Tue Nov 26 15:51:05 UTC 2024
package gov.cms.fiss.pricers.esrd.core.codes;

import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public enum ReturnCode {
  /**
   * Initial return code validation; indicates claim processing is in progress.
   */
  CALCULATION_STARTED_00(0, "CALCULATION STARTED", "Calculation started"), /**
   * ESRD PPS Payment calculated - no adjustments.
   */
  PAYMENT_NO_ADJUSTMENTS_02(2, "PAYMENT NO ADJUSTMENTS", "Payment no adjustments"), /**
   * ESRD PPS Payment calculated w/outlier.
   */
  OUTLIER_PAYMENT_03(3, "OUTLIER PAYMENT", "Outlier payment"), /**
   * ESRD PPS Payment calculated w/acute comorbid.
   */
  PAYMENT_WITH_ACUTE_COMORBIDITY_04(4, "PAYMENT WITH ACUTE COMORBIDITY", "Payment with acute comorbidity"), /**
   * ESRD PPS Payment calculated w/chronic comorbid.
   */
  PAYMENT_WITH_CHRONIC_COMORBIDITY_05(5, "PAYMENT WITH CHRONIC COMORBIDITY", "Payment with chronic comorbidity"), /**
   * ESRD PPS Payment calculated w/acute comorbid, outlier.
   */
  OUTLIER_PAYMENT_WITH_ACUTE_COMORBIDITY_06(6, "OUTLIER PAYMENT WITH ACUTE COMORBIDITY", "Outlier payment with acute comorbidity"), /**
   * ESRD PPS Payment calculated w/chronic comorbid, outlier.
   */
  OUTLIER_PAYMENT_WITH_CHRONIC_COMORBIDITY_07(7, "OUTLIER PAYMENT WITH CHRONIC COMORBIDITY", "Outlier payment with chronic comorbidity"), /**
   * ESRD PPS Payment calculated w/onset.
   */
  PAYMENT_WITH_ONSET_08(8, "PAYMENT WITH ONSET", "Payment with onset"), /**
   * ESRD PPS Payment calculated w/onset, outlier.
   */
  OUTLIER_PAYMENT_WITH_ONSET_09(9, "OUTLIER PAYMENT WITH ONSET", "Outlier payment with onset"), /**
   * ESRD PPS Payment calculated w/low volume.
   */
  LOW_VOLUME_PAYMENT_10(10, "LOW VOLUME PAYMENT", "Low volume payment"), /**
   * ESRD PPS Payment calculated w/training.
   */
  TRAINING_PAYMENT_11(11, "TRAINING PAYMENT", "Training payment"), /**
   * ESRD PPS Payment calculated w/low volume, training.
   */
  LOW_VOLUME_TRAINING_PAYMENT_12(12, "LOW VOLUME TRAINING PAYMENT", "Low volume training payment"), /**
   * ESRD PPS Payment calculated w/multiple adjustments (reserved for future use).
   */
  PAYMENT_WITH_MULTIPLE_ADJUSTMENTS_13(13, "PAYMENT WITH MULTIPLE ADJUSTMENTS", "Payment with multiple adjustments"), /**
   * ESRD PPS Payment calculated w/pediatric.
   */
  PEDIATRIC_PAYMENT_14(14, "PEDIATRIC PAYMENT", "Pediatric payment"), /**
   * ESRD PPS Payment calculated w/pediatric, training.
   */
  PEDIATRIC_PAYMENT_TRAINING_15(15, "PEDIACTRIC PAYMENT TRAINING", "Pediatric payment training"), /**
   * ESRD PPS Payment calculated w/pediatric, outlier.
   */
  OUTLIER_PEDIATRIC_PAYMENT_16(16, "OUTLIER PEDIATRIC PAYMENT", "Outlier pediatric payment"), /**
   * ESRD PPS Payment calculated w/pediatric, outlier, training.
   */
  OUTLIER_PEDIATRIC_TRAINING_PAYMENT_17(17, "OUTLIER PEDIATRIC TRAINING PAYMENT", "Outlier pediatric training payment"), /**
   * ESRD PPS Payment calculated w/acute comorbid, outlier, low volume.
   */
  LOW_VOLUME_OUTLIER_PAYMENT_WITH_ACUTE_COMORBIDITY_18(18, "LOW VOLUME OUTLIER PAYMENT WITH ACUTE COMORBIDITY", "Low volume outlier payment with acute comorbidity"), /**
   * ESRD PPS Payment calculated w/acute comorbid, outlier, low volume, training.
   */
  LOW_VOLUME_OUTLIER_TRAINING_PAYMENT_WITH_ACUTE_COMORBIDITY_19(19, "LOW VOLUME OUTLIER TRAINING PAYMENT WITH ACUTE COMORBIDITY", "Low volume outlier training payment with acute comorbidity"), /**
   * ESRD PPS Payment calculated w/acute comorbid, low volume.
   */
  LOW_VOLUME_PAYMENT_WITH_ACUTE_COMORBIDITY_20(20, "LOW VOLUME PAYMENT WITH ACUTE COMORBIDITY", "Low volume payment with acute comorbidity"), /**
   * ESRD PPS Payment calculated w/acute comorbid, low volume, training.
   */
  LOW_VOLUME_TRAINING_PAYMENT_WITH_ACUTE_COMORBIDITY_21(21, "LOW VOLUME TRAINING PAYMENT WITH ACUTE COMORBIDITY", "Low volume training payment with acute comorbidity"), /**
   * ESRD PPS Payment calculated w/acute comorbid, training.
   */
  TRAINING_PAYMENT_WITH_ACUTE_COMORBIDITY_22(22, "TRAINING PAYMENT WITH ACUTE COMORBIDITY", "Training payment with acute comorbidity"), /**
   * ESRD PPS Payment calculated w/chronic comorbid, outlier, low volume.
   */
  LOW_VOLUME_OUTLIER_PAYMENT_WITH_CHRONIC_COMORBIDITY_23(23, "LOW VOLUME OUTLIER PAYMENT WITH CHRONIC COMORBIDITY", "Low volume outlier payment with chronic comorbidity"), /**
   * ESRD PPS Payment calculated w/chronic comorbid, outlier, low volume, training.
   */
  LOW_VOLUME_OUTLIER_TRAINING_PAYMENT_WITH_CHRONIC_COMORBIDITY_24(24, "LOW VOLUME OUTLIER TRAINING PAYMENT WITH CHRONIC COMORBIDITY", "Low volume outlier training payment with chronic comorbidity"), /**
   * ESRD PPS Payment calculated w/chronic comorbid, low volume.
   */
  LOW_VOLUME_PAYMENT_WITH_CHRONIC_COMORBIDITY_25(25, "LOW VOLUME PAYMENT WITH CHRONIC COMORBIDITY", "Low volume payment with chronic comorbidity"), /**
   * ESRD PPS Payment calculated w/chronic comorbid, low volume, training.
   */
  LOW_VOLUME_TRAINING_PAYMENT_WITH_CHRONIC_COMORBIDITY_26(26, "LOW VOLUME TRAINING PAYMENT WITH CHRONIC COMORBIDITY", "Low volume training payment with chronic comorbidity"), /**
   * ESRD PPS Payment calculated w/chronic comorbid, training.
   */
  TRAINING_PAYMENT_WITH_CHRONIC_COMORBIDITY_27(27, "TRAINING PAYMENT WITH CHRONIC COMORBIDITY", "Training payment with chronic comorbidity"), /**
   * ESRD PPS Payment calculated w/outlier, low volume.
   */
  LOW_VOLUME_OUTLIER_PAYMENT_28(28, "LOW VOLUME OUTLIER PAYMENT", "Low volume outlier payment"), /**
   * ESRD PPS Payment calculated w/outlier, low volume, training.
   */
  LOW_VOLUME_OUTLIER_TRAINING_PAYMENT_29(29, "LOW VOLUME OUTLIER TRAINING PAYMENT", "Low volume outlier training payment"), /**
   * ESRD PPS Payment calculated w/onset, outlier, low volume.
   */
  LOW_VOLUME_OUTLIER_PAYMENT_WITH_ONSET_30(30, "LOW VOLUME OUTLIER PAYMENT WITH ONSET", "Low volume outlier payment with onset"), /**
   * ESRD PPS Payment calculated w/low BMI.
   */
  PAYMENT_WITH_LOW_BMI_31(31, "PAYMENT WITH LOW BMI", "Payment with low BMI"), /**
   * ESRD PPS Payment calculated w/low volume, onset.
   */
  LOW_VOLUME_PAYMENT_WITH_ONSET_32(32, "LOW VOLUME PAYMENT WITH ONSET", "Low volume payment with onset"), /**
   * ESRD PPS Payment calculated w/outlier, training.
   */
  OUTLIER_TRAINING_PAYMENT_33(33, "OUTLIER TRAINING PAYMENT", "Outlier training payment"), /**
   * ESRD PPS Payment calculated w/outlier, training, chronic comorbid.
   */
  OUTLIER_TRAINING_PAYMENT_WITH_CHRONIC_COMORBIDITY_34(34, "OUTLIER TRAINING PAYMENT WITH CHRONIC COMORBIDITY", "Outlier training payment with chronic comorbidity"), /**
   * ESRD PPS Payment calculated w/outlier, training, acute comorbid.
   */
  OUTLIER_TRAINING_PAYMENT_WITH_ACUTE_COMORBIDITY_35(35, "OUTLIER TRAINING PAYMENT WITH ACUTE COMORBIDITY", "Outlier training payment with acute comorbidity"), INVALID_PROVIDER_TYPE_52(52, "INVALID PROVIDER TYPE", "Invalid provider type"), INVALID_SPECIAL_PAYMENT_INDICATOR_53(53, "INVALID SPECIAL PAYMENT INDICATOR", "Invalid special payment indicator"), INVALID_DATE_OF_BIRTH_54(54, "INVALID DATE OF BIRTH", "Invalid date of birth"), INVALID_PATIENT_WEIGHT_55(55, "INVALID PATIENT WEIGHT", "Invalid patient weight"), INVALID_PATIENT_HEIGHT_56(56, "INVALID PATIENT HEIGHT", "Invalid patient height"), INVALID_REVENUE_CODE_57(57, "INVALID REVENUE CODE", "Invalid revenue code"), INVALID_CONDITION_CODE_58(58, "INVALID CONDITION CODE", "Invalid condition code"), /**
   * CBSA wage adjusted rate record not found.
   */
  CBSA_NOT_FOUND_60(60, "CBSA NOT FOUND", "CBSA not found"), HEIGHT_OUT_OF_RANGE_71(71, "HEIGHT OUT OF RANGE", "Height out of range"), MAXIMUM_WEIGHT_EXCEEDED_72(72, "MAXIMUM WEIGHT EXCEEDED", "Maximum weight exceeded"), INVALID_DIALYSIS_SESSION_COUNT_73(73, "INVALID DIALYSIS SESSION COUNT", "Invalid dialysis session count"), INVALID_SERVICE_DATE_74(74, "INVALID SERVICE DATE", "Invalid service date"), INVALID_DIALYSIS_START_DATE_75(75, "INVALID DIALYSIS START DATE", "Invalid dialysis start date"), INVALID_TOTAL_OUTLIER_PAYMENT_76(76, "INVALID TOTAL OUTLIER PAYMENT", "Invalid total outlier payment"), INVALID_COMORBID_CWF_RETURN_CODE_81(81, "INVALID COMORBID CWF RETURN CODE", "Invalid comorbid CWF return code"), UNSPECIFIED_ERROR_OCCURRED_99(99, "UNSPECIFIED ERROR OCCURRED", "Unspecified error occurred");
  private final int code;
  private final String desc;
  private final String exp;

  ReturnCode(int code, String desc, String exp) {
    this.code = code;
    this.desc = desc;
    this.exp = exp;
  }

  public ReturnCodeData toReturnCodeData() {
    final ReturnCodeData returnCodeData = new ReturnCodeData();
    final String paddedCode = StringUtils.leftPad(Integer.toString(this.getCode()), 2, "0");
    returnCodeData.setCode(paddedCode);
    returnCodeData.setDescription(this.getDesc());
    returnCodeData.setExplanation(this.getExp());
    return returnCodeData;
  }

  public static ReturnCode fromCode(int code) {
    final Optional<ReturnCode> matchedCode = Arrays.stream(ReturnCode.values()).filter(rc -> rc.getCode() == code).findFirst();
    return matchedCode.orElse(null);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getCode() {
    return this.code;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDesc() {
    return this.desc;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getExp() {
    return this.exp;
  }
}
