package gov.cms.fiss.pricers.esrd.core.rules.rules_2024;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import gov.cms.fiss.pricers.esrd.core.codes.ReturnCode;

/**
 * Applies the calculation results to the base response.
 *
 * <p>Converted from {@code 9100-MOVE-RESULTS} in the COBOL code.
 *
 * @since 2020
 */
public class SetCondition2025For2024AndEarlier
    implements CalculationRule<
        EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {

  @Override
  public boolean shouldExecute(EsrdPricerContext calculationContext) {
    return calculationContext.matchesReturnCode(ReturnCode.CALCULATION_STARTED_00);
  }

  @Override
  public void calculate(EsrdPricerContext calculationContext) {

    final EsrdClaimData billingRecord = calculationContext.getClaimData();

    // Claims prior to CY 2025 shouldn't have more than one Condition Code

    if (billingRecord.getConditionCodes() != null && billingRecord.getConditionCodes().size() > 1) {
      calculationContext.applyReturnCode(ReturnCode.INVALID_CONDITION_CODE_58);
    }

    // checks for no condition codes, and if no conditionCodes then sets to
    // "ESRD at a Facility"

    if (billingRecord.getConditionCodes() == null) {
      calculationContext.setEsrdFacility(true);
    }

    // AKI claims

    else if (calculationContext.hasConditionCode(EsrdPricerContext.CONDITION_CODE_AKI_MONTHLY_84)) {
      calculationContext.setAki84(true);
    }

    // ESRD claims

    else if (calculationContext.hasConditionCode(
        EsrdPricerContext.CONDITION_CODE_SELF_CARE_TRAINING_73)) {
      calculationContext.setEsrdTraining73(true);

    } else if (calculationContext.hasConditionCode(
        EsrdPricerContext.CONDITION_CODE_HOME_SERVICES_74)) {
      calculationContext.setEsrdHome74(true);

    } else if (calculationContext.hasConditionCode(
        EsrdPricerContext.CONDITION_CODE_IN_FACILITY_BACK_UP_76)) {
      calculationContext.setEsrdBackup76(true);

    } else if (calculationContext.hasConditionCode(
        EsrdPricerContext.CONDITION_CODE_SELF_CARE_RETRAINING_87)) {
      calculationContext.setEsrdRetraining87(true);

    } else {
      calculationContext.applyReturnCode(ReturnCode.INVALID_CONDITION_CODE_58);
    }
  }
}
