package gov.cms.fiss.pricers.esrd.core.rules.rules_2025;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.esrd.api.v2.*;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import gov.cms.fiss.pricers.esrd.core.codes.ReturnCode;

/**
 * Applies the calculation results to the base response.
 *
 * <p>Converted from {@code 9100-MOVE-RESULTS} in the COBOL code.
 *
 * @since 2020
 */
public class SetCondition2025
    implements CalculationRule<
        EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {

  @Override
  public boolean shouldExecute(EsrdPricerContext calculationContext) {
    return calculationContext.matchesReturnCode(ReturnCode.CALCULATION_STARTED_00);
  }

  @Override
  public void calculate(EsrdPricerContext calculationContext) {
    final EsrdClaimData billingRecord = calculationContext.getClaimData();

    if (billingRecord.getConditionCodes() == null) {
      calculationContext.setEsrdFacility(true);
    } else if (billingRecord.getConditionCodes().size() == 2) {
      assignConditionCodeBooleansForTwo(calculationContext);
    } else if (billingRecord.getConditionCodes().size() == 1) {
      assignConditionCodeBooleansForOne(calculationContext);
    } else calculationContext.applyReturnCode(ReturnCode.INVALID_CONDITION_CODE_58);
  }

  private void assignConditionCodeBooleansForTwo(EsrdPricerContext calculationContext) {
    if (calculationContext.hasConditionCode(EsrdPricerContext.CONDITION_CODE_AKI_MONTHLY_84)) {
      if (calculationContext.hasConditionCode(
          EsrdPricerContext.CONDITION_CODE_SELF_CARE_TRAINING_73)) {
        calculationContext.setAkiTraining8473(true);
        calculationContext.setAki84(true);
      } else if (calculationContext.hasConditionCode(
          EsrdPricerContext.CONDITION_CODE_HOME_SERVICES_74)) {
        calculationContext.setAkiHome8474(true);
        calculationContext.setAki84(true);
      } else if (calculationContext.hasConditionCode(
          EsrdPricerContext.CONDITION_CODE_SELF_CARE_RETRAINING_87)) {
        calculationContext.setAkiRetraining8487(true);
        calculationContext.setAki84(true);
      } else calculationContext.applyReturnCode(ReturnCode.INVALID_CONDITION_CODE_58);
    }
  }

  private void assignConditionCodeBooleansForOne(EsrdPricerContext calculationContext) {
    if (calculationContext.hasConditionCode(
        EsrdPricerContext.CONDITION_CODE_SELF_CARE_TRAINING_73)) {
      calculationContext.setEsrdTraining73(true);
    } else if (calculationContext.hasConditionCode(
        EsrdPricerContext.CONDITION_CODE_HOME_SERVICES_74)) {
      calculationContext.setEsrdHome74(true);
    } else if (calculationContext.hasConditionCode(
        EsrdPricerContext.CONDITION_CODE_IN_FACILITY_BACK_UP_76)) {
      calculationContext.setEsrdBackup76(true);
    } else if (calculationContext.hasConditionCode(
        EsrdPricerContext.CONDITION_CODE_AKI_MONTHLY_84)) {
      calculationContext.setAkiFacility84(true);
      calculationContext.setAki84(true);
    } else if (calculationContext.hasConditionCode(
        EsrdPricerContext.CONDITION_CODE_SELF_CARE_RETRAINING_87)) {
      calculationContext.setEsrdRetraining87(true);
    } else calculationContext.applyReturnCode(ReturnCode.INVALID_CONDITION_CODE_58);
  }
}
