// Generated by delombok at Tue Nov 26 15:50:35 UTC 2024
package gov.cms.fiss.pricers.esrd.api.v2;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.math.RoundingMode;
// TODO: It looks like all these values are always zero. Is that correct?
@Schema(description = "The bundled payment information.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-BUNDLED-DATA", value = "<structure>")})})
public class BundledPaymentData {
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The blended composite rate amount.", example = "50250.99", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-2011-BLEND-COMP-RATE", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  @FixedValue
  private BigDecimal blendedCompositeRate;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The blended outlier rate amount.", example = "67.24", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-2011-BLEND-OUTLIER-RATE", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  @FixedValue
  private BigDecimal blendedOutlierRate;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The blended payment rate amount.", example = "6500.25", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-2011-BLEND-PPS-RATE", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  @FixedValue
  private BigDecimal blendedPaymentRate;
  @Schema(description = "The payment code that corresponds to the common working file return code for " + "the comorbidity.", example = "10", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-2011-COMORBID-PAY", value = "PIC X(02)")})})
  @ValidCommonWorkingFileReturnCode
  private String comorbidityPaymentCode;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The full composite rate amount.", example = "950.80", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-2011-FULL-COMP-RATE", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal fullCompositeRate;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The full outlier rate amount.", example = "8800.35", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-2011-FULL-OUTLIER-RATE", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal fullOutlierRate;
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The full payment rate amount.", example = "80.90", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-2011-FULL-PPS-RATE", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal fullPaymentRate;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBlendedCompositeRate() {
    return this.blendedCompositeRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBlendedOutlierRate() {
    return this.blendedOutlierRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBlendedPaymentRate() {
    return this.blendedPaymentRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getComorbidityPaymentCode() {
    return this.comorbidityPaymentCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFullCompositeRate() {
    return this.fullCompositeRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFullOutlierRate() {
    return this.fullOutlierRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFullPaymentRate() {
    return this.fullPaymentRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBlendedCompositeRate(final BigDecimal blendedCompositeRate) {
    this.blendedCompositeRate = blendedCompositeRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBlendedOutlierRate(final BigDecimal blendedOutlierRate) {
    this.blendedOutlierRate = blendedOutlierRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBlendedPaymentRate(final BigDecimal blendedPaymentRate) {
    this.blendedPaymentRate = blendedPaymentRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setComorbidityPaymentCode(final String comorbidityPaymentCode) {
    this.comorbidityPaymentCode = comorbidityPaymentCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFullCompositeRate(final BigDecimal fullCompositeRate) {
    this.fullCompositeRate = fullCompositeRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFullOutlierRate(final BigDecimal fullOutlierRate) {
    this.fullOutlierRate = fullOutlierRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFullPaymentRate(final BigDecimal fullPaymentRate) {
    this.fullPaymentRate = fullPaymentRate;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof BundledPaymentData)) return false;
    final BundledPaymentData other = (BundledPaymentData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$blendedCompositeRate = this.getBlendedCompositeRate();
    final java.lang.Object other$blendedCompositeRate = other.getBlendedCompositeRate();
    if (this$blendedCompositeRate == null ? other$blendedCompositeRate != null : !this$blendedCompositeRate.equals(other$blendedCompositeRate)) return false;
    final java.lang.Object this$blendedOutlierRate = this.getBlendedOutlierRate();
    final java.lang.Object other$blendedOutlierRate = other.getBlendedOutlierRate();
    if (this$blendedOutlierRate == null ? other$blendedOutlierRate != null : !this$blendedOutlierRate.equals(other$blendedOutlierRate)) return false;
    final java.lang.Object this$blendedPaymentRate = this.getBlendedPaymentRate();
    final java.lang.Object other$blendedPaymentRate = other.getBlendedPaymentRate();
    if (this$blendedPaymentRate == null ? other$blendedPaymentRate != null : !this$blendedPaymentRate.equals(other$blendedPaymentRate)) return false;
    final java.lang.Object this$comorbidityPaymentCode = this.getComorbidityPaymentCode();
    final java.lang.Object other$comorbidityPaymentCode = other.getComorbidityPaymentCode();
    if (this$comorbidityPaymentCode == null ? other$comorbidityPaymentCode != null : !this$comorbidityPaymentCode.equals(other$comorbidityPaymentCode)) return false;
    final java.lang.Object this$fullCompositeRate = this.getFullCompositeRate();
    final java.lang.Object other$fullCompositeRate = other.getFullCompositeRate();
    if (this$fullCompositeRate == null ? other$fullCompositeRate != null : !this$fullCompositeRate.equals(other$fullCompositeRate)) return false;
    final java.lang.Object this$fullOutlierRate = this.getFullOutlierRate();
    final java.lang.Object other$fullOutlierRate = other.getFullOutlierRate();
    if (this$fullOutlierRate == null ? other$fullOutlierRate != null : !this$fullOutlierRate.equals(other$fullOutlierRate)) return false;
    final java.lang.Object this$fullPaymentRate = this.getFullPaymentRate();
    final java.lang.Object other$fullPaymentRate = other.getFullPaymentRate();
    if (this$fullPaymentRate == null ? other$fullPaymentRate != null : !this$fullPaymentRate.equals(other$fullPaymentRate)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof BundledPaymentData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $blendedCompositeRate = this.getBlendedCompositeRate();
    result = result * PRIME + ($blendedCompositeRate == null ? 43 : $blendedCompositeRate.hashCode());
    final java.lang.Object $blendedOutlierRate = this.getBlendedOutlierRate();
    result = result * PRIME + ($blendedOutlierRate == null ? 43 : $blendedOutlierRate.hashCode());
    final java.lang.Object $blendedPaymentRate = this.getBlendedPaymentRate();
    result = result * PRIME + ($blendedPaymentRate == null ? 43 : $blendedPaymentRate.hashCode());
    final java.lang.Object $comorbidityPaymentCode = this.getComorbidityPaymentCode();
    result = result * PRIME + ($comorbidityPaymentCode == null ? 43 : $comorbidityPaymentCode.hashCode());
    final java.lang.Object $fullCompositeRate = this.getFullCompositeRate();
    result = result * PRIME + ($fullCompositeRate == null ? 43 : $fullCompositeRate.hashCode());
    final java.lang.Object $fullOutlierRate = this.getFullOutlierRate();
    result = result * PRIME + ($fullOutlierRate == null ? 43 : $fullOutlierRate.hashCode());
    final java.lang.Object $fullPaymentRate = this.getFullPaymentRate();
    result = result * PRIME + ($fullPaymentRate == null ? 43 : $fullPaymentRate.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "BundledPaymentData(blendedCompositeRate=" + this.getBlendedCompositeRate() + ", blendedOutlierRate=" + this.getBlendedOutlierRate() + ", blendedPaymentRate=" + this.getBlendedPaymentRate() + ", comorbidityPaymentCode=" + this.getComorbidityPaymentCode() + ", fullCompositeRate=" + this.getFullCompositeRate() + ", fullOutlierRate=" + this.getFullOutlierRate() + ", fullPaymentRate=" + this.getFullPaymentRate() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BundledPaymentData() {
  }
}
